/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.gdface.utils.Assert;
import net.gdface.utils.Platform;

public class NativeUtils {
    private static final int BUFFER_SIZE = 8192;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static File temporaryDir;

    private NativeUtils() {
    }

    public static synchronized void loadLibraryFromJar(String path, Class<?> loadClass) throws IOException {
        File temp = NativeUtils.copyToTempFromJar(path, loadClass);
        System.load(temp.getAbsolutePath());
    }

    public static synchronized File copyToTempFromJar(String path, Class<?> loadClass) throws IOException {
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            temporaryDir.deleteOnExit();
        }
        File temp = new File(temporaryDir, path);
        Class clazz = loadClass == null ? NativeUtils.class : loadClass;
        try (InputStream is = clazz.getResourceAsStream(path);){
            NativeUtils.copy(is, temp);
            temp.deleteOnExit();
            File file = temp;
            return file;
        }
    }

    public static File copyToTempFromJar(String path) throws IOException {
        return NativeUtils.copyToTempFromJar(path, null);
    }

    public static void loadLibraryFromJar(String path) throws IOException {
        NativeUtils.loadLibraryFromJar(path, null);
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }

    public static void loadFromJar(String name) throws IOException {
        String prefix = Platform.getNativeLibraryResourcePrefix();
        try {
            NativeUtils.loadLibraryFromJar("/lib/" + prefix + "/" + System.mapLibraryName(name));
        }
        catch (FileNotFoundException e) {
            NativeUtils.loadLibraryFromJar("/" + prefix + "/" + System.mapLibraryName(name));
        }
    }

    public static File getTemporaryDir() {
        return temporaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream in, File target) throws IOException {
        target.delete();
        File parent = target.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(target);){
            long l = NativeUtils.copy(in, out);
            return l;
        }
    }

    private static long copy(InputStream source, OutputStream dest) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            dest.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    private static String resolveName(String libprefix, String name) throws IOException {
        String prefix = Platform.getNativeLibraryResourcePrefix();
        if (libprefix == null) {
            libprefix = "/";
        }
        if (!libprefix.startsWith("/")) {
            throw new IllegalArgumentException("libprefix(" + libprefix + ") must starts with '/'");
        }
        if (!libprefix.endsWith("/")) {
            libprefix = libprefix.concat("/");
        }
        return libprefix + prefix + "/" + System.mapLibraryName(name);
    }

    public static void loadLibraryFromResource(String name, Class<?> loaderClass) throws IOException {
        String path;
        URL url;
        if (Platform.isAndroid()) {
            System.loadLibrary(name);
            return;
        }
        if (null == loaderClass) {
            loaderClass = NativeUtils.class;
        }
        if (null == (url = loaderClass.getResource(path = NativeUtils.resolveName("/lib/", name)))) {
            path = NativeUtils.resolveName(null, name);
            url = loaderClass.getResource(path);
        }
        Assert.notNull(url, "url", "NOT FOUND library:" + path);
        if (url.getProtocol().equals("file")) {
            System.load(url.getPath());
            return;
        }
        if (url.getProtocol().equals("jar")) {
            NativeUtils.loadFromJar(name);
            return;
        }
        throw new UnsupportedOperationException();
    }
}

