/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.gdface.utils.Assert;
import net.gdface.utils.BaseParameterNames;
import org.apache.bytecode.ChainedParamReader;

public class ParameterNames
extends BaseParameterNames {
    private final Map<Class<?>, ChainedParamReader> readers = new HashMap();

    public ParameterNames(Class<?> clazz) {
        super(clazz);
        if (null != clazz) {
            try {
                Class<?> c = clazz;
                do {
                    this.readers.put(c, new ChainedParamReader(c));
                } while (null != (c = c.getSuperclass()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected String[] doGetParameterNames(Member member) {
        if (null == this.clazz) {
            return null;
        }
        Assert.notNull(member, "member");
        Class<?> declaringClass = member.getDeclaringClass();
        ChainedParamReader reader = this.readers.get(declaringClass);
        if (null == reader) {
            throw new IllegalArgumentException(String.format("%s is not member of %s", member.toString(), declaringClass.getName()));
        }
        String[] parameterNames = null;
        if (member instanceof Method) {
            parameterNames = reader.getParameterNames((Method)member);
        } else if (member instanceof Constructor) {
            parameterNames = reader.getParameterNames((Constructor)member);
        }
        return parameterNames;
    }
}

