/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import gu.sql2java.BaseBean;
import gu.sql2java.RowMetaData;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.MorePropertyDescriptor;

public class BaseRowPropertyDescriptor
extends PropertyDescriptor
implements MorePropertyDescriptor {
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyType;

    public BaseRowPropertyDescriptor(Class<?> propertyType, String name) throws IntrospectionException {
        super(Preconditions.checkNotNull(name, "field is null"), null, null);
        this.propertyType = Preconditions.checkNotNull(propertyType, "propertyType of %s is null", (Object)name);
        try {
            this.readMethod = BaseRowPropertyDescriptor.class.getMethod("readMethod", Object.class, String.class);
            this.writeMethod = BaseRowPropertyDescriptor.class.getMethod("writeMethod", Object.class, String.class, Object.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public BaseRowPropertyDescriptor(RowMetaData rowMetaData, String name) throws IntrospectionException {
        this(Preconditions.checkNotNull(rowMetaData, "rowMetaData is null").columnTypeOf(name), name);
    }

    public static Object readMethod(Object bean, String name) {
        if (bean instanceof BaseBean) {
            return ((BaseBean)bean).getValue(name);
        }
        return null;
    }

    public static void writeMethod(Object bean, String name, Object value) {
        if (bean instanceof BaseBean) {
            ((BaseBean)bean).setValue(name, value);
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }
}

