/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.beanutils.MorePropertyDescriptor;

public class FieldPropertyDescriptor
extends PropertyDescriptor
implements MorePropertyDescriptor {
    private static final Map<String, Field> fields = new Hashtable<String, Field>();
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyType;

    FieldPropertyDescriptor(Field field) throws IntrospectionException {
        super(Preconditions.checkNotNull(field, "field is null").getName(), null, null);
        this.propertyType = field.getType();
        fields.put(field.getName(), field);
        try {
            this.readMethod = FieldPropertyDescriptor.class.getMethod("readMethod", Object.class, String.class);
            this.writeMethod = FieldPropertyDescriptor.class.getMethod("writeMethod", Object.class, String.class, Object.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private static Field getAccessibleField(String name) {
        Field field = Preconditions.checkNotNull(fields.get(name), "INVALID field name %s", (Object)name);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Object readMethod(Object bean, String name) {
        if (null != bean) {
            try {
                return FieldPropertyDescriptor.getAccessibleField(name).get(bean);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void writeMethod(Object bean, String name, Object value) {
        if (null != bean) {
            try {
                FieldPropertyDescriptor.getAccessibleField(name).set(bean, value);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }
}

