/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.beanutils.MorePropertyDescriptor;

public class MapPropertyDescriptor
extends PropertyDescriptor
implements MorePropertyDescriptor {
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyType;

    public MapPropertyDescriptor(Class<?> propertyType, String name) throws IntrospectionException {
        super(Preconditions.checkNotNull(name, "field is null").replace(".", "_"), null, null);
        this.setDisplayName(name);
        this.propertyType = MoreObjects.firstNonNull(propertyType, Object.class);
        try {
            this.readMethod = MapPropertyDescriptor.class.getMethod("readMethod", Object.class, String.class);
            this.writeMethod = MapPropertyDescriptor.class.getMethod("writeMethod", Object.class, String.class, Object.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static Object readMethod(Object bean, String name) {
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        return null;
    }

    public static void writeMethod(Object bean, String name, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(name, value);
        }
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }
}

