/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import gu.sql2java.BaseRow;
import gu.sql2java.RowMetaData;
import gu.sql2java.excel.config.PropertyConfig;
import gu.sql2java.excel.utils.FieldUtils;
import gu.sql2java.utils.CaseSupport;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.gdface.utils.ArrayUtils;
import org.apache.commons.beanutils.BaseRowPropertyDescriptor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.FieldPropertyDescriptor;
import org.apache.commons.beanutils.MorePropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MorePropertyUtilsBean
extends PropertyUtilsBean {
    private final Log log = LogFactory.getLog(MorePropertyUtilsBean.class);
    private final Resolver resolver = new DefaultResolver();
    private final Function<String, PropertyConfig> configSupplier;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ThreadLocal<String> curentNestedName = new ThreadLocal();

    public MorePropertyUtilsBean() {
        this(null);
    }

    public MorePropertyUtilsBean(Function<String, PropertyConfig> configSupplier) {
        this.configSupplier = configSupplier;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor descriptor = super.getPropertyDescriptor(bean, name);
        if (null == descriptor) {
            try {
                RowMetaData metaData;
                if (bean instanceof BaseRow && (metaData = ((BaseRow)bean).fetchMetaData()).columnIDOf(name) >= 0) {
                    return new BaseRowPropertyDescriptor(metaData, name);
                }
                Field field = FieldUtils.getField(bean.getClass(), name, true);
                if (null == field) {
                    if (CaseSupport.isSnakelcase((String)name)) {
                        field = FieldUtils.getField(bean.getClass(), CaseSupport.toCamelcase((String)name), true);
                    } else if (CaseSupport.isCamelcase((String)name)) {
                        field = FieldUtils.getField(bean.getClass(), CaseSupport.toSnakecase((String)name), true);
                    }
                }
                if (null != field) {
                    return new FieldPropertyDescriptor(field);
                }
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    public Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        PropertyConfig config;
        String methodName;
        if (descriptor instanceof MorePropertyDescriptor) {
            return descriptor.getWriteMethod();
        }
        if (null != this.configSupplier && !(methodName = (config = this.configSupplier.apply(curentNestedName.get())).getColumnConfig().getWriteMethod()).isEmpty()) {
            try {
                Field field = FieldUtils.getField(clazz, descriptor.getName(), true);
                return clazz.getMethod(methodName, null != field ? field.getType() : descriptor.getPropertyType());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
        return super.getWriteMethod(clazz, descriptor);
    }

    Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        PropertyConfig config;
        String methodName;
        if (descriptor instanceof MorePropertyDescriptor) {
            return descriptor.getReadMethod();
        }
        if (null != this.configSupplier && !(methodName = (config = this.configSupplier.apply(curentNestedName.get())).getColumnConfig().getReadMethod()).isEmpty()) {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
        return super.getReadMethod(clazz, descriptor);
    }

    @Override
    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, name, EMPTY_OBJECT_ARRAY);
        return value;
    }

    @Override
    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean.getClass(), descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean.getClass() + "'");
        }
        Object[] values = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")");
        }
        this.invokeMethod(writeMethod, bean, name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        curentNestedName.set("");
        try {
            while (this.resolver.hasNested(name)) {
                String next = this.resolver.next(name);
                Object nestedBean = null;
                if ((bean = this.tryParseJsonIfString(bean)) instanceof Map) {
                    AtomicReference<String> ref = new AtomicReference<String>(next);
                    nestedBean = this.getPropertyOfMapBean((Map)bean, ref);
                    if (!next.equals(ref.get())) {
                        next = ref.get();
                    }
                } else if (this.resolver.isMapped(next)) {
                    nestedBean = this.getMappedProperty(bean, next);
                } else if (this.resolver.isIndexed(next)) {
                    nestedBean = this.getIndexedProperty(bean, next);
                } else {
                    this.concat(next);
                    nestedBean = this.getSimpleProperty(bean, next);
                }
                if (nestedBean == null) {
                    Object var5_5 = null;
                    return var5_5;
                }
                bean = nestedBean;
                name = this.resolver.remove(name);
            }
            this.concat(name);
            bean = this.tryParseJsonIfString(bean);
            bean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, new AtomicReference<String>(name)) : (this.resolver.isMapped(name) ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
            Object object = bean;
            return object;
        }
        finally {
            curentNestedName.remove();
        }
    }

    private void concat(String next) {
        String n = curentNestedName.get();
        if (!n.isEmpty()) {
            n = n.concat(".");
        }
        n = n.concat(next);
        curentNestedName.set(n);
    }

    private Object getPropertyOfMapBean(Map<?, ?> bean, AtomicReference<String> propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String p;
        if (bean.containsKey(propertyName.get())) {
            return super.getPropertyOfMapBean(bean, propertyName.get());
        }
        Object value = null;
        if (CaseSupport.isCamelcase((String)propertyName.get())) {
            String p2 = CaseSupport.toSnakecase((String)propertyName.get());
            if (bean.containsKey(p2)) {
                value = bean.get(p2);
                propertyName.set(p2);
            }
        } else if (CaseSupport.isSnakelcase((String)propertyName.get()) && bean.containsKey(p = CaseSupport.toSnakecase((String)propertyName.get()))) {
            value = bean.get(p);
            propertyName.set(p);
        }
        return value;
    }

    private Object invokeMethod(Method method, Object bean, String name, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (MorePropertyDescriptor.class.isAssignableFrom(method.getDeclaringClass())) {
            return method.invoke(null, ArrayUtils.addAll(new Object[]{bean, name}, values));
        }
        return this.invokeMethod(method, bean, values);
    }

    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean, values);
        }
        catch (NullPointerException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause((Throwable)(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\"")), (Throwable)cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
        catch (IllegalArgumentException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause((Throwable)(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\"")), (Throwable)cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
    }

    private Object tryParseJsonIfString(Object bean) {
        if (bean instanceof String) {
            try {
                return JSON.parseObject((String)bean);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(String.format("INVALID String %s for bean", bean));
            }
        }
        return bean;
    }
}

