/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;

public class ComposableRequestProcessor
extends RequestProcessor {
    private static final Class[] SERVLET_ACTION_CONTEXT_CTOR_SIGNATURE = new Class[]{ServletContext.class, HttpServletRequest.class, HttpServletResponse.class};
    public static final String ACTION_CONTEXT_CLASS = "ACTION_CONTEXT_CLASS";
    protected static final Log LOG = LogFactory.getLog(ComposableRequestProcessor.class);
    protected CatalogFactory catalogFactory = null;
    protected Catalog catalog = null;
    protected Command command = null;
    private Class actionContextClass;
    private Constructor servletActionContextConstructor = null;

    public void destroy() {
        super.destroy();
        this.catalogFactory = null;
        this.catalog = null;
        this.command = null;
        this.actionContextClass = null;
        this.servletActionContextConstructor = null;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        LOG.info("Initializing composable request processor for module prefix '" + moduleConfig.getPrefix() + "'");
        super.init(servlet, moduleConfig);
        this.initCatalogFactory(servlet, moduleConfig);
        ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
        String catalogName = controllerConfig.getCatalog();
        this.catalog = this.catalogFactory.getCatalog(catalogName);
        if (this.catalog == null) {
            throw new ServletException("Cannot find catalog '" + catalogName + "'");
        }
        String commandName = controllerConfig.getCommand();
        this.command = this.catalog.getCommand(commandName);
        if (this.command == null) {
            throw new ServletException("Cannot find command '" + commandName + "'");
        }
        this.setActionContextClassName(controllerConfig.getProperty(ACTION_CONTEXT_CLASS));
    }

    private void setActionContextClass(Class actionContextClass) {
        this.actionContextClass = actionContextClass;
        this.servletActionContextConstructor = actionContextClass != null ? ConstructorUtils.getAccessibleConstructor(actionContextClass, SERVLET_ACTION_CONTEXT_CTOR_SIGNATURE) : null;
    }

    private void setActionContextClassName(String className) throws ServletException {
        if (className != null && className.trim().length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setActionContextClassName: requested context class: " + className);
            }
            try {
                Class actionContextClass = RequestUtils.applicationClass(className);
                if (!ActionContext.class.isAssignableFrom(actionContextClass)) {
                    throw new UnavailableException("ActionContextClass [" + className + "]" + " must implement ActionContext interface.");
                }
                this.setActionContextClass(actionContextClass);
            }
            catch (ClassNotFoundException e) {
                throw new UnavailableException("ActionContextClass " + className + " not found.");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setActionContextClassName: no className specified");
            }
            this.setActionContextClass(null);
        }
    }

    protected void initCatalogFactory(ActionServlet servlet, ModuleConfig moduleConfig) {
        if (this.catalogFactory != null) {
            return;
        }
        this.catalogFactory = CatalogFactory.getInstance();
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request = this.processMultipart(request);
        ActionContext context = this.contextInstance(request, response);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using processing chain for this request");
            }
            this.command.execute(context);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
        context.release();
    }

    protected ActionContext contextInstance(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionContext context = this.createActionContextInstance(this.getServletContext(), request, response);
        this.initializeActionContext(context);
        return context;
    }

    protected ActionContext createActionContextInstance(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.actionContextClass == null) {
            return new ServletActionContext(servletContext, request, response);
        }
        try {
            if (this.servletActionContextConstructor == null) {
                return (ActionContext)this.actionContextClass.newInstance();
            }
            return (ActionContext)this.servletActionContextConstructor.newInstance(servletContext, request, response);
        }
        catch (Exception e) {
            throw new ServletException("Error creating ActionContext instance of type " + this.actionContextClass, e);
        }
    }

    protected void initializeActionContext(ActionContext context) {
        if (context instanceof ServletActionContext) {
            ((ServletActionContext)context).setActionServlet(this.servlet);
        }
        context.setModuleConfig(this.moduleConfig);
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return request;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return new MultipartRequestWrapper(request);
        }
        return request;
    }

    public void setCatalogFactory(CatalogFactory catalogFactory) {
        this.catalogFactory = catalogFactory;
    }
}

