/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionFormBean;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ConfigHelperInterface;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class ConfigHelper
implements ConfigHelperInterface {
    private ServletContext application = null;
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ActionForward forward = null;

    public ConfigHelper() {
    }

    public ConfigHelper(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setResources(application, request, response);
    }

    public void setApplication(ServletContext application) {
        this.application = application;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        if (this.request == null) {
            this.setSession(null);
        } else {
            this.setSession(this.request.getSession());
        }
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setForward(ActionForward forward) {
        this.forward = forward;
    }

    public void setResources(ServletContext application, HttpServletRequest request, HttpServletResponse response) {
        this.setApplication(application);
        this.setRequest(request);
        this.setResponse(response);
    }

    public ActionMessages getActionMessages() {
        if (this.application == null) {
            return null;
        }
        return (ActionMessages)this.application.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
    }

    public MessageResources getMessageResources() {
        if (this.application == null) {
            return null;
        }
        return (MessageResources)this.application.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public String getServletMapping() {
        if (this.application == null) {
            return null;
        }
        return (String)this.application.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public String getToken() {
        if (this.session == null) {
            return null;
        }
        return (String)this.session.getAttribute("org.apache.struts.action.TOKEN");
    }

    public Throwable getException() {
        if (this.request == null) {
            return null;
        }
        return (Throwable)this.request.getAttribute("org.apache.struts.action.EXCEPTION");
    }

    public MultipartRequestWrapper getMultipartRequestWrapper() {
        if (this.request == null) {
            return null;
        }
        return (MultipartRequestWrapper)this.request.getAttribute("org.apache.struts.action.mapping.multipartclass");
    }

    public ActionMapping getMapping() {
        if (this.request == null) {
            return null;
        }
        return (ActionMapping)this.request.getAttribute("org.apache.struts.action.mapping.instance");
    }

    public boolean isMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return false;
        }
        return resources.isPresent(RequestUtils.getUserLocale(this.request, null), key);
    }

    public ActionForm getActionForm() {
        ActionMapping mapping = this.getMapping();
        if (mapping == null) {
            return null;
        }
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        ActionForm instance = "request".equals(mapping.getScope()) ? (ActionForm)this.request.getAttribute(attribute) : (ActionForm)this.session.getAttribute(attribute);
        return instance;
    }

    public ActionFormBean getFormBean(String name) {
        return null;
    }

    public ActionForward getActionForward(String name) {
        return null;
    }

    public ActionMapping getActionMapping(String path) {
        return null;
    }

    public String getActionMappingName(String action) {
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        if (value.startsWith("/")) {
            return value;
        }
        return "/" + value;
    }

    public String getActionMappingURL(String action) {
        StringBuffer value = new StringBuffer(this.request.getContextPath());
        String servletMapping = this.getServletMapping();
        if (servletMapping != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = this.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public String getEncodeURL(String url) {
        if (this.session != null && this.response != null) {
            boolean redirect = false;
            if (this.forward != null) {
                redirect = this.forward.getRedirect();
            }
            if (redirect) {
                return this.response.encodeRedirectURL(url);
            }
            return this.response.encodeURL(url);
        }
        return url;
    }

    public String getOrigRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = RequestUtils.requestToServerUriStringBuffer(this.request);
        return result.toString();
    }

    public String getBaseRef() {
        if (this.request == null) {
            return null;
        }
        StringBuffer result = RequestUtils.requestToServerStringBuffer(this.request);
        String path = this.forward == null ? this.request.getRequestURI() : this.request.getContextPath() + this.forward.getPath();
        result.append(path);
        return result.toString();
    }

    public String getLink(String name) {
        ActionForward forward = this.getActionForward(name);
        if (forward == null) {
            return null;
        }
        StringBuffer path = new StringBuffer(this.request.getContextPath());
        path.append(forward.getPath());
        return this.getEncodeURL(path.toString());
    }

    public String getMessage(String key) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key);
    }

    public String getMessage(String key, Object[] args) {
        MessageResources resources = this.getMessageResources();
        if (resources == null) {
            return null;
        }
        if (args == null) {
            return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key);
        }
        return resources.getMessage(RequestUtils.getUserLocale(this.request, null), key, args);
    }

    public String getAction(String path) {
        return this.getEncodeURL(this.getActionMappingURL(path));
    }

    public String link(String name) {
        return this.getLink(name);
    }

    public String message(String key) {
        return this.getMessage(key);
    }

    public String message(String key, Object[] args) {
        return this.getMessage(key, args);
    }

    public String action(String path) {
        return this.getAction(path);
    }
}

