/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.html.SelectTag;
import org.apache.struts.util.IteratorAdapter;
import org.apache.struts.util.MessageResources;

public class OptionsCollectionTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    protected boolean filter = true;
    protected String label = "label";
    protected String name = "org.apache.struts.taglib.html.BEAN";
    protected String property = null;
    private String style = null;
    private String styleClass = null;
    protected String value = "value";

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        SelectTag selectTag = (SelectTag)this.pageContext.getAttribute("org.apache.struts.taglib.html.SELECT");
        if (selectTag == null) {
            JspException e = new JspException(messages.getMessage("optionsCollectionTag.select"));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        Object collection = TagUtils.getInstance().lookup(this.pageContext, this.name, this.property, null);
        if (collection == null) {
            JspException e = new JspException(messages.getMessage("optionsCollectionTag.collection"));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        Iterator iter = this.getIterator(collection);
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            Throwable t;
            JspException jspe;
            Object bean = iter.next();
            Object beanLabel = null;
            Object beanValue = null;
            try {
                beanLabel = PropertyUtils.getProperty(bean, this.label);
                if (beanLabel == null) {
                    beanLabel = "";
                }
            }
            catch (IllegalAccessException e) {
                jspe = new JspException(messages.getMessage("getter.access", (Object)this.label, bean));
                TagUtils.getInstance().saveException(this.pageContext, jspe);
                throw jspe;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                JspException jspe2 = new JspException(messages.getMessage("getter.result", (Object)this.label, (Object)t.toString()));
                TagUtils.getInstance().saveException(this.pageContext, jspe2);
                throw jspe2;
            }
            catch (NoSuchMethodException e) {
                jspe = new JspException(messages.getMessage("getter.method", (Object)this.label, bean));
                TagUtils.getInstance().saveException(this.pageContext, jspe);
                throw jspe;
            }
            try {
                beanValue = PropertyUtils.getProperty(bean, this.value);
                if (beanValue == null) {
                    beanValue = "";
                }
            }
            catch (IllegalAccessException e) {
                jspe = new JspException(messages.getMessage("getter.access", (Object)this.value, bean));
                TagUtils.getInstance().saveException(this.pageContext, jspe);
                throw jspe;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                JspException jspe3 = new JspException(messages.getMessage("getter.result", (Object)this.value, (Object)t.toString()));
                TagUtils.getInstance().saveException(this.pageContext, jspe3);
                throw jspe3;
            }
            catch (NoSuchMethodException e) {
                jspe = new JspException(messages.getMessage("getter.method", (Object)this.value, bean));
                TagUtils.getInstance().saveException(this.pageContext, jspe);
                throw jspe;
            }
            String stringLabel = beanLabel.toString();
            String stringValue = beanValue.toString();
            this.addOption(sb, stringLabel, stringValue, selectTag.isMatched(stringValue));
        }
        TagUtils.getInstance().write(this.pageContext, sb.toString());
        return 0;
    }

    public void release() {
        super.release();
        this.filter = true;
        this.label = "label";
        this.name = "org.apache.struts.taglib.html.BEAN";
        this.property = null;
        this.style = null;
        this.styleClass = null;
        this.value = "value";
    }

    protected void addOption(StringBuffer sb, String label, String value, boolean matched) {
        sb.append("<option value=\"");
        if (this.filter) {
            sb.append(TagUtils.getInstance().filter(value));
        } else {
            sb.append(value);
        }
        sb.append("\"");
        if (matched) {
            sb.append(" selected=\"selected\"");
        }
        if (this.style != null) {
            sb.append(" style=\"");
            sb.append(this.style);
            sb.append("\"");
        }
        if (this.styleClass != null) {
            sb.append(" class=\"");
            sb.append(this.styleClass);
            sb.append("\"");
        }
        sb.append(">");
        if (this.filter) {
            sb.append(TagUtils.getInstance().filter(label));
        } else {
            sb.append(label);
        }
        sb.append("</option>\r\n");
    }

    protected Iterator getIterator(Object collection) throws JspException {
        if (collection.getClass().isArray()) {
            collection = Arrays.asList((Object[])collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).iterator();
        }
        if (collection instanceof Iterator) {
            return (Iterator)((Object)collection);
        }
        if (collection instanceof Map) {
            return ((Map)((Object)collection)).entrySet().iterator();
        }
        if (collection instanceof Enumeration) {
            return new IteratorAdapter((Enumeration)((Object)collection));
        }
        throw new JspException(messages.getMessage("optionsCollectionTag.iterator", (Object)collection.toString()));
    }
}

