/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.taglib.ComponentConstants;

public class DefinitionsUtil
extends TilesUtil
implements ComponentConstants {
    protected static Log log = LogFactory.getLog(DefinitionsUtil.class);
    public static int userDebugLevel = 0;
    public static final int NO_DEBUG = 0;
    public static final String DEFINITIONS_CONFIG_USER_DEBUG_LEVEL = "definitions-debug";
    public static final String DEFINITIONS_FACTORY_CLASSNAME = "definitions-factory-class";
    public static final String DEFINITIONS_FACTORY = "org.apache.struts.tiles.DEFINITIONS_FACTORY";
    public static final String ACTION_DEFINITION = "org.apache.struts.tiles.ACTION_DEFINITION";

    public static DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, Map properties, String classname) throws DefinitionsFactoryException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        try {
            factoryConfig.populate(properties);
        }
        catch (Exception ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Can't populate config object from properties map", ex);
        }
        if (classname != null) {
            factoryConfig.setFactoryClassname(classname);
        }
        return DefinitionsUtil.createDefinitionsFactory(servletContext, factoryConfig);
    }

    public static DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, Map properties) throws DefinitionsFactoryException {
        return DefinitionsUtil.createDefinitionsFactory(servletContext, properties, null);
    }

    public static DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, ServletConfig servletConfig) throws DefinitionsFactoryException {
        DefinitionsFactoryConfig factoryConfig = DefinitionsUtil.readFactoryConfig(servletConfig);
        return DefinitionsUtil.createDefinitionsFactory(servletContext, factoryConfig);
    }

    public static DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, ServletConfig servletConfig, boolean checkIfExist) throws DefinitionsFactoryException {
        DefinitionsFactory factory;
        if (checkIfExist && (factory = DefinitionsUtil.getDefinitionsFactory(servletContext)) != null) {
            return factory;
        }
        return DefinitionsUtil.createDefinitionsFactory(servletContext, servletConfig);
    }

    public static DefinitionsFactory getDefinitionsFactory(ServletContext servletContext) {
        return (DefinitionsFactory)servletContext.getAttribute(DEFINITIONS_FACTORY);
    }

    public static ComponentDefinition getActionDefinition(ServletRequest request) {
        return (ComponentDefinition)request.getAttribute(ACTION_DEFINITION);
    }

    public static void setActionDefinition(ServletRequest request, ComponentDefinition definition) {
        request.setAttribute(ACTION_DEFINITION, definition);
    }

    public static void removeActionDefinition(ServletRequest request, ComponentDefinition definition) {
        request.removeAttribute(ACTION_DEFINITION);
    }

    public static void populateDefinitionsFactoryConfig(DefinitionsFactoryConfig factoryConfig, ServletConfig servletConfig) throws IllegalAccessException, InvocationTargetException {
        ServletPropertiesMap properties = new ServletPropertiesMap(servletConfig);
        factoryConfig.populate(properties);
    }

    protected static DefinitionsFactoryConfig readFactoryConfig(ServletConfig servletConfig) throws DefinitionsFactoryException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        try {
            DefinitionsUtil.populateDefinitionsFactoryConfig(factoryConfig, servletConfig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DefinitionsFactoryException("Can't populate DefinitionsFactoryConfig class from 'web.xml'.", ex);
        }
        return factoryConfig;
    }

    static class ServletPropertiesMap
    extends HashMap {
        ServletPropertiesMap(ServletConfig config) {
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.put(key, config.getInitParameter(key));
            }
        }
    }
}

