package gu.sql2java.generator;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;

import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.MiscellaneousUtils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
/**
 * 终端命令行配置参数
 * @author guyadong
 *
 */
public class GeneratorConfig extends BaseAppConfig implements GeneratorConstants {
	private static final Logger logger = LoggerFactory.getLogger(GeneratorConfig.class);

	static final GeneratorConfig CONFIG = new GeneratorConfig();

	private File propFile;
	private String classPath;
	private URLClassLoader classLoader;
	public GeneratorConfig() {
		super(true);
		options.addOption(Option.builder(PROPFILE_OPTION).longOpt(PROPFILE_OPTION_LONG)
				.desc(PROPFILE_OPTION_DESC).numberOfArgs(1).type(File.class).required(true).build());

		options.addOption(Option.builder(CLASSPATH_OPTION).longOpt(CLASSPATH_OPTION_LONG)
				.desc(CLASSPATH_OPTION_DESC).numberOfArgs(1).build());
		
		defaultValue.setProperty(PROPFILE_OPTION_LONG, null);
		defaultValue.setProperty(CLASSPATH_OPTION_LONG, "");

	}
	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		this.propFile = getProperty(PROPFILE_OPTION_LONG);
		this.classPath = getProperty(CLASSPATH_OPTION_LONG);
		
	}
	@Override
	protected String getAppName() {
		return Generator.class.getSimpleName();
	}
	@Override
	protected String getHeader() {
		return "Sql2java (java)代码生成器";
	}

	/**
	 * @return propfile
	 */
	public File getPropFile() {
		return propFile;
	}

	/**
	 * 根据classPath参数创建自定义{@link URLClassLoader}对象
	 * @return {@link URLClassLoader}对象，classPath为空则返回{@code null}
	 */
	public synchronized ClassLoader getClassloader(){
		if(null == classLoader){
			List<String> paths = MiscellaneousUtils.elementsOf(classPath);
			if(!paths.isEmpty()){
				List<URL> urls = Lists.transform(paths, new Function<String, URL>() {

					@Override
					public URL apply(String input) {
						try {
							return new File(input).getAbsoluteFile().toURI().toURL();
						} catch (MalformedURLException e) {
							throw new RuntimeException(e);
						}
					}
				});
				logger.info("classpath: {}",urls);
				classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
			}
		}
		return classLoader;
	}
}
