/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.MapBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseFuzzyMatchFilter;
import gu.sql2java.BaseRow;
import gu.sql2java.BaseTableManager;
import gu.sql2java.IFuzzyMatchFilter;
import gu.sql2java.Managers;
import gu.sql2java.RowMetaData;
import gu.sql2java.TableListener;
import gu.sql2java.TableManager;
import gu.sql2java.exception.RuntimeDaoException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseFieldSearcher<B extends BaseBean, K> {
    protected final RowMetaData metaData;
    protected final BaseTableManager<B> manager;
    private final int[] keyIds;
    private final int[] effectColumnIds;
    protected final ConcurrentMap<Object[], K> pks;
    protected final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private Collection<B> effectedBeans;
    private BaseRow beforeUpdatedBean;
    private final Listener listener;
    private IFuzzyMatchFilter<K> defaultMatchFilter;
    private IFuzzyMatchFilter.MatchErrorHandler<K> errorHandler;
    private static final Function<Object[], Object> onePk = new Function<Object[], Object>(){

        public Object apply(Object[] input) {
            return input[0];
        }
    };

    public BaseFieldSearcher(RowMetaData metaData, int ... effectColumnIds) {
        this.metaData = (RowMetaData)Preconditions.checkNotNull((Object)metaData, (Object)"metaData is null");
        this.manager = Managers.getBaseTableManager(metaData.tablename);
        this.keyIds = metaData.primaryKeyIds;
        this.effectColumnIds = this.checkEffectIds(effectColumnIds);
        this.pks = MapBuilder.newConcurrentMap();
        this.listener = new Listener();
        this.defaultMatchFilter = new BaseFuzzyMatchFilter.DefaultFuzzyFilter();
    }

    public BaseFieldSearcher(RowMetaData metaData, String ... effectColumnNames) {
        this(metaData, ((RowMetaData)Preconditions.checkNotNull((Object)metaData, (Object)"metaData is null")).columnIDsOf(effectColumnNames));
    }

    public <M extends TableManager<B>> BaseFieldSearcher(Class<M> interfaceClass, int[] effectColumnId) {
        this(Managers.baseManagerOf(interfaceClass).metaData, effectColumnId);
    }

    public <M extends TableManager<B>> BaseFieldSearcher(Class<M> interfaceClass, String ... effectColumnNames) {
        this(Managers.baseManagerOf(interfaceClass).metaData, effectColumnNames);
    }

    public String getTablename() {
        return this.metaData.tablename;
    }

    private int[] checkEffectIds(int[] effectColumnIds) {
        Preconditions.checkArgument((effectColumnIds != null && effectColumnIds.length > 0 ? 1 : 0) != 0, (Object)"effectColumnIds is null or empty");
        for (int columnId : (int[])Preconditions.checkNotNull((Object)effectColumnIds, (Object)"effectColumnIds is null")) {
            Preconditions.checkArgument((columnId >= 0 && columnId < this.metaData.columnCount ? 1 : 0) != 0, (String)"INVALID columnId %s", (int)columnId);
        }
        return effectColumnIds;
    }

    protected abstract K keyOf(B var1);

    protected IFuzzyMatchFilter<K> getDefaultMatchFilter() {
        return this.defaultMatchFilter;
    }

    public BaseFieldSearcher<B, K> setDefaultMatchFilter(IFuzzyMatchFilter<K> defaultMatchFilter) {
        if (defaultMatchFilter != null) {
            this.defaultMatchFilter = defaultMatchFilter;
        }
        return this;
    }

    public BaseFieldSearcher<B, K> setErrorHandler(IFuzzyMatchFilter.MatchErrorHandler<K> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    protected Collection<B> getEffectedBeansOnUpdate(B beforeUpdateBean) {
        return Collections.emptyList();
    }

    public BaseFieldSearcher<B, K> init() {
        ReentrantReadWriteLock.WriteLock lock = this.rwlock.writeLock();
        lock.lock();
        try {
            this.pks.clear();
            this.manager.loadAll(new TableManager.Action<B>(){

                public void call(B bean) {
                    BaseFieldSearcher.this.add(bean);
                }
            });
            this.manager.registerListener((TableListener<B>)this.listener);
        }
        finally {
            lock.unlock();
        }
        return this;
    }

    public BaseFieldSearcher<B, K> uninit() {
        ReentrantReadWriteLock.WriteLock lock = this.rwlock.writeLock();
        lock.lock();
        try {
            this.pks.clear();
            this.manager.unregisterListener((TableListener<B>)this.listener);
        }
        finally {
            lock.unlock();
        }
        return this;
    }

    protected void add(B bean) {
        K key;
        if (bean != null && (key = this.keyOf(bean)) != null) {
            Object[] pk = bean.primaryValues();
            this.pks.put(pk, (Object[])key);
        }
    }

    protected void update(B bean) {
        if (bean != null) {
            K newKey = this.keyOf(bean);
            Object[] pk = bean.primaryValues();
            if (newKey != null) {
                this.pks.put(pk, (Object[])newKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Multimap<K, Object[]> searchPk(K key, int matchFlags, IFuzzyMatchFilter<K> matchFilter, Predicate<Object[]> pkFilter) {
        SetMultimap mm = MultimapBuilder.hashKeys().hashSetValues().build();
        if (key == null) {
            return mm;
        }
        ReentrantReadWriteLock.ReadLock lock = this.rwlock.readLock();
        lock.lock();
        try {
            Map matched = Maps.filterEntries(this.pks, (Predicate)new EntryMatchFilter(key, matchFlags, matchFilter, pkFilter));
            for (Map.Entry entry : matched.entrySet()) {
                mm.put(entry.getValue(), entry.getKey());
            }
            SetMultimap setMultimap = mm;
            return setMultimap;
        }
        finally {
            lock.unlock();
        }
    }

    public final <T> Multimap<K, T> search(K key, int matchFlags, IFuzzyMatchFilter<K> matchFilter, Predicate<T> pkFilter) {
        Preconditions.checkState((this.keyIds.length == 1 ? 1 : 0) != 0, (Object)"Unsupported Operation caused by the primary count > 1");
        Predicate objsPkFilters = null;
        if (pkFilter != null) {
            objsPkFilters = Predicates.compose(pkFilter, onePk);
        }
        Multimap<K, Object[]> pk = this.searchPk(key, matchFlags, matchFilter, (Predicate<Object[]>)objsPkFilters);
        return Multimaps.transformValues(pk, onePk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K getPk(Object[] pk) {
        if (pk == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock lock = this.rwlock.readLock();
        lock.lock();
        try {
            Object v = this.pks.get(pk);
            return (K)v;
        }
        finally {
            lock.unlock();
        }
    }

    public int[] getEffectColumnIds() {
        return this.effectColumnIds;
    }

    public int getEffectColumnId() {
        return this.effectColumnIds[0];
    }

    public String getEffectColumnName() {
        return this.metaData.columnNameOf(this.effectColumnIds[0]);
    }

    class EntryMatchFilter
    implements Predicate<Map.Entry<Object[], K>> {
        private final IFuzzyMatchFilter<K> matchFilter;
        private final Predicate<Object[]> pkFilter;

        EntryMatchFilter(K key, int matchFlags, IFuzzyMatchFilter<K> matchFilter, Predicate<Object[]> pkFilter) {
            this.matchFilter = ((IFuzzyMatchFilter)MoreObjects.firstNonNull(matchFilter, BaseFieldSearcher.this.getDefaultMatchFilter())).withErrorHandler(BaseFieldSearcher.this.errorHandler).withPattern(key, matchFlags);
            this.pkFilter = (Predicate)MoreObjects.firstNonNull(pkFilter, (Object)Predicates.alwaysTrue());
        }

        public boolean apply(Map.Entry<Object[], K> input) {
            return this.matchFilter.apply(input.getValue()) && this.pkFilter.apply((Object)input.getKey());
        }
    }

    private class Listener
    extends TableListener.Adapter<B> {
        private Listener() {
        }

        public void afterInsert(B bean) throws RuntimeDaoException {
            ReentrantReadWriteLock.WriteLock lock = BaseFieldSearcher.this.rwlock.writeLock();
            lock.lock();
            try {
                BaseFieldSearcher.this.add(bean);
            }
            finally {
                lock.unlock();
            }
        }

        private boolean isModified(B bean) {
            for (int columnId : BaseFieldSearcher.this.effectColumnIds) {
                if (!bean.isModified(columnId)) continue;
                return true;
            }
            return false;
        }

        public void beforeUpdate(B bean) throws RuntimeDaoException {
            BaseFieldSearcher.this.beforeUpdatedBean = ((BaseRow)bean).clone();
            if (this.isModified(bean)) {
                BaseFieldSearcher.this.effectedBeans = BaseFieldSearcher.this.getEffectedBeansOnUpdate(bean);
            } else {
                BaseFieldSearcher.this.effectedBeans = Collections.emptyList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(B bean) throws RuntimeDaoException {
            Preconditions.checkState((BaseFieldSearcher.this.beforeUpdatedBean != null ? 1 : 0) != 0, (Object)"beforeUpdatedBean must not be null");
            ReentrantReadWriteLock.WriteLock lock = BaseFieldSearcher.this.rwlock.writeLock();
            lock.lock();
            try {
                for (BaseBean effectedBean : BaseFieldSearcher.this.effectedBeans) {
                    BaseFieldSearcher.this.update(effectedBean);
                }
                BaseFieldSearcher.this.update(bean);
            }
            finally {
                lock.unlock();
                BaseFieldSearcher.this.beforeUpdatedBean = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDelete(B bean) throws RuntimeDaoException {
            ReentrantReadWriteLock.WriteLock lock = BaseFieldSearcher.this.rwlock.writeLock();
            lock.lock();
            try {
                Object[] pk = bean.primaryValues();
                BaseFieldSearcher.this.pks.remove(pk);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

