/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import gu.sql2java.ConfigUtils;
import gu.sql2java.Constant;
import gu.sql2java.IDataSourceConfig;
import gu.sql2java.ListenerContainer;
import gu.sql2java.PageQueryImplType;
import gu.sql2java.SimpleLog;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class DataSourceConfig
implements Constant,
IDataSourceConfig {
    static final String DT_SQLITE = "SQLITE";
    static final String DT_C3P0 = "C3P0";
    static final String DT_DRUID = "DRUID";
    private static boolean debugOutput = false;
    private static volatile Properties databaseProperties;
    final String jdbcDriver;
    final String jdbcUrl;
    final String jdbcUsername;
    final String jdbcPassword;
    final boolean isDebug;
    final String alias;
    final ListenerContainer.FireType fireType;
    final String dataSource;
    volatile String generatedkeyRetrieve = null;
    volatile String generatedkeyStatement = null;
    volatile PageQueryImplType pageQueryImplType = null;
    private final Properties initProperties;

    DataSourceConfig() {
        this(DataSourceConfig.asInitProps(DataSourceConfig.getDatabaseproperties()));
    }

    private DataSourceConfig(Properties properties) {
        this.alias = (String)MoreObjects.firstNonNull((Object)properties.getProperty(Constant.JdbcProperty.ALIAS.key), (Object)"DEFAULT");
        this.fireType = ListenerContainer.FireType.valueOrNull((String)properties.getProperty(Constant.JdbcProperty.FIRE_TYPE.key));
        this.isDebug = Boolean.valueOf(properties.getProperty(Constant.JdbcProperty.DEBUG.key));
        String prefix = this.isDebug ? "debug." : "work.";
        this.jdbcDriver = properties.getProperty(Constant.JdbcProperty.JDBC_DRIVER.withPrefix(prefix));
        this.jdbcUrl = properties.getProperty(Constant.JdbcProperty.JDBC_URL.withPrefix(prefix));
        this.jdbcUsername = properties.getProperty(Constant.JdbcProperty.JDBC_USERNAME.withPrefix(prefix));
        this.jdbcPassword = properties.getProperty(Constant.JdbcProperty.JDBC_PASSWORD.withPrefix(prefix));
        this.generatedkeyRetrieve = properties.getProperty(Constant.JdbcProperty.GENERATEDKEY_RETRIEVE.key);
        this.generatedkeyStatement = properties.getProperty(Constant.JdbcProperty.GENERATEDKEY_STATEMENT.key);
        this.dataSource = properties.getProperty(Constant.JdbcProperty.DATASOURCE.key, DT_C3P0).toUpperCase();
        this.initProperties = new Properties();
        this.initProperties.putAll((Map<?, ?>)properties);
        this.initProperties.setProperty(Constant.JdbcProperty.JDBC_DRIVER.key, this.jdbcDriver);
        this.initProperties.setProperty(Constant.JdbcProperty.JDBC_URL.key, this.jdbcUrl);
        this.initProperties.setProperty(Constant.JdbcProperty.JDBC_USERNAME.key, this.jdbcUsername);
        this.initProperties.setProperty(Constant.JdbcProperty.JDBC_PASSWORD.key, this.jdbcPassword);
        if (DT_C3P0.equals(this.dataSource)) {
            String maxPoolSize = properties.getProperty(Constant.JdbcProperty.C3P0_MAXPOOLSIZE.withPrefix(prefix));
            String minPoolSize = properties.getProperty(Constant.JdbcProperty.C3P0_MINPOOLSIZE.withPrefix(prefix));
            String maxIdleTime = properties.getProperty(Constant.JdbcProperty.C3P0_MAXIDLETIME.withPrefix(prefix));
            String idleConnectionTestPeriod = properties.getProperty(Constant.JdbcProperty.C3P0_IDLECONNECTIONTESTPERIOD.withPrefix(prefix));
            this.initProperties.setProperty(Constant.JdbcProperty.C3P0_MAXPOOLSIZE.key, maxPoolSize);
            this.initProperties.setProperty(Constant.JdbcProperty.C3P0_MINPOOLSIZE.key, minPoolSize);
            this.initProperties.setProperty(Constant.JdbcProperty.C3P0_MAXIDLETIME.key, maxIdleTime);
            this.initProperties.setProperty(Constant.JdbcProperty.C3P0_IDLECONNECTIONTESTPERIOD.key, idleConnectionTestPeriod);
        }
        Arrays.asList(Constant.JdbcProperty.values()).forEach(p -> this.initProperties.remove(p.withPrefix(prefix)));
        this.initProperties.stringPropertyNames().forEach(k -> {
            if (k.startsWith(prefix)) {
                Object value = this.initProperties.remove(k);
                this.initProperties.put(k.substring(prefix.length()), value);
            }
            if (this.isDebug) {
                if (k.startsWith("work.")) {
                    this.initProperties.remove(k);
                }
            } else if (k.startsWith("debug.")) {
                this.initProperties.remove(k);
            }
        });
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    String getGeneratedkeyRetrieve() {
        return this.generatedkeyRetrieve;
    }

    String getGeneratedkeyStatement() {
        return this.generatedkeyStatement;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    boolean isDebug() {
        return this.isDebug;
    }

    String getAlias() {
        return this.alias;
    }

    public Properties getInitProperties() {
        return this.initProperties;
    }

    public String getInitProperty(String key) {
        return this.initProperties.getProperty(key);
    }

    public String getInitProperty(String key, String defaultValue) {
        return this.initProperties.getProperty(key, defaultValue);
    }

    public void logDatabaseProperties() {
        DataSourceConfig.logDatabaseProperties(this.initProperties, this.dataSource);
    }

    public static void logDatabaseProperties(Properties props, String datasourceType) {
        if (debugOutput) {
            SimpleLog.log((String)"database using debug environment parameter: ", (Object[])new Object[0]);
            LinkedHashSet allKeys = Sets.newLinkedHashSet(Arrays.asList(Constant.JdbcProperty.DATASOURCE.key, "url", "jdbc.url", "username", "jdbc.username", "password", "jdbc.password", "driver", "jdbc.driver", "driverclassname"));
            if (!Strings.isNullOrEmpty((String)datasourceType)) {
                SimpleLog.log((String)"{}={}", (Object[])new Object[]{Constant.JdbcProperty.DATASOURCE.key, datasourceType});
            }
            List sorted = Ordering.natural().sortedCopy(props.stringPropertyNames());
            allKeys.addAll(sorted);
            if (!Strings.isNullOrEmpty((String)datasourceType)) {
                allKeys.remove(Constant.JdbcProperty.DATASOURCE.key);
            }
            allKeys.forEach(key -> {
                if (props.containsKey(key)) {
                    SimpleLog.log((String)"{}={}", (Object[])new Object[]{key, props.getProperty((String)key)});
                }
            });
        }
    }

    static Properties loadInitProperties(String alias) {
        String envVar = "SQL2JAVA_CONFIG";
        String propFile = "database.properties";
        if (alias != null && !"DEFAULT".equals(alias)) {
            propFile = alias + "_" + propFile;
        }
        String confFolder = "conf";
        return ConfigUtils.loadAllProperties(propFile, confFolder, envVar, DataSourceConfig.class, false);
    }

    static final void injectToProperties(Properties target, EnumMap<Constant.JdbcProperty, String> input) {
        if (null != target && null != input) {
            Boolean isDebug = "true".equalsIgnoreCase(input.get(Constant.JdbcProperty.DEBUG));
            String prefix = isDebug != false ? "debug." : "work.";
            for (Map.Entry<Constant.JdbcProperty, String> entry : input.entrySet()) {
                Constant.JdbcProperty key = entry.getKey();
                String value = entry.getValue();
                if (null == value || value.isEmpty()) continue;
                if (key.isGlobal()) {
                    target.setProperty(key.key, value);
                    continue;
                }
                target.setProperty(key.withPrefix(prefix), value);
            }
        }
    }

    static final EnumMap<Constant.JdbcProperty, String> asEnumMap(Map properties, String prefix) {
        EnumMap<Constant.JdbcProperty, String> enumMap = new EnumMap<Constant.JdbcProperty, String>(Constant.JdbcProperty.class);
        if (null != properties) {
            for (Constant.JdbcProperty property : Constant.JdbcProperty.values()) {
                Object value = property.isGlobal() || null == prefix ? properties.get(property.key) : properties.get(property.withPrefix(prefix));
                if (!(value instanceof String)) continue;
                enumMap.put(property, (String)value);
            }
        }
        return enumMap;
    }

    static final void injectProperties(EnumMap<Constant.JdbcProperty, String> input) {
        DataSourceConfig.injectToProperties(DataSourceConfig.getDatabaseproperties(), input);
    }

    static String parseValue(Map properties, Constant.JdbcProperty property) {
        if (properties != null && null != property) {
            if (property.isGlobal()) {
                return (String)properties.get(property.key);
            }
            Boolean isDebug = "true".equalsIgnoreCase((String)properties.get(Constant.JdbcProperty.DEBUG));
            String prefix = isDebug != false ? "debug." : "work.";
            return (String)properties.get(property.withPrefix(prefix));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getDatabaseproperties() {
        if (null != databaseProperties) return databaseProperties;
        Class<DataSourceConfig> clazz = DataSourceConfig.class;
        synchronized (DataSourceConfig.class) {
            if (null != databaseProperties) return databaseProperties;
            databaseProperties = DataSourceConfig.loadInitProperties(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return databaseProperties;
        }
    }

    private static Properties asInitProps(Properties properties) {
        String alias = DataSourceConfig.parseValue((Map)Preconditions.checkNotNull((Object)properties, (Object)"databaseProperties is null"), Constant.JdbcProperty.ALIAS);
        if (alias != null) {
            Properties initProps = DataSourceConfig.loadInitProperties(alias);
            initProps.putAll((Map<?, ?>)properties);
            return initProps;
        }
        return properties;
    }

    static DataSourceConfig createConfig(Properties properties) {
        properties = DataSourceConfig.asInitProps(properties);
        return new DataSourceConfig(properties);
    }

    public static boolean isDebugOutput() {
        return debugOutput;
    }

    public static void setDebugOutput(boolean debugOutput) {
        DataSourceConfig.debugOutput = debugOutput;
    }
}

