/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import gu.sql2java.BaseTableManager;
import gu.sql2java.ListenerContainer;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableListener;
import gu.sql2java.TransactionListener;
import gu.sql2java.exception.RuntimeDaoException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;

class ListenerContainerLocal<B>
extends ListenerContainer<B> {
    static final TransactionListenerImpl TRANSACTION_LISTENER = new TransactionListenerImpl();

    public ListenerContainerLocal(ListenerContainer.FireType fireType) {
        super(BaseTableManager.isDebug(), fireType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInsert(final B bean) throws RuntimeDaoException {
        if (this.isLocalReqFirer()) {
            LinkedHashSet linkedHashSet = this.listeners;
            synchronized (linkedHashSet) {
                for (final TableListener listener : this.listeners) {
                    TRANSACTION_LISTENER.runCommitTask(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    listener.afterInsert(bean);
                                }
                                catch (Exception e) {
                                    SimpleLog.log((String)"afterInsert listener %s error:%s", (Object[])new Object[]{listener.getClass().getName(), e.getMessage()});
                                    if (!ListenerContainerLocal.this.trace) break block2;
                                    SimpleLog.log((Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        } else {
            super.afterInsert(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(final B bean) throws RuntimeDaoException {
        if (this.isLocalReqFirer()) {
            LinkedHashSet linkedHashSet = this.listeners;
            synchronized (linkedHashSet) {
                for (final TableListener listener : this.listeners) {
                    TRANSACTION_LISTENER.runCommitTask(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    listener.afterUpdate(bean);
                                }
                                catch (Exception e) {
                                    SimpleLog.log((String)"afterUpdate listener %s error:%s", (Object[])new Object[]{listener.getClass().getName(), e.getMessage()});
                                    if (!ListenerContainerLocal.this.trace) break block2;
                                    SimpleLog.log((Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        } else {
            super.afterUpdate(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelete(final B bean) throws RuntimeDaoException {
        if (this.isLocalReqFirer()) {
            LinkedHashSet linkedHashSet = this.listeners;
            synchronized (linkedHashSet) {
                for (final TableListener listener : this.listeners) {
                    TRANSACTION_LISTENER.runCommitTask(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    listener.afterDelete(bean);
                                }
                                catch (Exception e) {
                                    SimpleLog.log((String)"afterDelete listener %s error:%s", (Object[])new Object[]{listener.getClass().getName(), e.getMessage()});
                                    if (!ListenerContainerLocal.this.trace) break block2;
                                    SimpleLog.log((Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        } else {
            super.afterDelete(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() throws RuntimeDaoException {
        if (this.isLocalReqFirer()) {
            LinkedHashSet linkedHashSet = this.listeners;
            synchronized (linkedHashSet) {
                for (final TableListener listener : this.listeners) {
                    TRANSACTION_LISTENER.runDoneTask(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    listener.done();
                                }
                                catch (Exception e) {
                                    SimpleLog.log((String)"done listener %s error:%s", (Object[])new Object[]{listener.getClass().getName(), e.getMessage()});
                                    if (!ListenerContainerLocal.this.trace) break block2;
                                    SimpleLog.log((Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private static class TransactionListenerImpl
    implements TransactionListener {
        private static final ThreadLocal<LinkedList<Runnable>> commitTasks = new ThreadLocal();
        private static final ThreadLocal<LinkedList<Runnable>> doneTasks = new ThreadLocal();

        private TransactionListenerImpl() {
        }

        @Override
        public void onBegin() {
            commitTasks.set(new LinkedList());
            doneTasks.set(new LinkedList());
        }

        private static void runEachTask(LinkedList<Runnable> tasks) {
            try {
                while (!tasks.isEmpty()) {
                    ImmutableList copy = ImmutableList.copyOf(tasks);
                    for (Runnable task : copy) {
                        task.run();
                    }
                    tasks.removeAll((Collection<?>)copy);
                }
            }
            catch (Exception e) {
                SimpleLog.log((String)"{}:{}", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            }
        }

        @Override
        public void onCommit() {
            TransactionListenerImpl.runEachTask((LinkedList)Preconditions.checkNotNull(commitTasks.get(), (Object)"'onBegin' must be called firstly"));
        }

        @Override
        public void onEnd() {
            TransactionListenerImpl.runEachTask((LinkedList)Preconditions.checkNotNull(doneTasks.get(), (Object)"'onBegin' must be called firstly"));
            commitTasks.remove();
            doneTasks.remove();
        }

        void runCommitTask(Runnable task) {
            LinkedList<Runnable> tasks = commitTasks.get();
            if (tasks != null) {
                tasks.add(task);
            } else {
                task.run();
            }
        }

        void runDoneTask(Runnable task) {
            LinkedList<Runnable> tasks = doneTasks.get();
            if (tasks != null) {
                tasks.add(task);
            } else {
                task.run();
            }
        }
    }
}

