/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.druid;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gu.sql2java.DataSourceConfig;
import gu.sql2java.DataSourceFactory;
import gu.sql2java.SimpleLog;
import gu.sql2java.utils.CaseSupport;
import java.io.Closeable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class DruidDataSourceFactory
implements DataSourceFactory {
    private static final String jdbcPrefix = "jdbc.";
    private static final String c3p0Prefix = "c3p0.";
    private static final String springDatasourcePrefix = "spring.datasource.";
    private static final String springDatasourceDruidPrefix = "spring.datasource.druid.";
    private static final String druidPrefix = "druid.";
    private static final String driverSuffix = ".driver";
    private static final Set<String> druidProperyNames = Sets.newHashSet(DruidDataSourceFactory.getDuridPropertyNames().values());

    private static boolean renameKey(Properties props, String key, String prefix) {
        return DruidDataSourceFactory.renameKey(props, key, prefix, null);
    }

    private static boolean renameKey(Properties props, String key, String prefix, String newPrefix) {
        if (key.startsWith(prefix)) {
            String subKey;
            Object value = props.remove(key);
            String camelcaseKey = subKey = key.substring(prefix.length());
            if (Pattern.compile("[-_]").matcher(subKey).find()) {
                camelcaseKey = CaseSupport.toCamelcase((String)subKey.replace('-', '_').toLowerCase());
            }
            if (!props.containsKey(camelcaseKey) && !props.containsKey(Strings.nullToEmpty((String)newPrefix) + camelcaseKey)) {
                props.put(Strings.nullToEmpty((String)newPrefix) + camelcaseKey, value);
            }
            return true;
        }
        return false;
    }

    private static void replaceKey(Properties props, String from, String to) {
        if (props.containsKey(from)) {
            Object value = props.remove(from);
            props.put(to, value);
        } else if (props.containsKey(druidPrefix + from)) {
            Object value = props.remove(druidPrefix + from);
            props.put(to, value);
        }
    }

    private static void normalizePropertiesForDurid0(Properties props, String prefix, String newPrefix) {
        props.stringPropertyNames().forEach(k -> {
            if (k.startsWith(prefix)) {
                DruidDataSourceFactory.renameKey(props, k, prefix, newPrefix);
            } else if (k.startsWith(c3p0Prefix)) {
                props.remove(k);
                return;
            }
            if (k.endsWith(driverSuffix)) {
                Object value = props.remove("driver");
                props.put("driverClassName", value);
            }
        });
    }

    static void normalizePropertiesForDurid(Properties props) {
        DruidDataSourceFactory.normalizePropertiesForDurid0(props, jdbcPrefix, null);
        DruidDataSourceFactory.normalizePropertiesForDurid0(props, druidPrefix, druidPrefix);
        DruidDataSourceFactory.normalizePropertiesForDurid0(props, springDatasourceDruidPrefix, druidPrefix);
        DruidDataSourceFactory.normalizePropertiesForDurid0(props, springDatasourcePrefix, null);
        druidProperyNames.forEach(n -> {
            if (!props.containsKey(n)) {
                if (props.containsKey(druidPrefix + n)) {
                    DruidDataSourceFactory.renameKey(props, druidPrefix + n, druidPrefix);
                } else if (!n.startsWith(druidPrefix)) {
                    if (Pattern.compile("[-_]").matcher((CharSequence)n).find()) {
                        String camelcaseKey = CaseSupport.toCamelcase((String)n.replace('-', '_').toLowerCase());
                        DruidDataSourceFactory.replaceKey(props, camelcaseKey, n);
                    } else {
                        String spinalcaseKey = CaseSupport.toSnakecase((String)n).replace('_', '-');
                        DruidDataSourceFactory.replaceKey(props, spinalcaseKey, n);
                    }
                }
            }
        });
        props.stringPropertyNames().forEach(k -> {
            if (k.indexOf(46) >= 0 && !k.startsWith(druidPrefix)) {
                props.remove(k);
                return;
            }
        });
    }

    private static Map<String, String> getDuridPropertyNames() {
        Iterable constFields = Iterables.filter(Arrays.asList(com.alibaba.druid.pool.DruidDataSourceFactory.class.getFields()), f -> f.getName().startsWith("PROP_") && f.getType().equals(String.class) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()));
        HashMap duridConstPopertyNames = Maps.newHashMap();
        constFields.forEach(f -> {
            try {
                duridConstPopertyNames.put(f.getName(), (String)f.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        });
        return duridConstPopertyNames;
    }

    public static DataSource createDataSource(Properties input) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)((Map)Preconditions.checkNotNull((Object)input, (Object)"props is null")));
        try {
            DruidDataSourceFactory.normalizePropertiesForDurid(props);
            Preconditions.checkArgument((boolean)props.containsKey("url"), (String)"MISSING ESSENTIAL ARGUMENT %s", (Object)"url");
            DataSourceConfig.logDatabaseProperties(props, "druid");
            return com.alibaba.druid.pool.DruidDataSourceFactory.createDataSource((Properties)props);
        }
        catch (Exception e) {
            String message = String.format("can't get connection by argument...url/username/password[%s/%s/%s]", props.getProperty("url"), props.getProperty("username"), props.getProperty("password"));
            throw new IllegalArgumentException(message, e);
        }
    }

    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)((DataSourceConfig)Preconditions.checkNotNull((Object)config, (Object)"config is null")).getInitProperties());
        return DruidDataSourceFactory.createDataSource(props);
    }

    @Override
    public void destroy(DataSource dataSource) {
        try {
            if (dataSource instanceof Closeable) {
                ((Closeable)((Object)dataSource)).close();
            }
        }
        catch (Exception e) {
            SimpleLog.log((String)("dispose DruidDataSource wrong ..." + e), (Object[])new Object[0]);
        }
    }
}

