/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.parser;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import gu.sql2java.SimpleLog;
import gu.sql2java.SqlFormatter;
import gu.sql2java.exception.RuntimeDaoException;
import gu.sql2java.parser.InjectionAstNodeVisitor;
import gu.sql2java.parser.InjectionAttackException;
import gu.sql2java.parser.InjectionSyntaxObjectAnalyzer;
import gu.sql2java.parser.ParserSupport;
import gu.sql2java.parser.SqlInjectionAnalyzer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.parser.CCJSqlParserDefaultVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserVisitor;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class StatementCache {
    private final CCJSqlParserVisitor visitor;
    private final LoadingCache<String, ParserSupport.SqlParserInfo> statementCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, ParserSupport.SqlParserInfo>(){

        public ParserSupport.SqlParserInfo load(String key) throws Exception {
            ParserSupport.SqlParserInfo sqlParserInfo = ParserSupport.parse0(key, StatementCache.this.visitor);
            return sqlParserInfo;
        }
    });
    private final ConcurrentMap<String, RuntimeDaoException> dangrousSqls = Maps.newConcurrentMap();
    private final ConcurrentMap<String, RuntimeDaoException> invalidSqls = Maps.newConcurrentMap();
    private final SqlInjectionAnalyzer injectAnalyzer;

    public StatementCache() {
        this((CCJSqlParserDefaultVisitor)null);
    }

    public StatementCache(CCJSqlParserDefaultVisitor vistor) {
        this.visitor = vistor;
        new InjectionSyntaxObjectAnalyzer();
        new InjectionAstNodeVisitor();
        this.injectAnalyzer = new SqlInjectionAnalyzer();
    }

    public StatementCache(CCJSqlParserVisitor vistor) {
        this(new AstNodeVisitor(vistor));
    }

    public StatementCache(SqlFormatter sqlFormatter) {
        this(new AstNodeVisitor(sqlFormatter));
    }

    public StatementCache injectCheckEnable(boolean enable) {
        this.injectAnalyzer.injectCheckEnable(enable);
        return this;
    }

    public ParserSupport.SqlParserInfo parse(String sql) {
        if (null != sql) {
            RuntimeDaoException rde = (RuntimeDaoException)((Object)this.dangrousSqls.get(sql));
            if (null != rde) {
                throw rde;
            }
            rde = (RuntimeDaoException)((Object)this.invalidSqls.get(sql));
            if (null != rde) {
                throw rde;
            }
        }
        try {
            ParserSupport.SqlParserInfo sqlParserInfo = (ParserSupport.SqlParserInfo)this.statementCache.get((Object)sql);
            return this.injectAnalyzer.injectAnalyse(sqlParserInfo);
        }
        catch (ExecutionException e) {
            RuntimeDaoException rde = new RuntimeDaoException(e.getCause());
            this.invalidSqls.put(sql, rde);
            throw rde;
        }
        catch (InjectionAttackException e) {
            RuntimeDaoException rde = new RuntimeDaoException((Throwable)e);
            this.dangrousSqls.put(sql, rde);
            throw rde;
        }
    }

    public String normalize(String sql) {
        return this.parse((String)sql).nativeSql;
    }

    public PreparedStatement prepareStatement(Connection c, String sql, boolean debug, String logPrefix, int resultSetType, int resultSetConcurrency) throws SQLException {
        sql = this.normalize(sql);
        if (debug) {
            SimpleLog.log((String)(logPrefix + " : " + sql), (Object[])new Object[0]);
        }
        return ((Connection)Preconditions.checkNotNull((Object)c, (Object)"connection is null")).prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(Connection c, String sql, boolean debug, String logPrefix, int autoGeneratedKeys) throws SQLException {
        sql = this.normalize((String)Preconditions.checkNotNull((Object)sql, (Object)"sql is null"));
        if (debug) {
            SimpleLog.log((String)"{} : {}", (Object[])new Object[]{logPrefix, sql});
        }
        return ((Connection)Preconditions.checkNotNull((Object)c, (Object)"connection is null")).prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(Connection c, String sql, boolean debug, String logPrefix) throws SQLException {
        sql = this.normalize(sql);
        if (debug) {
            SimpleLog.log((String)(logPrefix + " : " + sql), (Object[])new Object[0]);
        }
        return ((Connection)Preconditions.checkNotNull((Object)c, (Object)"connection is null")).prepareStatement(sql);
    }

    private static class NodeVisitor
    extends TablesNamesFinder {
        private final SqlFormatter sqlFormatter;

        NodeVisitor(SqlFormatter sqlFormatter) {
            this.sqlFormatter = sqlFormatter;
            this.init(true);
        }

        private void visit(Alias alias) {
            if (null != this.sqlFormatter && null != alias) {
                alias.setName(this.sqlFormatter.alias(alias.getName()));
            }
        }

        void visit(FromItem fromItem) {
            if (null != this.sqlFormatter && null != fromItem) {
                this.visit(fromItem.getAlias());
            }
        }

        public void visit(Column column) {
            if (null != this.sqlFormatter && !ParserSupport.isBoolean(column)) {
                column.setColumnName(this.sqlFormatter.columname(column.getColumnName()));
            }
            super.visit(column);
        }

        public void visit(SelectExpressionItem item) {
            if (null != this.sqlFormatter) {
                this.visit(item.getAlias());
            }
            super.visit(item);
        }

        public void visit(Table table) {
            if (null != this.sqlFormatter) {
                table.setName(this.sqlFormatter.columname(table.getName()));
                this.visit(table.getAlias());
            }
            super.visit(table);
        }
    }

    private static class AstNodeVisitor
    extends CCJSqlParserDefaultVisitor {
        private final CCJSqlParserVisitor visitor;

        AstNodeVisitor(CCJSqlParserVisitor visitor) {
            this.visitor = visitor;
        }

        AstNodeVisitor(NodeVisitor finder) {
            this(null == finder ? null : (node, data) -> {
                Object value = node.jjtGetValue();
                if (value instanceof Column) {
                    finder.visit((Column)value);
                } else if (value instanceof Table) {
                    finder.visit((Table)value);
                } else if (value instanceof SelectExpressionItem) {
                    finder.visit((SelectExpressionItem)value);
                } else if (value instanceof FromItem) {
                    finder.visit((FromItem)value);
                }
                return data;
            });
        }

        AstNodeVisitor(SqlFormatter sqlFormatter) {
            this(null == sqlFormatter ? null : new NodeVisitor(sqlFormatter));
        }

        public Object visit(SimpleNode node, Object data) {
            if (null != this.visitor) {
                this.visitor.visit(node, data);
            }
            return super.visit(node, data);
        }
    }
}

