package com.google.common.base;

import java.util.Arrays;
import java.util.Objects;

public class DeepEquivalence extends Equivalence<Object> {
	public static final Equivalence<Object> DEEP_EQUIVALENCE = new DeepEquivalence();
	public DeepEquivalence() {
	}
	@Override
	protected boolean doEquivalent(Object a, Object b) {
		return Objects.deepEquals(a, b);
	}

	@Override
	protected int doHash(Object object) {
		return deepHashCode(object);
	}
	public static final int deepHashCode(Object a){
		if (a == null){
	        return 0;
		}else if (a instanceof Object[]) {
			return Arrays.deepHashCode((Object[]) a);
		} else if (a instanceof byte[]) {
			return Arrays.hashCode((byte[]) a);
		} else if (a instanceof short[]) {
			return Arrays.hashCode((short[]) a);
		} else if (a instanceof int[]) {
			return Arrays.hashCode((int[]) a);
		} else if (a instanceof long[]) {
			return Arrays.hashCode((long[]) a);
		} else if (a instanceof char[]) {
			return Arrays.hashCode((char[]) a);
		} else if (a instanceof float[]) {
			return Arrays.hashCode((float[]) a);
		} else if (a instanceof double[]) {
			return Arrays.hashCode((double[]) a);
		} else if (a instanceof boolean[]) {
			return Arrays.hashCode((boolean[]) a);
		} 
		return a.hashCode();
	}
}
