package com.google.common.cache;

import com.google.common.base.Equivalence;

import static com.google.common.base.DeepEquivalence.DEEP_EQUIVALENCE;

public class DeepCacheBuilder {
		
	public static final CacheBuilder<Object, Object> newBuilder(){
		return newBuilder(DEEP_EQUIVALENCE,DEEP_EQUIVALENCE);
	}
	public static final CacheBuilder<Object, Object> newBuilder(
			Equivalence<Object> keyEquivalence,
			Equivalence<Object> valueEquivalence){
		CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
		if(keyEquivalence != null){
			builder.keyEquivalence(keyEquivalence);
		}
		if(valueEquivalence != null){
			builder.valueEquivalence(valueEquivalence);	
		}
		return builder;
	}
}
