package gu.sql2java;

import java.io.File;
import java.net.URL;
import java.util.Properties;

import gu.sql2java.Constant.JdbcProperty;

import static gu.sql2java.SimpleLog.logString;
import static gu.sql2java.Constant.JdbcProperty.*;

/**
 * derby initializer(未测试)
 * @author guyadong
 *
 */
public class DerbyInitializer extends BaseEmbeddedInitializer {

	public DerbyInitializer(File db, URL createSql, boolean runInMemory) {
		super(db, createSql, runInMemory);
	}
	private static String createJDBCUrl(boolean runInMemory, File db) {
		String create = null;
		String jdbcurl = null;
		if (runInMemory) {
			create = db.exists() && db.isDirectory() ? "restoreFrom="
					+ db.getAbsolutePath() : "create=true";
			jdbcurl = String.format("jdbc:derby:memory:%s;%s", db.getName(), create);
		} else {
			create = db.exists() && db.isDirectory() ? "" : ";create=true";
			jdbcurl = String.format("jdbc:derby:%s%s", db.getAbsolutePath(), create);
		}
		return jdbcurl;
	}
	@Override
	protected void doPersist() {
		String backupStr = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)";
		Managers.getSqlRunner(dbprops.getProperty(JdbcProperty.ALIAS.key)).runSql(backupStr,	new Object[] { dbroot.getAbsolutePath() });
	}

	@Override
	protected void writeDbProps(Properties dbprops) {
		dbprops.setProperty(JDBC_URL.key, createJDBCUrl(runInMemory, db));
		dbprops.setProperty(JDBC_DRIVER.key, "org.apache.derby.jdbc.AutoloadedDriver");		
	}

	@Override
	protected void checkExistsDatabse(File db) throws EmbeddedInitException {
		if (db.isDirectory() 
				&& new File(db,"log").isDirectory() 
				&& new File(db,"seg0").isDirectory() ) {
			return;
		}
		throw new EmbeddedInitException(logString("{} IS NOT a derby database",	db.getAbsolutePath()));
	}
	/**
	 * Derby数据库初始化
	 * @param db 数据文件位置
	 * @param createSql 数据库建表语句(SQL)位置
	 * @param runInMemory 为{@code true}以内存方式运行
	 * @param properties 附加的配置参数
	 * @return {@link DerbyInitializer} 实例
	 */
	public static DerbyInitializer init(File db, URL createSql, boolean runInMemory, Properties properties){
		return init(DerbyInitializer.class, db, createSql, runInMemory, properties);
	}
	/**
	 * Derby数据库初始化
	 * @param db 数据文件位置(File)
	 * @param createSql 数据库建表语句(SQL)位置
	 * @param runInMemory 为{@code true}以内存方式运行
	 * @param properties 附加的配置参数
	 * @return {@link DerbyInitializer} 实例
	 */
	public static DerbyInitializer init(String db, String createSql, boolean runInMemory, Properties properties){
		return init(DerbyInitializer.class, db, createSql, runInMemory, properties);
	}
}
