package gu.sql2java;

import gu.sql2java.Constant.UpdateStrategy;
import gu.sql2java.exception.ObjectRetrievalException;

interface IKeyCache<B extends BaseBean> {
    /**
     * 删除cache中指定的记录
     * @param bean
     * @return the previous B associated with keys of {@code bean}, or null if there was no mapping for key.
     */
    public B remove(B bean);
    /**
     * 根据指定的更新策略更新{@code bean}到指定的缓存对象{@code cacheMap}
     * @param bean
     * @param updateStrategy 更新策略
     */
    public void update(B bean, UpdateStrategy updateStrategy);
    /**
     * 根据默认更新策略向cache中更新数据
     * @param bean
     * @see Constant.UpdateStrategy
     */
    public void update(B bean);
    /**
     * 加载主键或索引(keys)指定的记录,如果缓存中没有则从数据库中查询<br>
     * 数据库中没有找到则抛出异常
     * @param keys value of primary or index keys
     * @return B
     * @throws ObjectRetrievalException
     */
    public B getBean(Object... keys)throws ObjectRetrievalException;
    /**
     * 加载主键或索引(keys)指定的记录,如果缓存中没有则从数据库中查询<br>
     * 数据库中没有找到则返回{@code null}
     * @param keys primary keys
     * @return B
     */
    public B getBeanUnchecked(Object... keys);
    /**
     * 判断指定的数据库记录是否包含有效的key值
     * @param bean
     * @return 如果所有的key字段都不为{@code null}则返回{@code true},否则返回{@code false}
     */
    public boolean hasValidKey(B bean);
}
