package gu.sql2java;

import com.google.common.base.Strings;

public enum PageQueryImplType implements IPageQueryWrap{
	NO_IMPL(false,null),
	/** LIMIT OFFSET statement */
	LIMIT_OFFSET(new PageQueryLimitOffsetImpl()),
	/** for SQL server */
	OFFSET_FETCH(new PageQueryOffsetFetchImpl());
	public final boolean supported;
	private final IPageQueryWrap impl;
	private PageQueryImplType(IPageQueryWrap impl){
		this(true,impl);
	}
	private PageQueryImplType(boolean supported, IPageQueryWrap impl){
		this.supported = supported;
		this.impl = impl;
	}

	@Override
	public String wrap(String sql, int startRow, int numRows) {
		if(supported && null != impl && !Strings.isNullOrEmpty(sql)){
			return  impl.wrap(sql, startRow, numRows);
		}
		return null;
	}
}
