package gu.sql2java;

import static com.google.common.base.Preconditions.checkNotNull;
import static gu.sql2java.Managers.baseManagerOf;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;

public class StringFieldSearcher<B extends BaseBean> extends BaseFieldSearcher<B, String> {

	private Function<B, String> funKeyGetter;
	public StringFieldSearcher(RowMetaData metaData, int... effectColumnIds) {
		super(metaData, effectColumnIds);
		setDefaultMatchFilter(StringMatchType.REGEX_MATCH);
	}

	public StringFieldSearcher(RowMetaData metaData, String... effectColumnNames) {
		this(metaData, checkNotNull(metaData,"metaData is null").columnIDsOf(effectColumnNames));
	}

	public <M extends TableManager<B>> StringFieldSearcher(Class<M> interfaceClass, int[] effectColumnId) {
		this(baseManagerOf(interfaceClass).metaData, effectColumnId);
	}

	public <M extends TableManager<B>> StringFieldSearcher(Class<M> interfaceClass, String... effectColumnNames) {
		this(baseManagerOf(interfaceClass).metaData, effectColumnNames);
	}

	@Override
	protected String keyOf(B bean) {
		// 返回空则视为null
		return Strings.emptyToNull(checkNotNull(funKeyGetter,"funKeyGetter is uninitialized").apply(bean));
	}
	
	public Function<B, String> getFunKeyGetter() {
		return funKeyGetter;
	}

	public StringFieldSearcher<B> setFunKeyGetter(Function<B, String> funKeyGetter) {
		this.funKeyGetter = funKeyGetter;
		return this;
	}
	
	public StringFieldSearcher<B> setDefaultMatchFilter(StringMatchType defaultMatchType){
		if(defaultMatchType != null){
			setDefaultMatchFilter(defaultMatchType.createMatchFilter());
		}
		return this;
	}
	public final <T> Multimap<String, T> search(String key, int matchFlags, StringMatchType matchType, Predicate<T> pkFilter){
		return search(key,matchFlags, matchType == null ? null : matchType.createMatchFilter(), pkFilter);
	}
}
