package gu.sql2java.phoenix;

import gu.sql2java.SqlFormatters.QuoteFormatter;
import gu.sql2java.utils.CaseSupport;

public class PhonenixSqlFormatter extends QuoteFormatter {
    
    public PhonenixSqlFormatter() {
        super("\"");
    }
    
    @Override
    public String tablename(String tablename) {
        return quoteIf(tablename, CaseSupport::hasLowerCase);
    }

    @Override
    public String columname(String columname) {
        return quoteIf(columname, CaseSupport::hasLowerCase);
    }

}
