/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Equivalence;
import java.util.Arrays;
import java.util.Objects;

public class DeepEquivalence
extends Equivalence<Object> {
    public static final Equivalence<Object> DEEP_EQUIVALENCE = new DeepEquivalence();

    protected boolean doEquivalent(Object a, Object b) {
        return Objects.deepEquals(a, b);
    }

    protected int doHash(Object object) {
        return DeepEquivalence.deepHashCode(object);
    }

    public static final int deepHashCode(Object a) {
        if (a == null) {
            return 0;
        }
        if (a instanceof Object[]) {
            return Arrays.deepHashCode((Object[])a);
        }
        if (a instanceof byte[]) {
            return Arrays.hashCode((byte[])a);
        }
        if (a instanceof short[]) {
            return Arrays.hashCode((short[])a);
        }
        if (a instanceof int[]) {
            return Arrays.hashCode((int[])a);
        }
        if (a instanceof long[]) {
            return Arrays.hashCode((long[])a);
        }
        if (a instanceof char[]) {
            return Arrays.hashCode((char[])a);
        }
        if (a instanceof float[]) {
            return Arrays.hashCode((float[])a);
        }
        if (a instanceof double[]) {
            return Arrays.hashCode((double[])a);
        }
        if (a instanceof boolean[]) {
            return Arrays.hashCode((boolean[])a);
        }
        return a.hashCode();
    }
}

