/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseForeignKeyListener;
import gu.sql2java.BaseRow;
import gu.sql2java.Constant;
import gu.sql2java.ForeignKeyMetaData;
import gu.sql2java.IDataSourceConfig;
import gu.sql2java.IndexMetaData;
import gu.sql2java.ListenerContainer;
import gu.sql2java.ListenerContainerLocal;
import gu.sql2java.Manager;
import gu.sql2java.Managers;
import gu.sql2java.PageQueryImplType;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableListener;
import gu.sql2java.TableManager;
import gu.sql2java.exception.DaoException;
import gu.sql2java.exception.DataAccessException;
import gu.sql2java.exception.DataRetrievalException;
import gu.sql2java.exception.ObjectRetrievalException;
import gu.sql2java.exception.OptimisticLockingException;
import gu.sql2java.exception.QueueTimeoutException;
import gu.sql2java.exception.RuntimeDaoException;
import gu.sql2java.pagehelper.Page;
import gu.sql2java.pagehelper.PageHelper;
import gu.sql2java.parser.ParserSupport;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class BaseTableManager<B extends BaseBean>
implements TableManager<B>,
Constant {
    protected final RowMetaData metaData;
    private volatile Manager manager;
    private volatile Map<String, TableListener<BaseBean>> foreignKeyDeleteListeners;
    private volatile ListenerContainerLocal<B> listenerContainer;
    private volatile String generatedkeyStatement;
    private static boolean debug = false;
    private final Function<String, String> columnExpFun = input -> input + "=?";

    protected BaseTableManager(String tablename) {
        this.metaData = RowMetaData.getMetaData((String)tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerContainer<B> getListenerContainer() {
        if (this.listenerContainer == null) {
            BaseTableManager baseTableManager = this;
            synchronized (baseTableManager) {
                if (this.listenerContainer == null) {
                    this.listenerContainer = new ListenerContainerLocal(this.getManager().getFireType());
                }
            }
        }
        return this.listenerContainer;
    }

    public IDataSourceConfig getDataSourceConfig() {
        return this.getManager().config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, TableListener<BaseBean>> getForeignKeyDeleteListeners() {
        if (this.foreignKeyDeleteListeners == null) {
            BaseTableManager baseTableManager = this;
            synchronized (baseTableManager) {
                if (this.foreignKeyDeleteListeners == null) {
                    LinkedHashMap map = Maps.newLinkedHashMap();
                    for (ForeignKeyMetaData fk : this.metaData.getForeignKeysForListener()) {
                        map.put(fk.name, new DeleteRuleListener(fk.name));
                    }
                    this.foreignKeyDeleteListeners = Collections.unmodifiableMap(map);
                }
            }
        }
        return this.foreignKeyDeleteListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGeneratedkeyStatement() {
        if (this.generatedkeyStatement == null) {
            BaseTableManager baseTableManager = this;
            synchronized (baseTableManager) {
                if (this.generatedkeyStatement == null) {
                    this.generatedkeyStatement = ((String)Preconditions.checkNotNull((Object)this.getManager().getGeneratedkeyStatement(), (Object)"INVALID generatedkeyStatement")).replaceAll("<TABLE>", this.metaData.tablename).replaceAll("<KEY>", this.metaData.columnNameOf(this.metaData.autoincrementColumnId));
                    if (debug) {
                        SimpleLog.log((String)"generatedkeyStatement={}", (Object[])new Object[]{this.generatedkeyStatement});
                    }
                }
            }
        }
        return this.generatedkeyStatement;
    }

    public final B createBean() {
        try {
            return (B)((BaseBean)this.metaData.beanType.newInstance());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected final B createBean(Object ... primaryValues) {
        Preconditions.checkArgument((primaryValues != null && primaryValues.length == this.metaData.primaryKeyNames.length ? 1 : 0) != 0, (Object)"INVALID primaryValues");
        B bean = this.createBean();
        int[] pkIds = this.metaData.primaryKeyIds;
        for (int i = 0; i < primaryValues.length; ++i) {
            int columnId = pkIds[i];
            Object value = primaryValues[i];
            Preconditions.checkArgument((null == value || this.metaData.columnTypeOf(columnId).isInstance(value) ? 1 : 0) != 0, (String)"INVALID primkey type for %s,%s required", (Object)this.metaData.columnNameOf(columnId), (Object)this.metaData.columnTypeOf(columnId).getName());
            bean.setValue(columnId, value);
        }
        return bean;
    }

    private static int indexOfFirstNull(Object ... objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (null != objects[i]) continue;
                return i;
            }
            return -1;
        }
        return -2;
    }

    private static boolean hasNull(Object ... objects) {
        return BaseTableManager.indexOfFirstNull(objects) != -1;
    }

    private static <T extends BaseBean> boolean hasNullPk(T bean) {
        return null == bean || BaseTableManager.hasNull(bean.primaryValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAutoincrement(Connection c, PreparedStatement ps, B bean) throws SQLException {
        if (!bean.isModified(this.metaData.autoincrementColumnId)) {
            PreparedStatement ps2 = null;
            ResultSet rs = null;
            try {
                Manager.AutoKeyRetrieveType retrieveType = this.getManager().getGeneratedkeyRetrieveType();
                if (Manager.AutoKeyRetrieveType.auto.equals((Object)retrieveType)) {
                    rs = ps.getGeneratedKeys();
                } else {
                    ps2 = this.getManager().getStatementCache().prepareStatement(c, this.getGeneratedkeyStatement(), false, false, null);
                    rs = ps2.executeQuery();
                }
                if (!rs.next()) {
                    throw new IllegalStateException(SimpleLog.logString((String)"ATTENTION: Could not retrieve generated key!(retrieveType:{})", (Object[])new Object[]{retrieveType}));
                }
                this.setColumnValue(bean, this.metaData.autoincrementColumnId, this.getManager().getObject(rs, 1, (Class)this.metaData.columnTypes.get(this.metaData.autoincrementColumnId)));
                this.getManager().close(ps2, rs);
            }
            catch (Throwable throwable) {
                this.getManager().close(ps2, rs);
                throw throwable;
            }
        }
    }

    protected B insert(B bean) {
        B b;
        if (null == bean || !bean.beModified()) {
            return bean;
        }
        String productName = this.getManager().getProductName();
        if (!bean.isNew() && !productName.equals("Phoenix")) {
            return this.update(bean);
        }
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getConnection();
            Manager.AutoKeyRetrieveType retrieveType = this.getManager().getGeneratedkeyRetrieveType();
            if (this.metaData.autoincrementColumnId >= 0) {
                bean.resetPrimaryKeysModified();
            }
            if (this.metaData.autoincrementColumnId >= 0 && Manager.AutoKeyRetrieveType.before.equals((Object)retrieveType)) {
                this.prepareAutoincrement(c, null, bean);
            }
            this.getListenerContainer().beforeInsert(bean);
            String cmd = productName.equals("Phoenix") ? "UPSERT " : "INSERT ";
            StringBuilder builder = new StringBuilder(cmd + " INTO " + this.metaData.tablename + " (");
            Iterable modifiedList = Iterables.filter((Iterable)this.metaData.columnNames, arg_0 -> bean.isModified(arg_0));
            String fields = Joiner.on((String)",").join(modifiedList);
            builder.append(fields);
            builder.append(") values (");
            builder.append(fields.replaceAll("[^,]+", "?"));
            builder.append(")");
            ps = this.metaData.autoincrementColumnId >= 0 && Manager.AutoKeyRetrieveType.auto.equals((Object)retrieveType) ? this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, cmd, 1) : this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, cmd, 1003, 1007);
            this.fillPreparedStatement(ps, bean, 0, true);
            ps.executeUpdate();
            if (this.metaData.autoincrementColumnId >= 0 && !Manager.AutoKeyRetrieveType.before.equals((Object)retrieveType)) {
                this.prepareAutoincrement(c, ps, bean);
            }
            bean.setNew(false);
            bean.resetIsModified();
            this.getListenerContainer().afterInsert(bean);
            b = bean;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.getListenerContainer().done();
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
        this.getListenerContainer().done();
        this.getManager().close(ps);
        this.freeConnection(c);
        return b;
    }

    private String makeInsertValuesSql(String cmd, List<String> fields, int lineCount) throws SQLException {
        String valueLine;
        Manager.AutoKeyRetrieveType retrieveType = this.getManager().getGeneratedkeyRetrieveType();
        String columnNames = Joiner.on((char)',').join(fields);
        if (this.metaData.autoincrementColumnId >= 0 && Manager.AutoKeyRetrieveType.before.equals((Object)retrieveType)) {
            valueLine = "(" + this.getGeneratedkeyStatement() + "," + columnNames.replaceAll("[^,]+", "?") + ")";
            columnNames = this.metaData.primaryKeyNames[0] + "," + columnNames;
        } else {
            valueLine = "(" + columnNames.replaceAll("[^,]+", "?") + ")";
        }
        StringBuilder builder = new StringBuilder(cmd + " INTO " + this.metaData.tablename + " (" + columnNames + ") VALUES ");
        int endIdx = lineCount;
        for (int idx = 0; idx < endIdx; ++idx) {
            if (idx > 0) {
                builder.append(",");
            }
            builder.append(valueLine);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Iterable<B>> void fastInsert(int[] fieldList, C beans) {
        Object fields;
        if (null == beans) {
            return;
        }
        Iterable nonullBeans = Iterables.filter(beans, (Predicate)Predicates.notNull());
        if (Iterables.isEmpty((Iterable)nonullBeans)) {
            return;
        }
        if (null != fieldList && fieldList.length > 0) {
            for (int columnId : fieldList) {
                Preconditions.checkArgument((columnId >= 0 && columnId < this.metaData.columnCount ? 1 : 0) != 0, (String)"INVALID column id %s", (int)columnId);
            }
            Iterable columnNameList = Iterables.transform((Iterable)Ints.asList((int[])fieldList), arg_0 -> this.metaData.columnFullFieldList.get(arg_0));
            fields = Lists.newArrayList((Iterable)columnNameList);
        } else {
            fieldList = this.metaData.defaultColumnIdList;
            fields = this.metaData.columnFullFieldList;
        }
        Connection c = null;
        PreparedStatement ps = null;
        try {
            String productName;
            String cmd;
            c = this.getConnection();
            if (this.metaData.autoincrementColumnId >= 0) {
                nonullBeans.forEach(b -> b.resetPrimaryKeysModified());
            }
            String string = cmd = (productName = this.getManager().getProductName()).equals("Phoenix") ? "UPSERT" : "INSERT";
            if (this.getManager().isSupportInsertValues()) {
                String sql = this.makeInsertValuesSql(cmd, (List<String>)fields, Iterables.size((Iterable)nonullBeans));
                ps = this.getManager().getStatementCache().prepareStatement(c, sql, false, debug, cmd, 1003, 1007);
                int dirtyCount = 0;
                for (BaseBean bean : nonullBeans) {
                    for (int columnId : fieldList) {
                        Manager.fillPreparedStatement(ps, ++dirtyCount, bean.getValue(columnId), this.metaData.sqlTypes[columnId]);
                    }
                }
                ps.executeUpdate();
            } else {
                String sql = this.makeInsertValuesSql(cmd, (List<String>)fields, 1);
                ps = this.getManager().getStatementCache().prepareStatement(c, sql, false, debug, cmd, 1003, 1007);
                for (BaseBean bean : nonullBeans) {
                    int dirtyCount = 0;
                    for (int columnId : fieldList) {
                        Manager.fillPreparedStatement(ps, ++dirtyCount, bean.getValue(columnId), this.metaData.sqlTypes[columnId]);
                    }
                    ps.addBatch();
                }
                c.setAutoCommit(false);
                boolean commit = false;
                try {
                    ps.executeBatch();
                    commit = true;
                }
                finally {
                    if (commit) {
                        c.commit();
                    } else {
                        c.rollback();
                    }
                }
            }
            this.getManager().close(ps);
            this.freeConnection(c);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
    }

    protected B update(B bean) throws RuntimeDaoException {
        B b;
        int dirtyCount;
        Object oldLockValue;
        PreparedStatement ps;
        Connection c;
        block19: {
            if (null == bean || !bean.beModified()) {
                return bean;
            }
            if (bean.isNew()) {
                return this.insert(bean);
            }
            if (this.getManager().getProductName().equals("Phoenix")) {
                return this.insert(bean);
            }
            c = null;
            ps = null;
            c = this.getConnection();
            this.getListenerContainer().beforeUpdate(bean);
            oldLockValue = null;
            if (this.metaData.lockColumnType != null) {
                oldLockValue = bean.getValue(this.metaData.lockColumnName);
                if (String.class == this.metaData.lockColumnType) {
                    bean.setValue(this.metaData.lockColumnName, (Object)String.valueOf(System.currentTimeMillis()));
                } else if (Long.class == this.metaData.lockColumnType) {
                    bean.setValue(this.metaData.lockColumnName, (Object)System.currentTimeMillis());
                } else {
                    throw new RuntimeException(SimpleLog.logString((String)"INVALID LOCK COLUMN TYPE:{},String or Long required", (Object[])new Object[]{this.metaData.lockColumnType}));
                }
            }
            StringBuilder builder = new StringBuilder("UPDATE " + this.metaData.tablename + " SET ");
            builder.append(Joiner.on((String)",").join(Iterables.transform((Iterable)Iterables.filter((Iterable)this.metaData.columnNames, arg_0 -> bean.isModified(arg_0)), this.columnExpFun)));
            builder.append(" WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Lists.transform(Arrays.asList(this.metaData.primaryKeyNames), this.columnExpFun)));
            if (this.metaData.lockColumnType != null) {
                if (this.metaData.primaryKeyNames.length > 0) {
                    builder.append(" AND ");
                }
                Preconditions.checkArgument((this.metaData.lockColumnName != null ? 1 : 0) != 0, (Object)"NOT DEFINED lock column name");
                builder.append(this.metaData.lockColumnName + "=?");
            }
            if ((dirtyCount = this.fillPreparedStatement(ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), true, debug, "update", 1003, 1007), bean, 0, true)) != 0) break block19;
            if (debug) {
                SimpleLog.log((String)"The bean to look is not initialized... do not update.", (Object[])new Object[0]);
            }
            B b2 = bean;
            this.getListenerContainer().done();
            this.getManager().close(ps);
            this.freeConnection(c);
            return b2;
        }
        try {
            int[] pkIds = this.metaData.primaryKeyIds;
            for (int i = 0; i < pkIds.length; ++i) {
                this.setPreparedStatementWithBean(ps, ++dirtyCount, bean, pkIds[i]);
            }
            if (this.metaData.lockColumnType != null) {
                this.setPreparedStatement(ps, ++dirtyCount, oldLockValue, this.metaData.columnIDOf(this.metaData.lockColumnName));
            }
            int rowCount = ps.executeUpdate();
            if (this.metaData.lockColumnType != null && rowCount == 0) {
                throw new OptimisticLockingException("sql2java.exception.optimisticlock");
            }
            this.getListenerContainer().afterUpdate((Object)bean.clone());
            bean.resetIsModified();
            b = bean;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.getListenerContainer().done();
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
        this.getListenerContainer().done();
        this.getManager().close(ps);
        this.freeConnection(c);
        return b;
    }

    public int countAll() throws RuntimeDaoException {
        return this.countWhere("");
    }

    public int countUsingTemplate(B bean) throws RuntimeDaoException {
        return this.countUsingTemplate(bean, 0);
    }

    public int deleteAll() throws RuntimeDaoException {
        return this.deleteByWhere("");
    }

    public B[] loadAll() throws RuntimeDaoException {
        return this.loadByWhere(null);
    }

    public int loadAll(TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByWhere(null, action);
    }

    public B[] loadAll(int startRow, int numRows) throws RuntimeDaoException {
        return this.loadByWhereAsList(null, null, startRow, numRows).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    public int loadAll(int startRow, int numRows, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByWhereForAction(null, null, null, startRow, numRows, action);
    }

    public List<B> loadAllAsList() throws RuntimeDaoException {
        return this.loadUsingTemplateAsList(null, 1, -1, 0);
    }

    public List<B> loadAllAsList(int startRow, int numRows) throws RuntimeDaoException {
        return this.loadUsingTemplateAsList(null, startRow, numRows, 0);
    }

    public B loadByPrimaryKey(B bean) throws RuntimeDaoException {
        return bean == null ? null : (B)this.loadByPrimaryKey(bean.primaryValues());
    }

    public B loadByPrimaryKeyChecked(B bean) throws RuntimeDaoException, ObjectRetrievalException {
        return this.loadByPrimaryKeyChecked(((BaseBean)Preconditions.checkNotNull(bean, (Object)"bean is null")).primaryValues());
    }

    public final B loadByPrimaryKeyChecked(Object ... keys) throws RuntimeDaoException, ObjectRetrievalException {
        if (this.metaData.primaryKeyNames.length == 0) {
            throw new UnsupportedOperationException();
        }
        String[] pkNames = this.metaData.primaryKeyNames;
        int[] pkIds = this.metaData.primaryKeyIds;
        if (BaseTableManager.hasNull(keys)) {
            throw new ObjectRetrievalException((Throwable)new NullPointerException("primary key must not be null"));
        }
        Preconditions.checkArgument((keys.length == pkNames.length ? 1 : 0) != 0, (String)"INVALID ARGUMENT NUM, %s required", (int)pkNames.length);
        for (int i = 0; i < pkNames.length; ++i) {
            Object key = keys[i];
            Class type = this.metaData.columnTypeOf(pkIds[i]);
            Preconditions.checkArgument((boolean)type.isAssignableFrom(key.getClass()), (String)"INVALID type for pk %s,%s required", (Object)pkNames[i], (Object)type.getName());
        }
        return this.doLoadByPrimaryKeyChecked(keys);
    }

    protected B doLoadByPrimaryKeyChecked(Object ... keys) throws RuntimeDaoException, ObjectRetrievalException {
        PreparedStatement ps;
        Connection c;
        block10: {
            if (this.metaData.primaryKeyNames.length == 0) {
                throw new UnsupportedOperationException();
            }
            String[] pkNames = this.metaData.primaryKeyNames;
            int[] pkIds = this.metaData.primaryKeyIds;
            if (BaseTableManager.hasNull(keys)) {
                throw new ObjectRetrievalException((Throwable)new NullPointerException("primary key must not be null"));
            }
            Preconditions.checkArgument((keys.length == pkNames.length ? 1 : 0) != 0, (String)"INVALID ARGUMENT NUM, %s required", (int)pkNames.length);
            for (int i = 0; i < pkNames.length; ++i) {
                Object key = keys[i];
                Class type = this.metaData.columnTypeOf(pkIds[i]);
                Preconditions.checkArgument((boolean)type.isAssignableFrom(key.getClass()), (String)"INVALID type for pk %s,%s required", (Object)pkNames[i], (Object)type.getName());
            }
            c = null;
            ps = null;
            c = this.getConnection();
            StringBuilder builder = new StringBuilder("SELECT " + this.metaData.columnFullFields + " FROM " + this.metaData.tablename + " WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Lists.transform(Arrays.asList(pkNames), this.columnExpFun)));
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, "LOAD BY PK", 1003, 1007);
            for (int i = 0; i < pkNames.length; ++i) {
                this.setPreparedStatement(ps, i + 1, keys[i], pkIds[i]);
            }
            ListAction action = new ListAction(true);
            this.loadByPreparedStatement(ps, null, 1, -1, action);
            List pReturn = action.getList();
            if (1 != pReturn.size()) break block10;
            BaseBean baseBean = (BaseBean)pReturn.get(0);
            this.getManager().close(ps);
            this.freeConnection(c);
            return (B)baseBean;
        }
        try {
            try {
                throw new ObjectRetrievalException();
            }
            catch (ObjectRetrievalException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new RuntimeDaoException((Throwable)new DataRetrievalException((Throwable)e));
            }
        }
        catch (Throwable throwable) {
            this.getManager().close(ps);
            this.freeConnection(c);
            throw throwable;
        }
    }

    public B loadByPrimaryKey(Object ... keys) throws RuntimeDaoException {
        try {
            return this.loadByPrimaryKeyChecked(keys);
        }
        catch (ObjectRetrievalException e) {
            return null;
        }
    }

    protected <K> List<B> loadByPks(Collection<K> keys) {
        Preconditions.checkState((this.metaData.primaryKeyCount == 1 ? 1 : 0) != 0, (Object)"UNSUPPORTED OPERATION");
        if (null == keys) {
            return Collections.emptyList();
        }
        ArrayList<B> list = new ArrayList<B>(keys.size());
        for (K key : keys) {
            list.add(this.loadByPrimaryKey(new Object[]{key}));
        }
        return list;
    }

    protected <K> List<B> loadByPks(K ... keys) {
        if (null == keys) {
            return Collections.emptyList();
        }
        return this.loadByPks((Collection<K>)Arrays.asList(keys));
    }

    public boolean existsByPrimaryKey(B bean) throws RuntimeDaoException {
        return null == bean ? false : this.existsPrimaryKey(bean.primaryValues());
    }

    public B checkDuplicate(B bean) throws RuntimeDaoException, ObjectRetrievalException {
        if (this.existsByPrimaryKey(bean)) {
            throw new ObjectRetrievalException("Duplicate entry (" + bean.primaryValues() + ") for key 'PRIMARY'");
        }
        return bean;
    }

    public final boolean existsPrimaryKey(Object ... keys) throws RuntimeDaoException {
        if (this.metaData.primaryKeyNames.length == 0) {
            throw new UnsupportedOperationException();
        }
        String[] pkNames = this.metaData.primaryKeyNames;
        int[] pkIds = this.metaData.primaryKeyIds;
        if (null == keys || BaseTableManager.hasNull(keys)) {
            return false;
        }
        Preconditions.checkArgument((keys.length == pkNames.length ? 1 : 0) != 0, (String)"INVALID ARGUMENT NUM, %s required", (int)pkNames.length);
        for (int i = 0; i < pkNames.length; ++i) {
            Object key = keys[i];
            Class type = this.metaData.columnTypeOf(pkIds[i]);
            Preconditions.checkArgument((boolean)type.isInstance(key), (String)"INVALID type for pk %s,%s required", (Object)pkNames[i], (Object)type.getName());
        }
        return this.doExistsPrimaryKey(keys);
    }

    protected boolean doExistsPrimaryKey(Object ... keys) throws RuntimeDaoException {
        String[] pkNames = this.metaData.primaryKeyNames;
        int[] pkIds = this.metaData.primaryKeyIds;
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getConnection();
            String col = 1 == this.metaData.primaryKeyCount ? this.metaData.primaryKeyNames[0] : "1";
            StringBuilder builder = new StringBuilder("SELECT COUNT(" + col + ") AS MCOUNT FROM " + this.metaData.tablename + " WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Lists.transform(Arrays.asList(pkNames), this.columnExpFun)));
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, "ExistsPrimaryKey", 1003, 1007);
            for (int i = 0; i < pkNames.length; ++i) {
                this.setPreparedStatement(ps, i + 1, keys[i], pkIds[i]);
            }
            boolean bl = 1 == this.getManager().runPreparedStatementForValue(Number.class, ps).intValue();
            this.getManager().close(ps);
            this.freeConnection(c);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new ObjectRetrievalException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
    }

    protected <T> T checkDuplicateByPk(T primaryKeyValue) throws ObjectRetrievalException {
        if (this.metaData.primaryKeyNames.length != 1) {
            throw new UnsupportedOperationException();
        }
        if (this.existsPrimaryKey(primaryKeyValue)) {
            throw new ObjectRetrievalException("Duplicate entry '" + primaryKeyValue + "' for key 'PRIMARY'");
        }
        return primaryKeyValue;
    }

    public B[] loadByWhere(String where) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, null, 1, -1).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    public int loadByWhere(String where, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByJoinWhereForAction(null, where, null, null, 1, -1, action);
    }

    public B[] loadByWhere(String where, int[] fieldList) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, fieldList, 1, -1).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    public int loadByWhere(String where, int[] fieldList, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByJoinWhereForAction(null, where, null, fieldList, 1, -1, action);
    }

    public B[] loadByWhere(String where, int[] fieldList, int startRow, int numRows) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, fieldList, startRow, numRows).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    public int loadByWhere(String where, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByJoinWhereForAction(null, where, null, fieldList, startRow, numRows, action);
    }

    public List<B> loadByWhereAsList(String where) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, null, 1, -1);
    }

    public List<B> loadByJoinWhereAsList(String join, String where) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(join, where, null, 1, -1);
    }

    public List<B> loadByWhereAsList(String where, int[] fieldList) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, fieldList, 1, -1);
    }

    public List<B> loadByJoinWhereAsList(String join, String where, Object[] argList, int[] fieldList) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(join, where, fieldList, 1, -1);
    }

    public List<B> loadByWhereAsList(String where, int[] fieldList, int startRow, int numRows) throws RuntimeDaoException {
        return this.loadByJoinWhereAsList(null, where, fieldList, startRow, numRows);
    }

    public List<B> loadByJoinWhereAsList(String join, String where, int[] fieldList, int startRow, int numRows) throws RuntimeDaoException {
        ListAction action = new ListAction();
        this.loadByJoinWhereForAction(join, where, null, fieldList, startRow, numRows, action);
        return action.getList();
    }

    public int loadByWhereForAction(String where, Object[] argList, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadByJoinWhereForAction(null, where, argList, fieldList, startRow, numRows, action);
    }

    public int loadByJoinWhereForAction(String join, String where, Object[] argList, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) throws RuntimeDaoException {
        String sql = this.createSelectSql(fieldList, join, where);
        return this.loadBySqlForAction(sql, argList, fieldList, startRow, numRows, action);
    }

    public B[] loadUsingTemplate(B bean) throws RuntimeDaoException {
        return this.loadUsingTemplate((BaseBean)bean, 1, -1, 0);
    }

    public int loadUsingTemplate(B bean, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadUsingTemplate(bean, null, 1, -1, 0, action);
    }

    public B[] loadUsingTemplate(B bean, int startRow, int numRows) throws RuntimeDaoException {
        return this.loadUsingTemplate((BaseBean)bean, startRow, numRows, 0);
    }

    public int loadUsingTemplate(B bean, int startRow, int numRows, TableManager.Action<B> action) throws RuntimeDaoException {
        return this.loadUsingTemplate(bean, null, startRow, numRows, 0, action);
    }

    public B[] loadUsingTemplate(B bean, int startRow, int numRows, int searchType) throws RuntimeDaoException {
        return this.loadUsingTemplateAsList(bean, startRow, numRows, searchType).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    public List<B> loadUsingTemplateAsList(B bean) throws RuntimeDaoException {
        return this.loadUsingTemplateAsList(bean, 1, -1, 0);
    }

    public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows) throws RuntimeDaoException {
        return this.loadUsingTemplateAsList(bean, startRow, numRows, 0);
    }

    public List<B> loadUsingTemplateAsList(B bean, int startRow, int numRows, int searchType) throws RuntimeDaoException {
        ListAction action = new ListAction();
        this.loadUsingTemplate(bean, null, startRow, numRows, searchType, action);
        return action.getList();
    }

    public B loadUniqueUsingTemplate(B bean) {
        try {
            return this.loadUniqueUsingTemplateChecked(bean);
        }
        catch (ObjectRetrievalException e) {
            return null;
        }
    }

    public B loadUniqueUsingTemplateChecked(B bean) throws ObjectRetrievalException {
        List beans = (List)this.runWithNoPage(new Callable<List<B>>((BaseBean)bean){
            final /* synthetic */ BaseBean val$bean;
            {
                this.val$bean = baseBean;
            }

            @Override
            public List<B> call() throws Exception {
                return BaseTableManager.this.loadUsingTemplateAsList(this.val$bean);
            }
        });
        switch (beans.size()) {
            case 0: {
                throw new ObjectRetrievalException("Not found element !!");
            }
            case 1: {
                return (B)((BaseBean)beans.get(0));
            }
        }
        throw new RuntimeDaoException((Throwable)new ObjectRetrievalException("More than one element !!"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadUsingTemplate(B bean, int[] fieldList, int startRow, int numRows, int searchType, TableManager.Action<B> action) {
        int n;
        Connection c;
        PreparedStatement ps;
        block11: {
            int n2;
            block10: {
                StringBuilder sqlWhere = new StringBuilder("");
                String sql = this.createSelectSql(fieldList, null, this.fillWhere(sqlWhere, bean, searchType) > 0 ? " WHERE " + sqlWhere.toString() : null);
                ps = null;
                c = null;
                try {
                    c = this.getConnection();
                    AtomicLong count = new AtomicLong(-1L);
                    Manager.setLocalfillPreparedStatement((BaseRow)bean, searchType, false);
                    String wrapped = this.getManager().rebuildSelectSql(c, sql, startRow, numRows, count, debug);
                    if (0L == count.get()) {
                        int n3 = 0;
                        return n3;
                    }
                    sql = (String)MoreObjects.firstNonNull((Object)wrapped, (Object)sql);
                    ps = this.getManager().getStatementCache().prepareStatement(c, sql, false, debug, "loadUsingTemplate", 1003, 1007);
                    this.fillPreparedStatement(ps, bean, searchType, false);
                    if (null != wrapped) {
                        n2 = this.loadByPreparedStatement(ps, fieldList, 1, -1, action);
                        this.getManager().close(ps);
                        this.freeConnection(c);
                        break block10;
                    }
                    n = this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
                    this.getManager().close(ps);
                    break block11;
                }
                catch (DaoException e) {
                    throw new RuntimeDaoException((Throwable)e);
                }
                catch (SQLException e) {
                    throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
                }
            }
            Manager.removeLocalfillPreparedStatement();
            return n2;
        }
        this.freeConnection(c);
        Manager.removeLocalfillPreparedStatement();
        return n;
        finally {
            this.getManager().close(ps);
            this.freeConnection(c);
            Manager.removeLocalfillPreparedStatement();
        }
    }

    private <F extends BaseBean> List<B> loadByForeignKeyAsList(F left, Map<Integer, Integer> columnsMap, int startRow, int numRows) {
        if (null == left) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((columnsMap != null && !columnsMap.isEmpty() ? 1 : 0) != 0, (Object)"columnsMap is null or empty");
        BaseBean bean = this.createBean().copy(left, columnsMap);
        return this.loadUsingTemplateAsList(bean, startRow, numRows);
    }

    protected <F extends BaseBean> List<B> loadByForeignKeyAsList(String fkName, F left, int startRow, int numRows) {
        ImmutableBiMap columnsMap = this.metaData.foreignKeyIdMapOf(fkName).inverse();
        return this.loadByForeignKeyAsList(left, (Map<Integer, Integer>)columnsMap, startRow, numRows);
    }

    public void foreachByWhere(TableManager.DoEach<B> each, boolean stopOnError, String where) throws RuntimeDaoException {
        this.foreachByJoinWhere(each, stopOnError, null, where);
    }

    public void foreachByJoinWhere(TableManager.DoEach<B> each, boolean stopOnError, String join, String where) throws RuntimeDaoException {
        Preconditions.checkArgument((each != null ? 1 : 0) != 0, (Object)"action is null");
        List<B> beans = this.loadByJoinWhereAsList(join, where, null, null);
        for (BaseBean bean : beans) {
            try {
                if (!each.doEach((Object)bean)) continue;
                this.delete((B)bean);
            }
            catch (Exception e) {
                if (!stopOnError) continue;
                return;
            }
        }
    }

    public void foreach(TableManager.DoEach<B> each, boolean stopOnError) throws RuntimeDaoException {
        this.foreachByWhere(each, stopOnError, null);
    }

    public B save(B bean) throws RuntimeDaoException {
        if (null != bean) {
            if (bean.isNew()) {
                this.insert(bean);
            } else {
                this.update(bean);
            }
        }
        return bean;
    }

    public B addIfAbsent(B bean) throws RuntimeDaoException {
        try {
            if (bean == null) {
                return bean;
            }
            bean.setNew(true);
            return this.insert(bean);
        }
        catch (RuntimeDaoException e) {
            B exists;
            if (DaoException.stripSQLException((Throwable)e) instanceof SQLIntegrityConstraintViolationException && (exists = this.loadByPrimaryKey(bean)) != null) {
                return exists;
            }
            throw e;
        }
    }

    public B[] save(B[] beans) throws RuntimeDaoException {
        if (null != beans) {
            for (B bean : beans) {
                this.save((Collection)bean);
            }
        }
        return beans;
    }

    public <C extends Collection<B>> C save(C beans) throws RuntimeDaoException {
        if (null != beans) {
            for (BaseBean bean : beans) {
                this.save((C)bean);
            }
        }
        return beans;
    }

    public <C extends Collection<B>> C saveAsTransaction(final C beans) throws RuntimeDaoException {
        return (C)((Collection)this.runAsTransaction(new Callable<C>(){

            @Override
            public C call() throws Exception {
                return BaseTableManager.this.save(beans);
            }
        }));
    }

    public B[] saveAsTransaction(final B[] beans) throws RuntimeDaoException {
        return (BaseBean[])this.runAsTransaction(new Callable<B[]>(){

            @Override
            public B[] call() throws Exception {
                return BaseTableManager.this.save(beans);
            }
        });
    }

    static String checkJoin(String join) {
        if (!(join = ((String)MoreObjects.firstNonNull((Object)join, (Object)"")).trim()).isEmpty()) {
            Preconditions.checkArgument((boolean)join.toUpperCase().matches("^(JOIN|LEFT|RIGHT) +.*"), (Object)"JOIN expression must start with 'JOIN|LEFT|RIGHT'(case insensitive)");
        }
        return join;
    }

    public <T> List<T> loadColumnAsList(String column, boolean distinct, String where, int startRow, int numRows) throws RuntimeDaoException {
        int columnId = this.metaData.columnIDOf(column);
        Preconditions.checkArgument((columnId >= 0 ? 1 : 0) != 0, (String)"INVALID column name %s", (Object)column);
        String sql = String.format("SELECT %s " + this.metaData.columnNameOf(columnId) + " FROM %s %s", distinct ? "DISTINCT" : "", this.metaData.tablename, MoreObjects.firstNonNull((Object)where, (Object)""));
        return this.runSqlAsList((Class)this.metaData.columnTypes.get(columnId), sql, new Object[0]);
    }

    private String createSelectSql(int[] fieldList, String join, String where) {
        StringBuffer sql = new StringBuffer(128);
        if (null == fieldList || 0 == fieldList.length) {
            sql.append("SELECT ").append(this.metaData.columnFullFields);
        } else {
            Iterable validIdx = Iterables.filter((Iterable)Ints.asList((int[])fieldList), idx -> null != idx && idx >= 0 && idx < this.metaData.columnCount);
            sql.append("SELECT ").append(Joiner.on((char)',').join(Iterables.transform((Iterable)validIdx, arg_0 -> this.metaData.columnFullFieldList.get(arg_0))));
        }
        sql.append(" FROM " + this.metaData.tablename + " ");
        join = BaseTableManager.checkJoin(join);
        if (!join.isEmpty()) {
            sql.append(join + " ");
        }
        sql.append((String)MoreObjects.firstNonNull((Object)where, (Object)""));
        return sql.toString();
    }

    public int delete(B bean) {
        int n;
        if (this.metaData.primaryKeyNames.length == 0) {
            throw new UnsupportedOperationException();
        }
        if (BaseTableManager.hasNullPk(bean)) {
            return 0;
        }
        Connection c = null;
        PreparedStatement ps = null;
        String[] pks = this.metaData.primaryKeyNames;
        int[] pkIds = this.metaData.primaryKeyIds;
        try {
            this.getListenerContainer().beforeDelete(bean);
            c = this.getConnection();
            StringBuilder builder = new StringBuilder("DELETE  FROM " + this.metaData.tablename + " WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Lists.transform(Arrays.asList(pks), this.columnExpFun)));
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, "deleteByPrimaryKey", 1003, 1007);
            for (int i = 0; i < pkIds.length; ++i) {
                this.setPreparedStatementWithBean(ps, i + 1, bean, pkIds[i]);
            }
            int rows = ps.executeUpdate();
            if (rows > 0) {
                this.getListenerContainer().afterDelete(bean);
            }
            n = rows;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getListenerContainer().done();
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
        this.getListenerContainer().done();
        this.getManager().close(ps);
        this.freeConnection(c);
        return n;
    }

    protected <K> int deleteByPks(Collection<K> keys) {
        Preconditions.checkState((this.metaData.primaryKeyCount == 1 ? 1 : 0) != 0, (Object)"UNSUPPORTED OPERATION");
        int count = 0;
        if (null != keys) {
            for (K key : keys) {
                count += this.deleteByPrimaryKey(key);
            }
        }
        return count;
    }

    protected <K> int deleteByPks(K ... keys) {
        if (null == keys) {
            return 0;
        }
        return this.deleteByPks((Collection<K>)Arrays.asList(keys));
    }

    public int deleteByPrimaryKey(Object ... keys) throws RuntimeDaoException {
        if (BaseTableManager.hasNull(keys)) {
            return 0;
        }
        Preconditions.checkArgument((keys.length == this.metaData.primaryKeyCount ? 1 : 0) != 0, (Object)"argument number mismatch with primary key number");
        return this.delete(this.createBean(keys));
    }

    public int delete(B ... beans) throws RuntimeDaoException {
        int count = 0;
        if (null != beans) {
            for (B bean : beans) {
                count += this.delete(bean);
            }
        }
        return count;
    }

    public int delete(Collection<B> beans) throws RuntimeDaoException {
        int count = 0;
        if (null != beans) {
            for (BaseBean bean : beans) {
                count += this.delete((B)bean);
            }
        }
        return count;
    }

    public boolean setValueIfNonNull(B bean, String column, Object value) {
        B old;
        if (null != bean && null != (old = this.loadByPrimaryKey(bean))) {
            return bean.setValueIf(null != old.getValue(column), column, value);
        }
        return false;
    }

    public boolean setValueIfNonEqual(B bean, String column, Object value) {
        B old;
        if (null != bean && null != (old = this.loadByPrimaryKey(bean))) {
            return bean.setValueIf(!Objects.equals(old.getValue(column), value), column, value);
        }
        return false;
    }

    protected <T extends BaseBean> T getReferencedBean(String fkName, B bean) throws RuntimeDaoException {
        if (null == bean) {
            return null;
        }
        ForeignKeyMetaData foreignkey = (ForeignKeyMetaData)Preconditions.checkNotNull(this.metaData.foreignKeys.get(fkName), (String)"INVALID fkName %s for table %s", (Object)fkName, (Object)this.metaData.tablename);
        BaseTableManager<BaseBean> foreignManager = Managers.baseManagerOf(foreignkey.foreignTable);
        BaseBean t = foreignManager.createBean().copy(bean, (Map)this.metaData.foreignKeyIdMapOf(fkName));
        return (T)foreignManager.loadByPrimaryKey(t);
    }

    protected <T extends BaseBean> T setReferencedBean(String fkName, B bean, T beanToSet) throws RuntimeDaoException {
        if (null != bean) {
            ForeignKeyMetaData foreignkey = (ForeignKeyMetaData)Preconditions.checkNotNull(this.metaData.foreignKeys.get(fkName), (String)"INVALID fkName %s for table %s", (Object)fkName, (Object)this.metaData.tablename);
            TableManager foreignManager = Managers.managerOf(foreignkey.foreignTable);
            foreignManager.save(beanToSet);
            bean.copy(beanToSet, (Map)this.metaData.foreignKeyIdMapOf(fkName).inverse());
        }
        return beanToSet;
    }

    protected <T extends BaseBean> T[] getImportedBeans(String fkName, B bean) throws RuntimeDaoException {
        ForeignKeyMetaData foreignkey = this.metaData.getImportedKey(fkName);
        RowMetaData foreignMetaData = RowMetaData.getMetaData((String)foreignkey.foreignTable);
        return this.getImportedBeansAsList(fkName, bean).toArray((BaseBean[])Array.newInstance(foreignMetaData.beanType, 0));
    }

    protected <T extends BaseBean> List<T> getImportedBeansAsList(String fkName, B bean, int startRow, int numRows) throws RuntimeDaoException {
        ForeignKeyMetaData foreignkey = this.metaData.getImportedKey(fkName);
        TableManager foreignManager = Managers.managerOf(foreignkey.ownerTable);
        return Managers.baseManagerOf(foreignManager).loadByForeignKeyAsList(fkName, (BaseBean)bean, startRow, numRows);
    }

    protected <T extends BaseBean> List<T> getImportedBeansAsList(String fkName, B bean) throws RuntimeDaoException {
        return this.getImportedBeansAsList(fkName, bean, 1, -1);
    }

    protected <T extends BaseBean> List<T> getImportedBeansAsList(String fkName, Object ... keys) throws RuntimeDaoException {
        return this.getImportedBeansAsList(fkName, this.createBean(keys), 1, -1);
    }

    protected <T extends BaseBean> T[] getImportedBeans(String fkName, Object ... keys) throws RuntimeDaoException {
        ForeignKeyMetaData foreignkey = this.metaData.getImportedKey(fkName);
        RowMetaData foreignMetaData = RowMetaData.getMetaData((String)foreignkey.foreignTable);
        return this.getImportedBeansAsList(fkName, keys).toArray((BaseBean[])Array.newInstance(foreignMetaData.beanType, 0));
    }

    protected <T extends BaseBean, C extends Collection<T>> C setImportedBeans(String fkName, B bean, C importedBeans) throws RuntimeDaoException {
        if (null != importedBeans) {
            ForeignKeyMetaData foreignkey = this.metaData.getImportedKey(fkName);
            BaseTableManager<BaseBean> foreignManager = Managers.baseManagerOf(foreignkey.ownerTable);
            for (BaseBean importBean : importedBeans) {
                foreignManager.setReferencedBean(fkName, importBean, (T)bean);
            }
        }
        return importedBeans;
    }

    protected <T extends BaseBean> T[] setImportedBeans(String fkName, B bean, T[] importedBeans) throws RuntimeDaoException {
        if (null != importedBeans) {
            this.setImportedBeans(fkName, bean, Arrays.asList(importedBeans));
        }
        return importedBeans;
    }

    protected int deleteImportedBeans(String fkName, B bean) throws RuntimeDaoException {
        if (bean == null) {
            return 0;
        }
        ForeignKeyMetaData foreignkey = this.metaData.getImportedKey(fkName);
        RowMetaData ownerTable = RowMetaData.getMetaData((String)foreignkey.ownerTable);
        BaseTableManager<BaseBean> foreignManager = Managers.baseManagerOf(foreignkey.ownerTable);
        BaseBean tmpl = foreignManager.createBean().copy(bean, (Map)ownerTable.foreignKeyIdMapOf(fkName));
        return foreignManager.deleteUsingTemplate(tmpl);
    }

    protected int deleteImportedBeans(String fkName, Map<Integer, Object> idValueMap) throws RuntimeDaoException {
        BaseBean bean = this.createBean().copy(idValueMap);
        return this.deleteImportedBeans(fkName, (B)bean);
    }

    protected int deleteImportedBeans(String fkName, Object ... keys) throws RuntimeDaoException {
        return this.deleteImportedBeans(fkName, this.createBean(keys));
    }

    private Map<Integer, Object> makeIndexValueMap(String indexName, Object ... indexValues) {
        IndexMetaData indexMetaData = (IndexMetaData)this.metaData.indices.get(indexName);
        Preconditions.checkArgument((null != indexMetaData ? 1 : 0) != 0, (String)"INVALID index name %s", (Object)indexName);
        Preconditions.checkArgument((null != indexValues && indexValues.length == indexMetaData.columns.size() ? 1 : 0) != 0, (Object)"INVALID index value");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < indexValues.length; ++i) {
            Object value = indexValues[i];
            if (null == value) continue;
            String column = (String)indexMetaData.columns.get(i);
            Class columnType = this.metaData.columnTypeOf(column);
            Preconditions.checkArgument((boolean)columnType.isInstance(value), (String)"INVALID value type %s for %s,%s required", value.getClass(), (Object)column, (Object)columnType);
            builder.put((Object)this.metaData.columnIDOf(column), value);
        }
        return builder.build();
    }

    protected B[] loadByIndex(String indexName, Object ... keys) throws RuntimeDaoException {
        return this.loadByIndexAsList(indexName, keys).toArray((BaseBean[])Array.newInstance(this.metaData.beanType, 0));
    }

    protected List<B> loadByIndexAsList(String indexName, Object ... indexValues) throws RuntimeDaoException {
        Map<Integer, Object> map = this.makeIndexValueMap(indexName, indexValues);
        return this.loadUsingTemplateAsList(map);
    }

    protected final B loadUniqueByIndex(String indexName, Object ... indexValues) throws RuntimeDaoException {
        return this.doLoadUniqueByIndex(indexName, indexValues);
    }

    protected B doLoadUniqueByIndex(String indexName, Object ... indexValues) throws RuntimeDaoException {
        Map<Integer, Object> keys = this.makeIndexValueMap(indexName, indexValues);
        BaseBean bean = this.createBean().copy(keys);
        return (B)this.loadUniqueUsingTemplate(bean);
    }

    protected final B loadUniqueByIndexChecked(String indexName, Object ... indexValues) throws ObjectRetrievalException {
        if (BaseTableManager.hasNull(indexValues)) {
            throw new ObjectRetrievalException((Throwable)new NullPointerException("index keys must not be null"));
        }
        return this.doLoadUniqueByIndexChecked(indexName, indexValues);
    }

    protected B doLoadUniqueByIndexChecked(String indexName, Object ... indexValues) throws ObjectRetrievalException {
        Map<Integer, Object> keys = this.makeIndexValueMap(indexName, indexValues);
        BaseBean bean = this.createBean().copy(keys);
        return (B)this.loadUniqueUsingTemplateChecked(bean);
    }

    protected int deleteByIndex(String indexName, Object ... indexValues) throws RuntimeDaoException {
        Map<Integer, Object> map = this.makeIndexValueMap(indexName, indexValues);
        return this.deleteUsingTemplate((B)map);
    }

    protected <T extends BaseBean> List<B> loadViaJunctionAsList(String junctionTable, T linked, int startRow, int numRows) {
        BaseTableManager manager = Managers.baseManagerOf(junctionTable);
        return manager.loadViaJunctionTableAsList(this.metaData.beanType, linked, startRow, numRows);
    }

    protected <T extends BaseBean> List<B> loadViaJunctionAsList(String junctionTable, T linked) {
        return this.loadViaJunctionAsList(junctionTable, linked, 1, -1);
    }

    private List<B> loadUsingTemplateAsList(Map<Integer, Object> keys) {
        BaseBean bean = this.createBean().copy(keys);
        return this.loadUsingTemplateAsList(bean);
    }

    private int deleteUsingTemplate(Map<Integer, Object> keys) {
        BaseBean bean = this.createBean().copy(keys);
        return this.deleteUsingTemplate(bean);
    }

    protected <T> List<B> loadByIndexForIndices(String indexName, Collection<T> indexs) {
        IndexMetaData indexMetaData = (IndexMetaData)this.metaData.indices.get(indexName);
        Preconditions.checkArgument((null != indexMetaData ? 1 : 0) != 0, (String)"INVALID index name %s", (Object)indexName);
        Preconditions.checkArgument((1 == indexMetaData.columns.size() ? 1 : 0) != 0, (Object)"column count of  index must be 1");
        Preconditions.checkArgument((boolean)indexMetaData.unique, (Object)"index must be unique");
        if (null == indexs) {
            return Collections.emptyList();
        }
        ArrayList<B> list = new ArrayList<B>(indexs.size());
        for (T key : indexs) {
            list.add(this.loadUniqueByIndex(indexName, key));
        }
        return list;
    }

    protected <T> List<B> loadByIndexForIndices(String indexName, T ... indexs) {
        if (indexs == null || indexs.length == 0) {
            return Collections.emptyList();
        }
        return this.loadByIndexForIndices(indexName, (Collection<T>)Arrays.asList(indexs));
    }

    protected <T> int deleteByIndexForIndices(String indexName, Collection<T> indexs) {
        IndexMetaData indexMetaData = (IndexMetaData)this.metaData.indices.get(indexName);
        Preconditions.checkArgument((null != indexMetaData ? 1 : 0) != 0, (String)"INVALID index name %s", (Object)indexName);
        Preconditions.checkArgument((1 == indexMetaData.columns.size() ? 1 : 0) != 0, (Object)"column count of  index must be 1");
        if (null == indexs) {
            return 0;
        }
        int count = 0;
        for (T key : indexs) {
            if (key == null) continue;
            count += this.deleteByIndex(indexName, key);
        }
        return count;
    }

    protected <T> int deleteByIndexForIndices(String indexName, T ... indexs) {
        if (indexs == null || indexs.length == 0) {
            return 0;
        }
        return this.deleteByIndexForIndices(indexName, (Collection<T>)Arrays.asList(indexs));
    }

    private boolean checkPkValid(B bean) {
        if (this.metaData.primaryKeyNames.length == 0) {
            return false;
        }
        for (String name : this.metaData.primaryKeyNames) {
            if (bean.isInitialized(name) && null != bean.getValue(name)) continue;
            return false;
        }
        return true;
    }

    public int deleteUsingTemplate(B bean) {
        if (bean == null || !bean.beModified()) {
            return 0;
        }
        if (this.checkPkValid(bean)) {
            return this.deleteByPrimaryKey(bean);
        }
        if (!this.getListenerContainer().isEmpty()) {
            DeleteBeanAction action = new DeleteBeanAction();
            this.loadUsingTemplate(bean, action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        StringBuilder builder = new StringBuilder("DELETE FROM " + this.metaData.tablename + " ");
        StringBuilder sqlWhere = new StringBuilder("");
        try {
            this.fillWhere(sqlWhere, bean, 0);
            builder.append(" WHERE ").append((CharSequence)sqlWhere);
            c = this.getConnection();
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, "deleteUsingTemplate", 1003, 1007);
            this.fillPreparedStatement(ps, bean, 0, false);
            int n = ps.executeUpdate();
            this.getManager().close(ps);
            this.freeConnection(c);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
    }

    public int deleteByWhere(String where) {
        if (!this.getListenerContainer().isEmpty()) {
            DeleteBeanAction action = new DeleteBeanAction();
            this.loadByWhere(where, action);
            return action.getCount();
        }
        Connection c = null;
        PreparedStatement ps = null;
        try {
            c = this.getConnection();
            StringBuilder builder = new StringBuilder("DELETE FROM " + this.metaData.tablename + " " + where);
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), true, debug, "deleteByWhere");
            int n = ps.executeUpdate();
            this.getManager().close(ps);
            this.freeConnection(c);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c);
                throw throwable;
            }
        }
    }

    private void setPreparedStatement(PreparedStatement ps, int pos, Object value, int columnId) throws SQLException {
        Manager.fillPreparedStatement(ps, pos, value, this.metaData.sqlTypes[columnId]);
    }

    private void setPreparedStatementWithBean(PreparedStatement ps, int pos, B bean, int columnId) throws SQLException {
        this.setPreparedStatement(ps, pos, bean.getValue(columnId), columnId);
    }

    private B save(B bean, Map<String, BaseBean> referenceBeans, Map<String, Collection<BaseBean>> importedBeans) throws RuntimeDaoException {
        if (null == bean) {
            return null;
        }
        referenceBeans = (Map)MoreObjects.firstNonNull(referenceBeans, Collections.emptyMap());
        importedBeans = (Map)MoreObjects.firstNonNull(importedBeans, Collections.emptyMap());
        for (Map.Entry entry : referenceBeans.entrySet()) {
            BaseBean beanToSet = (BaseBean)entry.getValue();
            if (beanToSet == null) continue;
            this.setReferencedBean((String)entry.getKey(), bean, beanToSet);
        }
        bean = this.save((Collection)bean);
        for (Map.Entry entry : importedBeans.entrySet()) {
            String ikName = (String)entry.getKey();
            Collection importeds = (Collection)entry.getValue();
            if (null == importeds) continue;
            this.setImportedBeans(ikName, bean, importeds);
            TableManager impManager = Managers.managerOf(this.metaData.getImportedKey((String)ikName).ownerTable);
            impManager.save(importeds);
        }
        return bean;
    }

    protected B saveFully(B bean, Object[] args) {
        HashMap referenced = Maps.newHashMap();
        int index = 0;
        for (String key : this.metaData.foreignKeys.keySet()) {
            referenced.put(key, (BaseBean)args[index++]);
        }
        HashMap imported = Maps.newHashMap();
        for (ForeignKeyMetaData key : this.metaData.getImportedKeys()) {
            Object obj;
            if ((obj = args[index++]) == null) {
                imported.put(key.name, null);
                continue;
            }
            if (obj.getClass().isArray()) {
                Preconditions.checkArgument((boolean)BaseBean.class.isAssignableFrom(obj.getClass().getComponentType()), (String)"INVALID COMPONENT TYPE FOR %s", (Object)key.name);
                imported.put(key.name, Arrays.asList((BaseBean[])obj));
                continue;
            }
            if (obj instanceof Collection) {
                imported.put(key.name, (Collection)obj);
                continue;
            }
            throw new IllegalArgumentException(SimpleLog.logString((String)"INVALID TYPE %s FOR %s", (Object[])new Object[]{obj.getClass(), key.name}));
        }
        return this.save(bean, referenced, imported);
    }

    protected B saveFullyAsTransaction(B bean, Object[] args) {
        return (B)((BaseBean)this.runAsTransaction(new Callable<B>((BaseBean)bean, args){
            final /* synthetic */ BaseBean val$bean;
            final /* synthetic */ Object[] val$args;
            {
                this.val$bean = baseBean;
                this.val$args = objectArray;
            }

            @Override
            public B call() throws Exception {
                return BaseTableManager.this.saveFully(this.val$bean, this.val$args);
            }
        }));
    }

    public int countWhere(String where) {
        return this.rowCountWhere(where, new Object[0]);
    }

    public int rowCountWhere(String where, Object ... argList) {
        String col = 1 == this.metaData.primaryKeyCount ? this.metaData.primaryKeyNames[0] : "1";
        String sql = new StringBuffer("SELECT * FROM " + this.metaData.tablename + " ").append((String)MoreObjects.firstNonNull((Object)where, (Object)"")).toString();
        String countSql = ParserSupport.countSql(sql, col);
        return this.runSqlForValue(Long.class, countSql, argList).intValue();
    }

    public int countUsingTemplate(B bean, int searchType) {
        Connection c = null;
        PreparedStatement ps = null;
        String col = 1 == this.metaData.primaryKeyCount ? this.metaData.primaryKeyNames[0] : "1";
        StringBuilder builder = new StringBuilder("SELECT COUNT(" + col + ") AS MCOUNT FROM " + this.metaData.tablename);
        StringBuilder sqlWhere = new StringBuilder("");
        try {
            if (this.fillWhere(sqlWhere, bean, 0) > 0) {
                builder.append(" WHERE ").append((CharSequence)sqlWhere);
            } else {
                SimpleLog.log((boolean)debug, (String)"The bean to look is not initialized... counting all...", (Object[])new Object[0]);
            }
            c = this.getConnection();
            ps = this.getManager().getStatementCache().prepareStatement(c, builder.toString(), false, debug, "countUsingTemplate", 1003, 1007);
            this.fillPreparedStatement(ps, bean, searchType, false);
            int n = this.getManager().runPreparedStatementForValue(Number.class, ps).intValue();
            this.getManager().close(ps);
            this.freeConnection(c);
            builder = null;
            sqlWhere = null;
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c);
                builder = null;
                sqlWhere = null;
                throw throwable;
            }
        }
    }

    private int fillWhere(StringBuilder sqlWhere, B bean, int searchType) {
        if (bean == null) {
            return 0;
        }
        int dirtyCount = 0;
        String sqlEqualsOperation = searchType == 0 ? "=" : " like ";
        ImmutableList fields = this.metaData.columnNames;
        for (int i = 0; i < fields.size(); ++i) {
            if (!bean.isModified(i)) continue;
            ++dirtyCount;
            String col = this.metaData.columnNameOf(i);
            if (bean.getValue(i) == null) {
                sqlWhere.append(sqlWhere.length() == 0 ? " " : " AND ").append(col).append(" IS NULL");
                continue;
            }
            if (this.metaData.columnTypeOf(i) == String.class) {
                sqlWhere.append(sqlWhere.length() == 0 ? " " : " AND ").append(col).append(" ").append(sqlEqualsOperation).append("?");
                continue;
            }
            sqlWhere.append(sqlWhere.length() == 0 ? " " : " AND ").append(col).append(" = ?");
        }
        return dirtyCount;
    }

    private int fillPreparedStatement(PreparedStatement ps, B bean, int searchType, boolean fillNull) throws DaoException {
        return Manager.fillPreparedStatement(this.metaData, ps, bean, searchType, fillNull);
    }

    public <L extends BaseBean, R extends BaseBean> List<R> loadViaJunctionTableAsList(Class<R> rightType, L left, int startRow, int numRows) {
        List list;
        BaseTableManager rightManager;
        PreparedStatement ps;
        Connection c2;
        block7: {
            Preconditions.checkState((!this.metaData.getJunctionTablePkMap().isEmpty() ? 1 : 0) != 0, (String)"%s is not junction table", (Object)this.metaData.tablename);
            Preconditions.checkArgument((null != left ? 1 : 0) != 0, (Object)"left is null");
            Preconditions.checkArgument((null != rightType ? 1 : 0) != 0, (Object)"rightType is null");
            RowMetaData leftMetaData = RowMetaData.getMetaData((String)left.tableName());
            RowMetaData rightMetaData = RowMetaData.getMetaData(rightType);
            Preconditions.checkArgument((!leftMetaData.equals((Object)rightMetaData) ? 1 : 0) != 0, (Object)"same metadata  FOR left AND right type");
            Preconditions.checkArgument((boolean)this.metaData.isLinkedTable(leftMetaData.tablename), (String)"INVALID left type %s", left.getClass());
            Preconditions.checkArgument((boolean)this.metaData.isLinkedTable(rightMetaData.tablename), (String)"INVALID right type %s", rightType);
            Map leftFields = this.metaData.junctionMapOf(leftMetaData.tablename);
            Map rightFields = this.metaData.junctionMapOf(rightMetaData.tablename);
            if (Iterables.tryFind(leftFields.values(), c -> null == left.getValue(c)).isPresent()) {
                return Collections.emptyList();
            }
            c2 = null;
            ps = null;
            String sql = " SELECT " + rightMetaData.columnFullFields + " FROM " + this.metaData.tablename + ", " + rightMetaData.tablename + " WHERE " + Joiner.on((String)" AND ").join(Iterables.transform(leftFields.keySet(), f -> f + "=?")) + " AND " + Joiner.on((String)" AND ").join(Iterables.transform(rightFields.entrySet(), input -> null == input ? "" : (String)input.getKey() + "=" + (String)input.getValue()));
            c2 = this.getConnection();
            PageQueryImplType pageQueryImplType = this.getManager().getPageQueryImplType();
            String wrapped = pageQueryImplType.wrap(sql, startRow, numRows);
            sql = (String)MoreObjects.firstNonNull((Object)wrapped, (Object)sql);
            ps = this.getManager().getStatementCache().prepareStatement(c2, sql, false, debug, "loadViaJunctionTableAsList", 1003, 1007);
            int pos = 1;
            for (String key : leftFields.keySet()) {
                String fullName = (String)leftFields.get(key);
                int columnId = leftMetaData.columnIDOf(fullName);
                Manager.fillPreparedStatement(ps, pos++, left.getValue(columnId), leftMetaData.sqlTypeOf(columnId));
            }
            rightManager = Managers.baseManagerOf(rightMetaData.tablename);
            if (null == wrapped) break block7;
            list = rightManager.loadByPreparedStatementAsList(ps, null, 1, -1);
            this.getManager().close(ps);
            this.freeConnection(c2);
            return list;
        }
        try {
            list = rightManager.loadByPreparedStatementAsList(ps, null, startRow, numRows);
            this.getManager().close(ps);
            this.freeConnection(c2);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DaoException(e.getMessage(), (Throwable)e));
            }
            catch (Throwable throwable) {
                this.getManager().close(ps);
                this.freeConnection(c2);
                throw throwable;
            }
        }
    }

    private <L extends BaseBean, R extends BaseBean> B makeJunctionBean(L left, R right) {
        ImmutableMap map = this.metaData.getJunctionTablePkMap();
        Preconditions.checkState((!map.isEmpty() ? 1 : 0) != 0, (String)"%s is not junction table", (Object)this.metaData.tablename);
        Object[] primaryValues = new Object[this.metaData.primaryKeyCount];
        for (int i = 0; i < primaryValues.length; ++i) {
            String pk = this.metaData.columnNameOf(i);
            Object[] data = (Object[])map.get(pk);
            Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"PRIMARY KEY %s NOT DEFINED", (Object)pk);
            String linkedTableName = (String)data[0];
            int linkedColumnId = (Integer)data[1];
            if (left.tableName().equals(linkedTableName)) {
                primaryValues[i] = left.getValueChecked(linkedColumnId);
                continue;
            }
            if (right.tableName().equals(linkedTableName)) {
                primaryValues[i] = right.getValueChecked(linkedColumnId);
                continue;
            }
            throw new IllegalArgumentException(String.format("%s NOT linked table  %s", linkedTableName, this.metaData.tablename));
        }
        return this.createBean(primaryValues);
    }

    private <L extends BaseBean, R extends BaseBean> void addJunction(L left, R right) {
        if (BaseTableManager.hasNullPk(left) || BaseTableManager.hasNullPk(right)) {
            return;
        }
        B junction = this.makeJunctionBean(left, right);
        if (!this.existsByPrimaryKey(junction)) {
            this.save((Collection)junction);
        }
    }

    private <L extends BaseBean, R extends BaseBean> int deleteJunction(L left, R right) {
        if (BaseTableManager.hasNullPk(left) || BaseTableManager.hasNullPk(right)) {
            return 0;
        }
        B junction = this.makeJunctionBean(left, right);
        return this.delete(junction);
    }

    private <L extends BaseBean, R extends BaseBean> void addJunction(L left, R ... rights) {
        if (null != rights) {
            for (R linked : rights) {
                this.addJunction(left, linked);
            }
        }
    }

    private <L extends BaseBean, R extends BaseBean> void addJunction(L left, Collection<R> rights) {
        if (null != rights) {
            for (BaseBean linked : rights) {
                this.addJunction(left, linked);
            }
        }
    }

    private <L extends BaseBean, R extends BaseBean> int deleteJunction(L left, R ... rights) {
        if (null != rights) {
            return this.deleteJunction(left, (Collection<R>)Arrays.asList(rights));
        }
        return 0;
    }

    private <L extends BaseBean, R extends BaseBean> int deleteJunction(L left, Collection<R> rights) {
        int count = 0;
        if (null != rights) {
            for (BaseBean right : rights) {
                count += this.deleteJunction(left, right);
            }
        }
        return count;
    }

    protected <R extends BaseBean> void addJunction(String junction, B bean, R linked) {
        super.addJunction((BaseBean)bean, linked);
    }

    protected <R extends BaseBean> void addJunction(String junction, B bean, R ... linkedBeans) {
        super.addJunction((BaseBean)bean, (R)linkedBeans);
    }

    protected <R extends BaseBean> void addJunction(String junction, B bean, Collection<R> linkedBeans) {
        super.addJunction((BaseBean)bean, linkedBeans);
    }

    protected <R extends BaseBean> int deleteJunction(String junction, B bean, R linked) {
        return super.deleteJunction((BaseBean)bean, linked);
    }

    protected <R extends BaseBean> int deleteJunction(String junction, B bean, R ... linkedBeans) {
        return super.deleteJunction((BaseBean)bean, (R)linkedBeans);
    }

    protected <R extends BaseBean> int deleteJunction(String junction, B bean, Collection<R> linkedBeans) {
        return super.deleteJunction((BaseBean)bean, linkedBeans);
    }

    protected int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) throws DaoException {
        int count = 0;
        try {
            if (0 != numRows) {
                Preconditions.checkArgument((startRow >= 1 ? 1 : 0) != 0, (Object)"invalid argument:startRow (must >=1)");
                Preconditions.checkArgument((null != action && null != rs ? 1 : 0) != 0, (Object)"invalid argument:action OR rs (must not be null)");
                while (startRow > 1 && rs.next()) {
                    --startRow;
                }
                if (fieldList == null) {
                    if (numRows < 0) {
                        while (rs.next()) {
                            action.call(this.decodeRow(rs));
                            ++count;
                        }
                    } else {
                        while (rs.next() && count < numRows) {
                            action.call(this.decodeRow(rs));
                            ++count;
                        }
                    }
                } else if (numRows < 0) {
                    while (rs.next()) {
                        action.call(this.decodeRow(rs, fieldList));
                        ++count;
                    }
                } else {
                    while (rs.next() && count < numRows) {
                        action.call(this.decodeRow(rs, fieldList));
                        ++count;
                    }
                }
            }
            return count;
        }
        catch (QueueTimeoutException e) {
            SimpleLog.log((String)(((Object)((Object)e)).getClass().getSimpleName() + ":" + e.getMessage()), (Object[])new Object[0]);
            return count;
        }
        catch (DaoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected <T> T getColumnValue(ResultSet resultSet, int columnId) throws SQLException {
        return this.getManager().getObject(resultSet, columnId + 1, this.metaData.columnTypeOf(columnId));
    }

    protected void setColumnValue(B bean, int columnId, Object value) {
        if (value instanceof byte[] && ByteBuffer.class.equals((Object)this.metaData.columnTypeOf(columnId))) {
            value = ByteBuffer.wrap((byte[])value);
        }
        bean.setValue(columnId, value);
    }

    private B decodeRow(ResultSet rs) throws DaoException {
        B bean = this.createBean();
        try {
            for (int i = 0; i < this.metaData.columnNames.size(); ++i) {
                this.setColumnValue(bean, i, this.getColumnValue(rs, i));
            }
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        bean.setNew(false);
        bean.resetIsModified();
        return bean;
    }

    private B decodeRow(ResultSet rs, int[] fieldList) throws DaoException {
        fieldList = (int[])MoreObjects.firstNonNull((Object)fieldList, (Object)this.metaData.defaultColumnIdList);
        B bean = this.createBean();
        try {
            for (int i = 0; i < fieldList.length; ++i) {
                if (fieldList[i] < 0 || fieldList[i] >= this.metaData.columnNames.size()) {
                    throw new DaoException("Unknown field id " + fieldList[i]);
                }
                int columnId = fieldList[i];
                this.setColumnValue(bean, columnId, this.getColumnValue(rs, columnId));
            }
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        bean.setNew(false);
        bean.resetIsModified();
        return bean;
    }

    protected List<B> loadByPreparedStatementAsList(PreparedStatement ps, int[] fieldList, int startRow, int numRows) throws DaoException {
        ListAction action = new ListAction();
        this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
        return action.getList();
    }

    private int loadByPreparedStatement(PreparedStatement ps, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) throws DaoException {
        ResultSet rs = null;
        try {
            ps.setFetchSize(1000);
            rs = ps.executeQuery();
            int n = this.actionOnResultSet(rs, fieldList, startRow, numRows, action);
            return n;
        }
        catch (DaoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            this.getManager().close(rs);
        }
    }

    public void registerListener(TableListener<B> listener) {
        this.getListenerContainer().add(listener);
        if (debug) {
            SimpleLog.log((String)"REGISTER TABLE LISTENER {}", (Object[])new Object[]{listener});
        }
    }

    public void unregisterListener(TableListener<B> listener) {
        this.getListenerContainer().remove(listener);
        if (debug) {
            SimpleLog.log((String)"UNREGISTER TABLE LISTENER {}", (Object[])new Object[]{listener});
        }
    }

    public void bindForeignKeyListenerForDeleteRule() {
        for (Map.Entry<String, TableListener<BaseBean>> entry : this.getForeignKeyDeleteListeners().entrySet()) {
            TableManager manager = Managers.managerOf(((ForeignKeyMetaData)this.metaData.foreignKeys.get((Object)entry.getKey())).foreignTable);
            manager.registerListener(entry.getValue());
        }
    }

    public void unbindForeignKeyListenerForDeleteRule() {
        for (Map.Entry<String, TableListener<BaseBean>> entry : this.getForeignKeyDeleteListeners().entrySet()) {
            TableManager manager = Managers.managerOf(((ForeignKeyMetaData)this.metaData.foreignKeys.get((Object)entry.getKey())).foreignTable);
            manager.unregisterListener(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manager getManager() {
        if (null == this.manager) {
            BaseTableManager baseTableManager = this;
            synchronized (baseTableManager) {
                if (null == this.manager) {
                    Manager m = Managers.managerInstanceOfAlias(this.metaData.alias);
                    this.manager = m == null ? Manager.getInstance() : m;
                }
            }
        }
        return this.manager;
    }

    protected void freeConnection(Connection c) {
        this.getManager().releaseConnection(c);
    }

    protected Connection getConnection() throws DaoException {
        try {
            return this.getManager().getConnection();
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private int loadBySqlForAction(String sql, Object[] argList, int[] fieldList, int startRow, int numRows, TableManager.Action<B> action) {
        int n;
        PreparedStatement ps = null;
        Connection c = null;
        try {
            c = this.getConnection();
            AtomicLong count = new AtomicLong(-1L);
            String wrapped = this.getManager().rebuildSelectSql(c, sql, startRow, numRows, count, debug);
            if (0L == count.get()) {
                SimpleLog.log((boolean)debug, (String)"count 0,SKIP execute sql", (Object[])new Object[0]);
                int n2 = 0;
                return n2;
            }
            sql = (String)MoreObjects.firstNonNull((Object)wrapped, (Object)sql);
            ps = this.getManager().getStatementCache().prepareStatement(c, sql, true, debug, "loadBySqlForAction", 1003, 1007);
            Manager.fillPrepareStatement(ps, argList);
            if (null != wrapped) {
                int n3 = this.loadByPreparedStatement(ps, fieldList, 1, -1, action);
                this.getManager().close(ps);
                this.freeConnection(c);
                return n3;
            }
            n = this.loadByPreparedStatement(ps, fieldList, startRow, numRows, action);
            this.getManager().close(ps);
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
        }
        finally {
            this.getManager().close(ps);
            this.freeConnection(c);
        }
        this.freeConnection(c);
        return n;
    }

    public List<BaseBean> runSqlAsList(String sql, Object ... argList) throws RuntimeDaoException {
        return this.getManager().runSqlAsList(sql, argList);
    }

    public List<Map<String, Object>> runSqlForMap(Map<String, Class<?>> targetTypes, String sql, Object ... argList) throws RuntimeDaoException {
        return this.getManager().runSqlForMap(targetTypes, sql, argList);
    }

    public <T> List<T> runSqlAsList(Class<T> targetType, String sql, Object ... argList) throws RuntimeDaoException {
        return this.getManager().runSqlAsList(targetType, sql, argList);
    }

    public <T> T runSqlForValue(Class<T> targetType, String sql, Object ... argList) throws RuntimeDaoException {
        return this.getManager().runSqlForValue(targetType, sql, argList);
    }

    public boolean runSql(String sql, Object[] argList) {
        return this.getManager().runSql(sql, argList);
    }

    public int runSql(String sql) {
        return this.getManager().runSql(sql);
    }

    public <T> T runAsTransaction(Callable<T> fun) {
        return this.getManager().runAsTransaction(fun);
    }

    public void runAsTransaction(Runnable fun) {
        this.getManager().runAsTransaction(fun);
    }

    public <T> T runWithNoPage(Callable<T> fun) throws RuntimeDaoException {
        return this.getManager().runWithNoPage(fun);
    }

    public void runWithNoPage(Runnable fun) throws RuntimeDaoException {
        this.getManager().runWithNoPage(fun);
    }

    public long rowCountOf(String sql) throws RuntimeDaoException {
        return this.getManager().rowCountOf(sql);
    }

    protected <T> List<T> toPrimaryKeyList(Class<T> type, B ... beans) {
        if (null == beans || beans.length == 0) {
            return Collections.emptyList();
        }
        return this.toPrimaryKeyList(type, (Collection<B>)Arrays.asList(beans));
    }

    protected <T> List<T> toPrimaryKeyList(Class<T> type, Collection<B> beans) {
        if (this.metaData.primaryKeyNames.length != 1) {
            throw new UnsupportedOperationException();
        }
        if (null == beans) {
            return Collections.emptyList();
        }
        int pkId = this.metaData.primaryKeyIds[0];
        Preconditions.checkArgument((boolean)this.metaData.columnTypeOf(pkId).equals(type), (Object)("INVALID primary key type: " + type));
        return Lists.newArrayList((Iterable)Iterables.transform(beans, input -> input == null ? null : input.getValue(pkId)));
    }

    private Object[] toPkValues(B bean, int[] selfFkIds) {
        Preconditions.checkArgument((selfFkIds.length == this.metaData.primaryKeyNames.length ? 1 : 0) != 0, (Object)"MISMATCH SIZE of primary keys");
        return bean.asValueArray(selfFkIds);
    }

    protected List<B> listOfSelfRef(String fkName, Object ... primaryKeys) throws RuntimeDaoException {
        ArrayList<B> list = new ArrayList<B>();
        int[] selfFks = this.metaData.foreignKeyIdArrayOf(fkName);
        B ref = this.loadByPrimaryKey(primaryKeys);
        while (null != ref) {
            list.add(ref);
            Object[] refPk = ref.primaryValues();
            Object[] refSelf = this.toPkValues(ref, selfFks);
            if (Arrays.equals(refPk, refSelf) || list.size() > 1 && Arrays.equals(refPk, primaryKeys)) break;
            ref = this.loadByPrimaryKey(this.toPkValues(ref, selfFks));
        }
        Collections.reverse(list);
        return list;
    }

    protected List<B> listOfSelfRef(String fkName, B bean) throws RuntimeDaoException {
        return bean == null ? Collections.emptyList() : this.listOfSelfRef(fkName, (B)bean.primaryValues());
    }

    protected int levelOfSelfRef(String fkName, Object ... primaryKeys) throws RuntimeDaoException {
        int count = 0;
        int[] selfFks = this.metaData.foreignKeyIdArrayOf(fkName);
        B ref = this.loadByPrimaryKey(primaryKeys);
        while (null != ref) {
            Object[] refSelf;
            Object[] refPk = ref.primaryValues();
            if (Arrays.equals(refPk, refSelf = this.toPkValues(ref, selfFks)) || count > 0 && Arrays.equals(refPk, primaryKeys)) {
                return -1;
            }
            ++count;
            ref = this.loadByPrimaryKey(this.toPkValues(ref, selfFks));
        }
        return count;
    }

    protected int levelOfSelfRef(String fkName, B bean) throws RuntimeDaoException {
        return bean == null ? 0 : this.levelOfSelfRef(fkName, bean.primaryValues());
    }

    protected boolean isCycleOfSelfRef(String fkName, Object ... primaryKeys) throws RuntimeDaoException {
        return this.levelOfSelfRef(fkName, primaryKeys) < 0;
    }

    protected boolean isCycleOfSelfRef(String fkName, B bean) throws RuntimeDaoException {
        return bean == null ? false : this.levelOfSelfRef(fkName, bean.primaryValues()) < 0;
    }

    protected <T> T checkCycleOfSelfRef(String fkName, T primaryKey) throws IllegalStateException, RuntimeDaoException {
        if (this.isCycleOfSelfRef(fkName, new Object[]{primaryKey})) {
            throw new IllegalStateException("cycle on foreign key: " + fkName);
        }
        return primaryKey;
    }

    protected B checkCycleOfSelfRef(String fkName, B bean) throws IllegalStateException, RuntimeDaoException {
        if (this.isCycleOfSelfRef(fkName, bean)) {
            throw new IllegalStateException("cycle on foreign key: " + fkName);
        }
        return bean;
    }

    protected B topOfSelfRef(String fkName, Object ... primaryKeys) throws IllegalArgumentException, IllegalStateException, ObjectRetrievalException, RuntimeDaoException {
        Object[] refSelf;
        Preconditions.checkArgument((!BaseTableManager.hasNull(primaryKeys) ? 1 : 0) != 0, (Object)"primaryKeys has null element");
        int[] selfFks = this.metaData.foreignKeyIdArrayOf(fkName);
        B ref = this.loadByPrimaryKeyChecked(primaryKeys);
        int count = 0;
        while (!BaseTableManager.hasNull(refSelf = this.toPkValues(ref, selfFks))) {
            Object[] refPk = ref.primaryValues();
            Preconditions.checkState((!Arrays.equals(refPk, refSelf) && (++count <= 1 || !Arrays.equals(refPk, primaryKeys)) ? 1 : 0) != 0, (Object)("cycle on fk: " + fkName));
            ref = this.loadByPrimaryKeyChecked(refSelf);
        }
        return ref;
    }

    protected B topOfSelfRef(String fkName, B bean) throws IllegalArgumentException, IllegalStateException, ObjectRetrievalException, RuntimeDaoException {
        return (B)this.topOfSelfRef(fkName, (B)((BaseBean)Preconditions.checkNotNull(bean, (Object)"bean is null")).primaryValues());
    }

    private LinkedHashSet<B> doListOfChild(String fkName, B bean, LinkedHashSet<B> set) {
        if (null != (bean = this.loadByPrimaryKey(bean))) {
            Preconditions.checkState((!set.contains(bean) ? 1 : 0) != 0, (Object)("cycle on foreign key: " + fkName));
            set.add(bean);
            List<B> childs = this.loadByForeignKeyAsList(fkName, (BaseBean)bean, 1, -1);
            for (BaseBean c : childs) {
                this.doListOfChild(fkName, c, set);
            }
        }
        return set;
    }

    protected List<B> childListOfSelfRef(String fkName, B bean) throws IllegalStateException, RuntimeDaoException {
        return new ArrayList<B>(this.doListOfChild(fkName, bean, new LinkedHashSet()));
    }

    protected List<B> childListOfSelfRef(String fkName, Object ... primaryKeys) throws IllegalStateException, RuntimeDaoException {
        return this.childListOfSelfRef(fkName, this.createBean(primaryKeys));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metaData == null ? 0 : this.metaData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTableManager other = (BaseTableManager)obj;
        return !(this.metaData == null ? other.metaData != null : !this.metaData.equals((Object)other.metaData));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [metaData=");
        builder.append(this.metaData);
        builder.append("]");
        return builder.toString();
    }

    static void setDebug(boolean debug) {
        BaseTableManager.debug = debug;
    }

    public static void setWhereCheckFlag(int whereCheckFlag) {
    }

    static boolean isDebug() {
        return debug;
    }

    class DeleteBeanAction
    implements TableManager.Action<B> {
        private final AtomicInteger count = new AtomicInteger(0);

        public void call(B bean) {
            BaseTableManager.this.delete(bean);
            this.count.incrementAndGet();
        }

        public int getCount() {
            return this.count.get();
        }
    }

    public static enum Event {
        INSERT,
        UPDATE,
        DELETE;

    }

    protected class DeleteRuleListener<F extends BaseBean>
    extends BaseForeignKeyListener<F, B> {
        protected final String fkName;
        private final ForeignKeyMetaData.ForeignKeyRule deleteRule;
        private final int[] foreignKeyIds;

        DeleteRuleListener(String fkName) {
            Preconditions.checkArgument((boolean)BaseTableManager.this.metaData.foreignKeys.containsKey(fkName), (String)"INVALID foreign key name %s", (Object)fkName);
            this.fkName = fkName;
            this.deleteRule = ((ForeignKeyMetaData)BaseTableManager.this.metaData.foreignKeys.get((Object)fkName)).deleteRule;
            this.foreignKeyIds = BaseTableManager.this.metaData.foreignKeyIdArrayOf(fkName);
        }

        @Override
        protected List<B> getImportedBeans(F bean) {
            return BaseTableManager.this.getListenerContainer().isEmpty() ? Collections.emptyList() : BaseTableManager.this.loadByForeignKeyAsList(this.fkName, bean, 1, -1);
        }

        @Override
        protected void onRemove(List<B> affectedBeans) throws DaoException {
            switch (this.deleteRule) {
                case SET_NULL: {
                    for (BaseBean bean : affectedBeans) {
                        BaseRow updated = ((BaseRow)bean).clone();
                        for (int i = 0; i < this.foreignKeyIds.length; ++i) {
                            updated.setValue(this.foreignKeyIds[i], null);
                        }
                        this.fire(Event.UPDATE, updated);
                    }
                    break;
                }
                case SET_DEFAULT: {
                    Object tmpl = BaseTableManager.this.createBean();
                    for (BaseBean bean : affectedBeans) {
                        BaseRow updated = ((BaseRow)bean).clone();
                        for (int i = 0; i < this.foreignKeyIds.length; ++i) {
                            updated.setValue(this.foreignKeyIds[i], tmpl.getValue(this.foreignKeyIds[i]));
                        }
                        this.fire(Event.UPDATE, updated);
                    }
                    break;
                }
                default: {
                    if (this.deleteRule.isNoAction()) break;
                    Event event = Event.valueOf(this.deleteRule.eventOfDeleteRule);
                    for (BaseBean bean : affectedBeans) {
                        this.fire(event, bean);
                    }
                }
            }
        }

        private void fire(Event event, B bean) throws RuntimeDaoException {
            ListenerContainer container = BaseTableManager.this.getListenerContainer();
            switch (event) {
                case UPDATE: {
                    container.beforeUpdate(bean);
                    container.afterUpdate(bean);
                    container.done();
                    break;
                }
                case DELETE: {
                    container.beforeDelete(bean);
                    container.afterDelete(bean);
                    container.done();
                    break;
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DeleteRuleListener [fkName=");
            builder.append(this.fkName);
            builder.append(", deleteRule=");
            builder.append(this.deleteRule);
            builder.append(", foreignKeyIds=");
            builder.append(BaseTableManager.this.metaData.columnNamesOf(this.foreignKeyIds));
            builder.append("]");
            return builder.toString();
        }
    }

    class ListAction
    implements TableManager.Action<B> {
        final List<B> list;

        public ListAction() {
            this(false);
        }

        public ListAction(boolean nopage) {
            Page page;
            this.list = !nopage && null != (page = PageHelper.getLocalPage()) && page.isEnable() ? page : new LinkedList();
        }

        public List<B> getList() {
            return this.list;
        }

        public void call(B bean) {
            this.list.add(bean);
        }
    }
}

