/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseColumnStore;
import gu.sql2java.exception.RuntimeDaoException;
import java.io.IOException;
import java.net.URL;

public class BinaryStoreTable
extends BaseColumnStore {
    public BinaryStoreTable(String tablename, String storeColumn, String extensionColumn, String mimeColumn) throws IllegalArgumentException {
        super(tablename, storeColumn, extensionColumn, mimeColumn);
        Preconditions.checkArgument((this.metaData.primaryKeyCount == 1 && String.class.equals((Object)this.metaData.primaryKeyTypes[0]) ? 1 : 0) != 0, (String)"String type required for primary key of %s", (Object)tablename);
        Preconditions.checkArgument((this.metaData.columnSizes[this.metaData.primaryKeyIds[0]] == 32 ? 1 : 0) != 0, (String)"size 32 required for %s.%s", (Object)tablename, (Object)this.metaData.primaryKeyNames[0]);
    }

    @Override
    protected URL doStore(byte[] binary, String md5, String extension, boolean makeURLOnly) throws IOException {
        try {
            BaseBean bean = this.manager.loadByPrimaryKey(new Object[]{md5});
            if (bean == null) {
                bean = this.manager.createBean();
                bean.setValue(this.metaData.primaryKeyIds[0], (Object)md5);
            }
            this.fillStoreBean(bean, binary, extension);
            if (!makeURLOnly) {
                this.manager.save(bean);
            }
            return this.makeURL(extension, md5);
        }
        catch (RuntimeDaoException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected URL doFind(String md5) {
        BaseBean bean = this.manager.loadByPrimaryKey(new Object[]{md5});
        return bean == null ? null : this.makeURL(this.getExtension(bean), bean.primaryValues());
    }

    @Override
    protected boolean doExists(URL storedURL) {
        BaseColumnStore.DatabaseURLConnection connection = new BaseColumnStore.DatabaseURLConnection(storedURL).parse();
        return this.manager.existsPrimaryKey(connection.primaryKeys);
    }

    @Override
    protected Object[] primaryKeysOf(String md5, String extension) {
        return new Object[]{md5};
    }
}

