/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.Constant;
import gu.sql2java.ListenerContainer;
import gu.sql2java.TableCache;
import gu.sql2java.TableListener;
import gu.sql2java.TableManager;
import gu.sql2java.TableManagerDecorator;
import gu.sql2java.exception.DaoException;
import gu.sql2java.exception.ObjectRetrievalException;
import gu.sql2java.exception.RuntimeDaoException;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class CacheManager
extends BaseTableManager<BaseBean> {
    private final TableCache<BaseBean> cache;

    CacheManager(String tablename, Constant.UpdateStrategy updateStrategy, Long maximumSize, Long duration, TimeUnit unit) {
        super(tablename);
        this.cache = new TableCache(this.metaData, updateStrategy, maximumSize, duration, unit);
        this.cache.registerListener();
    }

    CacheManager(String tablename) {
        this(tablename, null, null, null, null);
    }

    static final synchronized TableManager<?> makeCacheInstance(String tablename, Constant.UpdateStrategy updateStrategy, long maximumSize, long duration, TimeUnit unit) {
        CacheManager manager = new CacheManager(tablename, updateStrategy, maximumSize, duration, unit);
        return TableManagerDecorator.makeInterfaceInstance(manager);
    }

    @Override
    protected BaseBean doLoadByPrimaryKeyChecked(Object ... keys) throws RuntimeDaoException, ObjectRetrievalException {
        return this.cache.getBean(keys);
    }

    @Override
    protected boolean doExistsPrimaryKey(Object ... keys) throws RuntimeDaoException {
        return null != this.cache.getBeanUnchecked(keys);
    }

    @Override
    protected int actionOnResultSet(ResultSet rs, int[] fieldList, int startRow, int numRows, TableManager.Action<BaseBean> action) throws DaoException {
        if (null == fieldList || fieldList.length == 0) {
            action = this.cache.wrap(action);
        }
        return super.actionOnResultSet(rs, fieldList, startRow, numRows, action);
    }

    @Override
    protected BaseBean doLoadUniqueByIndex(String indexName, Object ... indexValues) throws RuntimeDaoException {
        return this.cache.getBeanByIndexUnchecked(indexName, indexValues);
    }

    @Override
    protected BaseBean doLoadUniqueByIndexChecked(String indexName, Object ... indexValues) throws ObjectRetrievalException {
        return this.cache.getBeanByIndex(indexName, indexValues);
    }

    @Override
    protected Map<String, TableListener<BaseBean>> getForeignKeyDeleteListeners() {
        return this.cache.getManager().getForeignKeyDeleteListeners();
    }

    @Override
    public ListenerContainer<BaseBean> getListenerContainer() {
        return this.cache.getManager().getListenerContainer();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CacheManager [cache=");
        builder.append(this.cache);
        builder.append("]");
        return builder.toString();
    }
}

