/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.DeepCacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.Constant;
import gu.sql2java.IKeyCache;
import gu.sql2java.Managers;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.exception.ObjectRetrievalException;
import gu.sql2java.exception.RuntimeDaoException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class ColumnCache<B extends BaseBean>
implements IKeyCache<B>,
RemovalListener<Object[], B>,
Constant {
    protected final RowMetaData metaData;
    private final LoadingCache<Object[], B> cache;
    private final ConcurrentMap<Object[], B> cacheMap;
    protected final Constant.UpdateStrategy updateStrategy;
    protected final Long maximumSize;
    protected final long duration;
    protected final TimeUnit unit;
    private final int[] keyIds;
    protected final BaseTableManager<B> manager;
    protected final String indexName;
    protected static boolean debug = false;

    ColumnCache(RowMetaData metaData, String indexName, Constant.UpdateStrategy updateStrategy, Long maximumSize, Long duration, TimeUnit unit) {
        this.metaData = (RowMetaData)Preconditions.checkNotNull((Object)metaData, (Object)"metaData is null");
        this.manager = Managers.getBaseTableManager(metaData.tablename);
        this.indexName = Strings.emptyToNull((String)indexName);
        this.keyIds = this.indexName == null ? metaData.primaryKeyIds : metaData.indexIdArray(indexName);
        this.updateStrategy = (Constant.UpdateStrategy)MoreObjects.firstNonNull((Object)updateStrategy, (Object)DEFAULT_STRATEGY);
        this.maximumSize = maximumSize != null && maximumSize > 0L ? maximumSize : 10000L;
        this.duration = duration != null && duration > 0L ? duration : 10L;
        this.unit = (TimeUnit)((Object)MoreObjects.firstNonNull((Object)((Object)unit), (Object)((Object)DEFAULT_TIME_UNIT)));
        this.cache = DeepCacheBuilder.newBuilder().maximumSize(this.maximumSize.longValue()).expireAfterAccess(this.duration, this.unit).removalListener((RemovalListener)this).build(new CacheLoader<Object[], B>(){

            public B load(Object[] keys) throws Exception {
                return ColumnCache.this.loadfromDatabase(keys);
            }
        });
        this.cacheMap = this.cache.asMap();
        if (debug) {
            SimpleLog.log((String)"ColumnCache FOR %s(%s) of %s(%s)", (Object[])new Object[]{MoreObjects.firstNonNull((Object)indexName, (Object)"PK"), Joiner.on((String)",").join((Iterable)metaData.columnNamesOf(this.keyIds)), metaData.tablename, updateStrategy});
        }
    }

    private static int indexOfFirstNull(Object ... objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (null != objects[i]) continue;
                return i;
            }
            return -1;
        }
        return -2;
    }

    private static boolean hasNull(Object ... objects) {
        return ColumnCache.indexOfFirstNull(objects) != -1;
    }

    private void checkNonNullKey(Object ... keys) throws ObjectRetrievalException {
        Preconditions.checkArgument((keys != null && keys.length == this.keyIds.length ? 1 : 0) != 0, (String)"MISMATCHED length of 'keys' with column count of %s", (Object)MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"));
        int index = ColumnCache.indexOfFirstNull(keys);
        if (index != -1) {
            throw new ObjectRetrievalException(String.format("value of %s is null", this.metaData.columnNames.get(this.keyIds[index])));
        }
    }

    protected B loadfromDatabase(Object[] keys) throws RuntimeDaoException, ObjectRetrievalException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.keyIds.length; ++i) {
            builder.put((Object)this.keyIds[i], keys[i]);
        }
        BaseBean bean = this.manager.createBean().copy((Map)builder.build());
        if (debug) {
            SimpleLog.log((String)"LOAD BY %s%s of %s", (Object[])new Object[]{MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"), Arrays.toString(keys), this.metaData.tablename});
        }
        try {
            return (B)this.manager.loadUniqueUsingTemplateChecked(bean);
        }
        catch (ObjectRetrievalException e) {
            throw new ObjectRetrievalException(SimpleLog.logString((String)"Not found element for {}{} of {}", (Object[])new Object[]{MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"), Arrays.toString(keys), this.metaData.tablename}));
        }
    }

    @Override
    public B getBean(Object ... keys) throws ObjectRetrievalException {
        this.checkNonNullKey(keys);
        try {
            return (B)((BaseBean)this.cache.get((Object)keys));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (null != e.getCause()) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), ObjectRetrievalException.class);
                Throwables.throwIfUnchecked((Throwable)e.getCause());
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public B getBeanUnchecked(Object ... keys) {
        try {
            return this.getBean(keys);
        }
        catch (ObjectRetrievalException e) {
            return null;
        }
    }

    @Override
    public boolean hasValidKey(B bean) {
        if (bean != null) {
            for (Object key : bean.asValueArray(this.keyIds)) {
                if (key != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public B remove(B bean) {
        if (bean != null) {
            Object[] keys = bean.asValueArray(this.keyIds);
            return (B)((BaseBean)this.cacheMap.remove(keys));
        }
        return null;
    }

    @Override
    public void update(B bean, Constant.UpdateStrategy updateStrategy) {
        if (bean != null) {
            updateStrategy = (Constant.UpdateStrategy)MoreObjects.firstNonNull((Object)updateStrategy, (Object)Constant.UpdateStrategy.always);
            Object[] keys = bean.asValueArray(this.keyIds);
            if (!ColumnCache.hasNull(keys)) {
                switch (updateStrategy) {
                    case replace: {
                        this.cacheMap.replace(keys, bean);
                        break;
                    }
                    case remove: {
                        this.cacheMap.remove(keys);
                        break;
                    }
                    case refresh: {
                        this.cacheMap.put(keys, this.loadfromDatabase(keys));
                        break;
                    }
                    default: {
                        this.cacheMap.put(keys, bean);
                    }
                }
                if (debug) {
                    SimpleLog.log((String)"UPDATE(%s) RECORD %s%s of %s", (Object[])new Object[]{updateStrategy, MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"), Arrays.toString(keys), this.metaData.tablename});
                }
            }
        }
    }

    @Override
    public void update(B bean) {
        this.update(bean, this.updateStrategy);
    }

    public void onRemoval(RemovalNotification<Object[], B> notification) {
        if (debug) {
            SimpleLog.log((String)"CACHE REMOVE:Key:{}({}) for {}", (Object[])new Object[]{MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"), Arrays.toString((Object[])notification.getKey()), this.metaData.tablename});
        }
    }

    public BaseTableManager<B> getManager() {
        return this.manager;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexName == null ? 0 : this.indexName.hashCode());
        result = 31 * result + Arrays.hashCode(this.keyIds);
        result = 31 * result + (this.metaData == null ? 0 : this.metaData.hashCode());
        result = 31 * result + (this.updateStrategy == null ? 0 : this.updateStrategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnCache)) {
            return false;
        }
        ColumnCache other = (ColumnCache)obj;
        if (this.indexName == null ? other.indexName != null : !this.indexName.equals(other.indexName)) {
            return false;
        }
        if (!Arrays.equals(this.keyIds, other.keyIds)) {
            return false;
        }
        if (this.metaData == null ? other.metaData != null : !this.metaData.equals((Object)other.metaData)) {
            return false;
        }
        return this.updateStrategy == other.updateStrategy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ColumnCache [tablename=");
        builder.append(this.metaData.tablename);
        builder.append(", updateStrategy=");
        builder.append(this.updateStrategy);
        builder.append(", keyIds=");
        builder.append(this.metaData.columnNamesOf(this.keyIds));
        builder.append(", indexName=");
        builder.append((String)MoreObjects.firstNonNull((Object)this.indexName, (Object)"PK"));
        builder.append(", maximumSize=");
        builder.append(this.maximumSize);
        builder.append(", duration=");
        builder.append(this.duration);
        builder.append(", unit=");
        builder.append((Object)this.unit);
        builder.append("]");
        return builder.toString();
    }

    static void setDebug(boolean debug) {
        ColumnCache.debug = debug;
    }
}

