/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import gu.sql2java.BaseEmbeddedInitializer;
import gu.sql2java.Constant;
import gu.sql2java.EmbeddedInitException;
import gu.sql2java.Managers;
import gu.sql2java.SimpleLog;
import java.io.File;
import java.net.URL;
import java.util.Properties;

public class DerbyInitializer
extends BaseEmbeddedInitializer {
    public DerbyInitializer(File db, URL createSql, boolean runInMemory) {
        super(db, createSql, runInMemory);
    }

    private static String createJDBCUrl(boolean runInMemory, File db) {
        String create = null;
        String jdbcurl = null;
        if (runInMemory) {
            create = db.exists() && db.isDirectory() ? "restoreFrom=" + db.getAbsolutePath() : "create=true";
            jdbcurl = String.format("jdbc:derby:memory:%s;%s", db.getName(), create);
        } else {
            create = db.exists() && db.isDirectory() ? "" : ";create=true";
            jdbcurl = String.format("jdbc:derby:%s%s", db.getAbsolutePath(), create);
        }
        return jdbcurl;
    }

    @Override
    protected void doPersist() {
        String backupStr = "CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)";
        Managers.getSqlRunner(this.dbprops.getProperty(Constant.JdbcProperty.ALIAS.key)).runSql(backupStr, new Object[]{this.dbroot.getAbsolutePath()});
    }

    @Override
    protected void writeDbProps(Properties dbprops) {
        dbprops.setProperty(Constant.JdbcProperty.JDBC_URL.key, DerbyInitializer.createJDBCUrl(this.runInMemory, this.db));
        dbprops.setProperty(Constant.JdbcProperty.JDBC_DRIVER.key, "org.apache.derby.jdbc.AutoloadedDriver");
    }

    @Override
    protected void checkExistsDatabse(File db) throws EmbeddedInitException {
        if (db.isDirectory() && new File(db, "log").isDirectory() && new File(db, "seg0").isDirectory()) {
            return;
        }
        throw new EmbeddedInitException(SimpleLog.logString((String)"{} IS NOT a derby database", (Object[])new Object[]{db.getAbsolutePath()}));
    }

    public static DerbyInitializer init(File db, URL createSql, boolean runInMemory, Properties properties) {
        return DerbyInitializer.init(DerbyInitializer.class, db, createSql, runInMemory, properties);
    }

    public static DerbyInitializer init(String db, String createSql, boolean runInMemory, Properties properties) {
        return DerbyInitializer.init(DerbyInitializer.class, db, createSql, runInMemory, properties);
    }
}

