/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableManager;
import gu.sql2java.exception.QueueTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class QueueProducerAction<B extends BaseBean, T>
implements TableManager.Action<B> {
    static final int DEFAULT_QUEUE_CAPACITY = 1000;
    static final int DEFAULT_QUEUE_TIMEOUT = 10;
    private final BlockingQueue<T> queue;
    private final Function<B, T> transformer;
    private final int queueTimeout;
    private final AtomicLong count = new AtomicLong(0L);

    public QueueProducerAction(BlockingQueue<T> queue, int queueTimeout, Function<B, T> transformer) {
        this.queue = (BlockingQueue)Preconditions.checkNotNull(queue, (Object)"queue is null");
        this.queueTimeout = queueTimeout > 0 ? queueTimeout : 10;
        this.transformer = (Function)Preconditions.checkNotNull(transformer, (Object)"transformer is null");
    }

    public QueueProducerAction(int queueCapaticy, int queueTimeout, Function<B, T> transformer) {
        this.queue = new LinkedBlockingQueue<T>(queueCapaticy > 0 ? queueCapaticy : 1000);
        this.queueTimeout = queueTimeout > 0 ? queueTimeout : 10;
        this.transformer = (Function)Preconditions.checkNotNull(transformer, (Object)"transformer is null");
    }

    public QueueProducerAction(Function<B, T> transformer) {
        this(0, 0, transformer);
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void call(B bean) {
        try {
            if (!this.queue.offer(this.transformer.apply(bean), this.queueTimeout, TimeUnit.SECONDS)) {
                throw new QueueTimeoutException();
            }
            long c = this.count.incrementAndGet();
            if (0L == c % 10000L) {
                SimpleLog.log((boolean)BaseTableManager.isDebug(), (String)"FETCH {} rows", (Object[])new Object[]{c});
            }
        }
        catch (InterruptedException e) {
            throw new QueueTimeoutException((Throwable)e);
        }
    }

    public static class SimpleQueueProducerAction<B extends BaseBean>
    extends QueueProducerAction<B, B> {
        public SimpleQueueProducerAction(BlockingQueue<B> queue, int queueTimeout) {
            super(queue, queueTimeout, b -> b);
        }

        public SimpleQueueProducerAction(int queueCapaticy, int queueTimeout) {
            super(queueCapaticy, queueTimeout, b -> b);
        }

        public SimpleQueueProducerAction() {
            super(b -> b);
        }
    }
}

