/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import gu.sql2java.Constant;
import gu.sql2java.SqlFormatter;
import gu.sql2java.mysql.MysqlSqlFormatter;
import gu.sql2java.phoenix.PhonenixSqlFormatter;
import java.util.Map;

public class SqlFormatters
implements Constant {
    private static Map<String, SqlFormatter> sqlFormatters = ImmutableMap.of((Object)"Phoenix", (Object)new PhonenixSqlFormatter(), (Object)"MySQL", (Object)new MysqlSqlFormatter());
    private static SqlFormatter DEFAULT_INSTANCE = new SqlFormatterAdapter();

    public static SqlFormatter formatterOf(String engine) {
        return sqlFormatters.getOrDefault(engine, DEFAULT_INSTANCE);
    }

    public static class QuoteFormatter
    extends SqlFormatterAdapter {
        private final String quote;

        public QuoteFormatter(String quote) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)quote) ? 1 : 0) != 0, (Object)"quote is null or empty");
            this.quote = quote;
        }

        protected boolean isQuoteWith(String input) {
            if (null != input) {
                return input.startsWith(this.quote) && input.endsWith(this.quote);
            }
            return false;
        }

        protected String quoteIf(String input, Predicate<String> and) {
            if (null != input && !this.isQuoteWith(input) && and.apply((Object)input)) {
                return this.quote + input + this.quote;
            }
            return input;
        }

        @Override
        public String alias(String alias) {
            return this.columname(alias);
        }
    }

    public static class SqlFormatterAdapter
    implements SqlFormatter {
        @Override
        public String tablename(String tablename) {
            return tablename;
        }

        @Override
        public String columname(String columname) {
            return columname;
        }

        @Override
        public String alias(String alias) {
            return alias;
        }
    }
}

