/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import gu.sql2java.BaseEmbeddedInitializer;
import gu.sql2java.Constant;
import gu.sql2java.EmbeddedInitException;
import gu.sql2java.Managers;
import gu.sql2java.ScriptRunner;
import gu.sql2java.SimpleLog;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqliteInitializer
extends BaseEmbeddedInitializer {
    public SqliteInitializer(File db, URL createSql, boolean runInMemory) {
        super(db, createSql, runInMemory);
    }

    private static String createJDBCUrl(boolean runInMemory, File db) {
        String jdbcurl = null;
        jdbcurl = runInMemory ? String.format("jdbc:sqlite::memory:", new Object[0]) : String.format("jdbc:sqlite:%s", db.getAbsolutePath());
        return jdbcurl;
    }

    @Override
    protected void doInitMemory() {
        String sqlStr = "restore from " + this.db.getAbsolutePath();
        Managers.getSqlRunner(this.dbprops.getProperty(Constant.JdbcProperty.ALIAS.key)).runSql(sqlStr);
    }

    @Override
    protected ScriptRunner normalize(ScriptRunner runner) {
        return runner.addClearRegex(Pattern.compile("DEFAULT +CHARSET *= *(.+)", 2)).addClearRegex(Pattern.compile("ON +UPDATE +CURRENT_TIMESTAMP", 2)).addClearRegex(Pattern.compile("SET +NAMES.*", 2)).addReplaceRegex(Pattern.compile("AUTO_INCREMENT", 2), "AUTOINCREMENT").addReplaceRegex(Pattern.compile("int\\s*\\(\\s*\\d+\\s*\\)", 2), "integer").addIgnoreRegex(Pattern.compile("SET +NAMES.*", 2)).addIgnoreRegex(Pattern.compile("SET +CHARACTER.*", 2));
    }

    @Override
    protected void doPersist() {
        String sqlStr = "backup to " + this.db.getAbsolutePath();
        Managers.getSqlRunner(this.dbprops.getProperty(Constant.JdbcProperty.ALIAS.key)).runSql(sqlStr);
    }

    @Override
    protected void writeDbProps(Properties dbprops) {
        dbprops.setProperty(Constant.JdbcProperty.JDBC_URL.key, SqliteInitializer.createJDBCUrl(this.runInMemory, this.db));
        dbprops.setProperty(Constant.JdbcProperty.DATASOURCE.key, "SQLITE");
    }

    @Override
    protected void checkExistsDatabse(File db) throws EmbeddedInitException {
        if (db.isFile() && db.canRead() && db.canWrite()) {
            return;
        }
        throw new EmbeddedInitException(SimpleLog.logString((String)"{} IS NOT a SQLite database", (Object[])new Object[]{db.getAbsolutePath()}));
    }

    private List<String> getPrimaryKeys(DatabaseMetaData metadata, String tablename) throws SQLException {
        ResultSet resultSet = metadata.getPrimaryKeys("", "", tablename);
        LinkedList pkNames = Lists.newLinkedList();
        while (resultSet.next()) {
            pkNames.add(resultSet.getString("COLUMN_NAME"));
        }
        Preconditions.checkState((!pkNames.isEmpty() ? 1 : 0) != 0, (String)"NOT FOUND Primary key of table  %s", (Object)tablename);
        return pkNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> afterCreateTable(ScriptRunner runner) throws SQLException {
        List<String> executableSqls = runner.getExecutableSqls();
        if (executableSqls.isEmpty()) {
            return Collections.emptyList();
        }
        Connection connection = null;
        try {
            connection = Managers.managerInstanceOfAlias(this.dbprops.getProperty(Constant.JdbcProperty.ALIAS.key)).getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            LinkedList additional = Lists.newLinkedList();
            Pattern tablePattern = Pattern.compile("CREATE\\s+TABLE\\s+((\\w+\\s+)*)([\\w\\.'\"`]+)\\s*\\((.+)\\)", 2);
            for (String sql : executableSqls) {
                Matcher tmacher = tablePattern.matcher(sql);
                while (tmacher.find()) {
                    String tablename = tmacher.group(3);
                    List<String> pks = this.getPrimaryKeys(metadata, tablename);
                    String cols = tmacher.group(4);
                    Pattern colPattern = Pattern.compile("(['\"`])?([\\w\\d]+)\\1\\s+timestamp\\s+DEFAULT(\\s+(?:CURRENT_TIMESTAMP|NULL)\\s+)?ON\\s+UPDATE\\s+CURRENT_TIMESTAMP\\s*(,|$)", 2);
                    Matcher cmacher = colPattern.matcher(cols);
                    while (cmacher.find()) {
                        String timestampColumn = cmacher.group(2);
                        String triggerName = "trigger_" + tablename + "_" + timestampColumn;
                        String tmpl = "CREATE TRIGGER IF NOT EXISTS ${trigger} AFTER  UPDATE ON ${table} FOR EACH ROW WHEN NEW.${col} <= OLD.${col} BEGIN  \tUPDATE ${table} SET ${col}=CURRENT_TIMESTAMP WHERE ${where};END;";
                        String where = Joiner.on((String)" AND ").join((Iterable)Lists.transform(pks, (Function)new Function<String, String>(){

                            public String apply(String input) {
                                return "NEW.{}=OLD.{}".replace("{}", input);
                            }
                        }));
                        String triggerSQL = tmpl.replace("${table}", tablename).replace("${col}", timestampColumn).replace("${trigger}", triggerName).replace("${where}", where);
                        additional.add(triggerSQL);
                    }
                }
            }
            LinkedList linkedList = additional;
            return linkedList;
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
    }

    public static SqliteInitializer init(File db, URL createSql, boolean runInMemory, Properties properties) {
        return SqliteInitializer.init(SqliteInitializer.class, db, createSql, runInMemory, properties);
    }

    public static SqliteInitializer init(String db, String createSqlURL, boolean runInMemory, Properties properties) {
        return SqliteInitializer.init(SqliteInitializer.class, db, createSqlURL, runInMemory, properties);
    }
}

