/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.QueueProducerAction;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class TableManagers {
    private static final int CACHE_MAXIMUMPOOLSIZE = Runtime.getRuntime().availableProcessors();
    private static final long CACHE_KEEPALIVETIME = 60L;
    private static final int CACHE_QUEUECAPACITY = 1024;
    private static final String CACHE_NAMEFORMAT = "sql2java-pool-%d";
    private static Boolean debug;

    private static final ExecutorService createCachedPool() {
        ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(CACHE_MAXIMUMPOOLSIZE, CACHE_MAXIMUMPOOLSIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(CACHE_NAMEFORMAT).build()));
        return executor;
    }

    private static Boolean isDebug() {
        return null == debug ? BaseTableManager.isDebug() : debug;
    }

    public static void setDebug(Boolean debug) {
        TableManagers.debug = debug;
    }

    public static ExecutorService getExecutorService() {
        return Singleton.GLOBAL_EXECUTOR;
    }

    public static <B extends BaseBean> void loadByJoinWhereAsync(TableManager<B> manager, String join, String where, Object[] argList, int[] fieldList, int numRows, TableManager.Action<B> action, AtomicBoolean stopped, Executor executor) {
        Preconditions.checkArgument((null != manager ? 1 : 0) != 0, (Object)"manager is null");
        Preconditions.checkArgument((null != action ? 1 : 0) != 0, (Object)"action is null");
        if (0 == numRows) {
            return;
        }
        ((Executor)MoreObjects.firstNonNull((Object)executor, (Object)Singleton.GLOBAL_EXECUTOR)).execute(() -> {
            if (numRows < 0) {
                if (null != stopped && stopped.get()) {
                    return;
                }
                SimpleLog.log((boolean)TableManagers.isDebug(), (String)"loadByJoinWhereAsync:join={} where={}\nargs [{}]", (Object[])new Object[]{join, where, null == argList ? "[]" : Joiner.on((String)",").join(Iterables.transform(Arrays.asList(argList), String::valueOf))});
                manager.loadByJoinWhereForAction(join, where, argList, fieldList, 1, -1, action);
            } else {
                int startRow = 1;
                int count = 0;
                while (null == stopped || !stopped.get()) {
                    SimpleLog.log((boolean)TableManagers.isDebug(), (String)"loadByJoinWhereAsync:join={} where={},numRows={}\nargs [{}]", (Object[])new Object[]{join, where, numRows, null == argList ? "[]" : Joiner.on((String)",").join(Iterables.transform(Arrays.asList(argList), String::valueOf))});
                    if ((count = manager.loadByJoinWhereForAction(join, where, argList, fieldList, startRow += count, numRows, action)) == numRows) continue;
                }
            }
        });
    }

    public static <B extends BaseBean, T> void loadByJoinWhereAsync(TableManager<B> manager, String join, String where, Object[] argList, int[] fieldList, int numRows, BlockingQueue<T> queue, int queueTimeout, AtomicBoolean stopped, Function<B, T> transformer, Executor executor) {
        QueueProducerAction<B, T> action = new QueueProducerAction<B, T>(queue, queueTimeout, transformer);
        TableManagers.loadByJoinWhereAsync(manager, join, where, argList, fieldList, numRows, action, stopped, executor);
    }

    public static <B extends BaseBean, T> BlockingQueue<T> loadByJoinWhereAsync(TableManager<B> manager, String join, String where, Object[] argList, int[] fieldList, int numRows, int queueCapacity, int queueTimeout, AtomicBoolean stopped, Function<B, T> transformer, Executor executor) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue(queueCapacity);
        TableManagers.loadByJoinWhereAsync(manager, join, where, argList, fieldList, numRows, queue, queueTimeout, stopped, transformer, executor);
        return queue;
    }

    public static <B extends BaseBean> BlockingQueue<B> loadByJoinWhereAsync(TableManager<B> manager, String join, String where, Object[] argList, int numRows, int queueCapacity, int queueTimeout, AtomicBoolean stopped, Executor executor) {
        return TableManagers.loadByJoinWhereAsync(manager, join, where, argList, null, numRows, queueCapacity, queueTimeout, stopped, b -> b, executor);
    }

    public static <B extends BaseBean> List<BaseBean> aggregateAsList(TableManager<B> manager, String columns, String where, String groupBy, String having, String orderBy, Object ... argList) {
        columns = Strings.nullToEmpty((String)columns).trim();
        where = Strings.nullToEmpty((String)where).trim();
        groupBy = Strings.nullToEmpty((String)groupBy).trim();
        having = Strings.nullToEmpty((String)having).trim();
        orderBy = Strings.nullToEmpty((String)orderBy).trim();
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns is null or empty");
        Preconditions.checkArgument((!groupBy.isEmpty() ? 1 : 0) != 0, (Object)"groupBy is null or empty");
        where = Pattern.compile("^WHERE", 2).matcher(where).replaceAll("");
        groupBy = Pattern.compile("^GROUP +BY", 2).matcher(groupBy).replaceAll("");
        having = Pattern.compile("^HAVING", 2).matcher(having).replaceAll("");
        orderBy = Pattern.compile("^ORDER +BY", 2).matcher(orderBy).replaceAll("");
        String sql = String.format("SELECT %s FROM %s %s %s %s %s", columns, TableManagers.tablenameOf(manager), where.isEmpty() ? "" : "WHERE " + where, "GROUP BY " + groupBy, having.isEmpty() ? "" : "HAVING " + having, orderBy.isEmpty() ? "" : "ORDER BY " + orderBy);
        return ((TableManager)Preconditions.checkNotNull(manager, (Object)"manager is null")).runSqlAsList(sql, argList);
    }

    private static <B extends BaseBean> String tablenameOf(TableManager<B> manager) {
        if (manager instanceof BaseTableManager) {
            return ((BaseTableManager)manager).metaData.tablename;
        }
        return manager.createBean().tableName();
    }

    static /* synthetic */ ExecutorService access$000() {
        return TableManagers.createCachedPool();
    }

    private static class Singleton {
        static final ExecutorService GLOBAL_EXECUTOR = TableManagers.access$000();

        private Singleton() {
        }
    }
}

