/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.parser;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class CountSqlParser {
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    private static final Alias TABLE_ALIAS;
    private final Set<String> skipFunctions = Collections.synchronizedSet(new HashSet());
    private final Set<String> falseFunctions = Collections.synchronizedSet(new HashSet());
    private static final Set<String> AGGREGATE_FUNCTIONS;

    public static void addAggregateFunctions(String functions) {
        if (!Strings.isNullOrEmpty((String)functions)) {
            String[] funs = functions.split(",");
            for (int i = 0; i < funs.length; ++i) {
                AGGREGATE_FUNCTIONS.add(funs[i].toUpperCase());
            }
        }
    }

    public String getSmartCountSql(String sql) {
        return this.getSmartCountSql(sql, "0");
    }

    public String getSmartCountSql(String sql, String countColumn) {
        Statement stmt = null;
        if (sql.indexOf(KEEP_ORDERBY) >= 0) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        return this.getSmartCountSql((Select)stmt, countColumn);
    }

    public String getSmartCountSql(Select select, String countColumn) {
        SelectBody selectBody = select.getSelectBody();
        try {
            this.processSelectBody(selectBody);
        }
        catch (Exception e) {
            return this.getSimpleCountSql(select.toString(), countColumn);
        }
        this.processWithItemsList(select.getWithItemsList());
        this.sqlToCount(select, countColumn);
        String result = select.toString();
        return result;
    }

    public String getSmartCountSql(Select select) {
        return this.getSmartCountSql(select, "0");
    }

    public String getSimpleCountSql(String sql) {
        return this.getSimpleCountSql(sql, "0");
    }

    public String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public void sqlToCount(Select select, String name) {
        SelectBody selectBody = select.getSelectBody();
        ArrayList<SelectExpressionItem> COUNT_ITEM = new ArrayList<SelectExpressionItem>();
        COUNT_ITEM.add(new SelectExpressionItem((Expression)new Column("count(" + name + ")")));
        if (selectBody instanceof PlainSelect && this.isSimpleCount((PlainSelect)selectBody)) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        if (select.getHaving() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            if (item.toString().contains("?")) {
                return false;
            }
            if (!(item instanceof SelectExpressionItem)) continue;
            Expression expression = ((SelectExpressionItem)item).getExpression();
            if (expression instanceof Function) {
                String NAME;
                String name = ((Function)expression).getName();
                if (name == null || this.skipFunctions.contains(NAME = name.toUpperCase())) continue;
                if (this.falseFunctions.contains(NAME)) {
                    return false;
                }
                for (String aggregateFunction : AGGREGATE_FUNCTIONS) {
                    if (!NAME.startsWith(aggregateFunction)) continue;
                    this.falseFunctions.add(NAME);
                    return false;
                }
                this.skipFunctions.add(NAME);
                continue;
            }
            if (!(expression instanceof Parenthesis) || ((SelectExpressionItem)item).getAlias() == null) continue;
            return false;
        }
        return true;
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody != null) {
            if (selectBody instanceof PlainSelect) {
                this.processPlainSelect((PlainSelect)selectBody);
            } else if (selectBody instanceof WithItem) {
                WithItem withItem = (WithItem)selectBody;
                if (withItem.getSubSelect() != null) {
                    this.processSelectBody(withItem.getSubSelect().getSelectBody());
                }
            } else {
                SetOperationList operationList = (SetOperationList)selectBody;
                if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                    List plainSelects = operationList.getSelects();
                    for (SelectBody plainSelect : plainSelects) {
                        this.processSelectBody(plainSelect);
                    }
                }
                if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                    operationList.setOrderByElements(null);
                }
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                if (item.getSubSelect() == null) continue;
                this.processSelectBody(item.getSubSelect().getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null && subJoin.getJoinList().size() > 0) {
                for (Join join : subJoin.getJoinList()) {
                    if (join.getRightItem() == null) continue;
                    this.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        AGGREGATE_FUNCTIONS = new HashSet<String>(Arrays.asList("APPROX_COUNT_DISTINCT,ARRAY_AGG,AVG,BIT_,BOOL_,CHECKSUM_AGG,COLLECT,CORR,COUNT,COVAR,CUME_DIST,DENSE_RANK,EVERY,FIRST,GROUP,JSON_,LAST,LISTAGG,MAX,MEDIAN,MIN,PERCENT_,RANK,REGR_,SELECTIVITY,STATS_,STD,STRING_AGG,SUM,SYS_OP_ZONE_ID,SYS_XMLAGG,VAR,XMLAGG".split(",")));
        TABLE_ALIAS = new Alias("table_count");
        TABLE_ALIAS.setUseAs(false);
    }
}

