/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.sqlite;

import gu.sql2java.DataSourceConfig;
import gu.sql2java.DataSourceFactory;
import gu.sql2java.SimpleLog;
import javax.sql.DataSource;
import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

public class SqliteDataSourceFactory
implements DataSourceFactory {
    private void logDatabaseParameters(DataSourceConfig config) {
        if (DataSourceConfig.isDebugOutput()) {
            SimpleLog.log((String)"database using debug environment parameter: ", (Object[])new Object[0]);
            SimpleLog.log((String)("datasource = " + config.getDataSource()), (Object[])new Object[0]);
            SimpleLog.log((String)("jdbcUrl = " + config.getJdbcUrl()), (Object[])new Object[0]);
        }
    }

    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        this.logDatabaseParameters(config);
        SQLiteConfig sqLiteConfig = new SQLiteConfig();
        sqLiteConfig.enforceForeignKeys(true);
        SQLiteConnectionPoolDataSource ds = new SQLiteConnectionPoolDataSource(sqLiteConfig);
        ds.setUrl(config.getJdbcUrl());
        return ds;
    }

    @Override
    public void destroy(DataSource dataSource) {
    }
}

