/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.URLParseChecks;
import gu.sql2java.BaseBean;
import gu.sql2java.Managers;
import gu.sql2java.RowMetaData;
import gu.sql2java.TableManager;
import gu.sql2java.exception.ObjectRetrievalException;
import gu.sql2java.store.BaseURLStore;
import gu.sql2java.store.BinaryUtils;
import gu.sql2java.store.ConditionChecks;
import gu.sql2java.store.DataNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.util.Map;

public class BaseColumnStore
extends BaseURLStore {
    private final Handler handler = new Handler();
    protected final String tablename;
    protected final String storeColumn;
    protected final TableManager<BaseBean> manager;
    protected final RowMetaData metaData;
    protected final Class<?> storeColumnType;
    protected final String protocol;
    protected final int extensionId;
    protected final int mimeId;
    protected static final String PKS = "PKS";

    public BaseColumnStore(String tablename, String storeColumn, String extensionColumn, String mimeColumn) {
        this.tablename = tablename;
        this.storeColumn = storeColumn;
        this.manager = Managers.managerOf(tablename);
        this.metaData = RowMetaData.getMetaData((String)tablename);
        this.extensionId = this.metaData.columnIDOf(extensionColumn);
        this.mimeId = this.metaData.columnIDOf(mimeColumn);
        this.storeColumnType = this.metaData.columnTypeOf(storeColumn);
        Preconditions.checkArgument((this.storeColumnType != null ? 1 : 0) != 0, (String)"INVALID column %s", (Object)storeColumn);
        Preconditions.checkArgument((byte[].class.equals(this.storeColumnType) || ByteBuffer.class.isAssignableFrom(this.storeColumnType) ? 1 : 0) != 0, (String)"INVALID column type of %s,byte[] or java.nio.ByteBuffer required", (Object)storeColumn);
        Preconditions.checkArgument((extensionColumn == null || String.class.equals((Object)this.metaData.columnTypeOf(this.extensionId)) ? 1 : 0) != 0, (String)"INVALID extensionColumn %s", (Object)extensionColumn);
        Preconditions.checkArgument((mimeColumn == null || String.class.equals((Object)this.metaData.columnTypeOf(this.mimeId)) ? 1 : 0) != 0, (String)"INVALID mimeColumn %s", (Object)mimeColumn);
        this.protocol = tablename.replaceAll("_", "-");
    }

    public String getProtocol() {
        return this.protocol;
    }

    protected Object[] primaryKeysOf(String md5, String extension) {
        Map p = (Map)this.additionalParams.get();
        Preconditions.checkState((p != null && p.containsKey(PKS) ? 1 : 0) != 0, (Object)"NOT PK defined");
        Object v = p.get(PKS);
        Preconditions.checkState((boolean)(v instanceof Object[]), (Object)"INVALID PK type,Object[] required");
        return (Object[])v;
    }

    protected final String pathOf(String suffix, Object ... primaryKeys) {
        StringBuffer buffer = new StringBuffer(this.storeColumn);
        for (int i = 0; i < primaryKeys.length; ++i) {
            buffer.append("/").append(primaryKeys[i]);
        }
        if (!Strings.isNullOrEmpty((String)suffix)) {
            buffer.append('.').append(suffix);
        }
        return buffer.toString();
    }

    protected final URL makeURL(String suffix, Object ... primaryKeys) {
        try {
            return new URL(this.getProtocol(), null, -1, this.pathOf(suffix, primaryKeys));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getExtension(BaseBean bean) {
        return (String)bean.getValue(this.extensionId);
    }

    protected String getMime(BaseBean bean) {
        String mime = (String)bean.getValue(this.mimeId);
        String extension = (String)bean.getValue(this.extensionId);
        if (mime != null) {
            return mime;
        }
        if (extension != null && (mime = URLConnection.guessContentTypeFromName("." + extension)) != null) {
            return mime;
        }
        return this.guessContentType(bean);
    }

    private String guessContentType(BaseBean bean) {
        try {
            if (bean == null) {
                return null;
            }
            byte[] data = BinaryUtils.getBytes((Object)bean.getValue(this.storeColumn));
            if (data == null) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            return URLConnection.guessContentTypeFromStream(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void fillStoreBean(BaseBean bean, byte[] binary, String extension) {
        if (ByteBuffer.class.equals(this.storeColumnType)) {
            bean.setValue(this.storeColumn, (Object)ByteBuffer.wrap(binary));
        } else {
            bean.setValue(this.storeColumn, (Object)binary);
        }
        if (this.extensionId >= 0) {
            bean.setValue(this.extensionId, (Object)extension);
        }
        if (this.mimeId >= 0) {
            bean.setValue(this.mimeId, (Object)this.getMime(bean));
        }
    }

    protected URL doStore(byte[] binary, String md5, String extension, boolean makeURLOnly) throws IOException {
        try {
            Object[] pks = this.primaryKeysOf(md5, extension);
            BaseBean bean = this.manager.loadByPrimaryKeyChecked(pks);
            this.fillStoreBean(bean, binary, extension);
            if (!makeURLOnly) {
                this.manager.save(bean);
            }
            URL uRL = this.makeURL(extension, pks);
            return uRL;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            throw new IOException(e);
        }
        finally {
            this.additionalParams.remove();
        }
    }

    protected URL doFind(String md5) {
        return null;
    }

    protected boolean doExists(URL storedURL) {
        DatabaseURLConnection connection = new DatabaseURLConnection(storedURL).parse();
        BaseBean found = this.manager.loadByPrimaryKey(connection.primaryKeys);
        return found != null && found.getValue(this.storeColumn) != null;
    }

    protected boolean doDelete(URL storedURL) throws IOException {
        try {
            DatabaseURLConnection bean = new DatabaseURLConnection(storedURL).parse();
            return this.manager.deleteByPrimaryKey(bean.primaryKeys) == 1;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            throw new IOException(e);
        }
    }

    protected URLStreamHandler doGetURLStreamHandler() {
        return this.handler;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.extensionId;
        result = 31 * result + this.mimeId;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.storeColumn == null ? 0 : this.storeColumn.hashCode());
        result = 31 * result + (this.tablename == null ? 0 : this.tablename.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BaseColumnStore)) {
            return false;
        }
        BaseColumnStore other = (BaseColumnStore)((Object)obj);
        if (this.extensionId != other.extensionId) {
            return false;
        }
        if (this.mimeId != other.mimeId) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.storeColumn == null ? other.storeColumn != null : !this.storeColumn.equals(other.storeColumn)) {
            return false;
        }
        return !(this.tablename == null ? other.tablename != null : !this.tablename.equals(other.tablename));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getSimpleName() + " [tablename=");
        builder.append(this.tablename);
        builder.append(", storeColumn=");
        builder.append(this.storeColumn);
        builder.append(", extensionColumn=");
        builder.append(this.metaData.columnNameOf(this.extensionId));
        builder.append(", mimeColumn=");
        builder.append(this.metaData.columnNameOf(this.mimeId));
        builder.append(", protocol=");
        builder.append(this.protocol);
        builder.append("]");
        return builder.toString();
    }

    private static <T> T valueOf(String input, Class<T> targetType) throws StringCastException {
        if (Strings.isNullOrEmpty((String)input) || String.class.equals(targetType)) {
            return (T)input;
        }
        ConditionChecks.checkNotNull((Object)(targetType != null ? 1 : 0), StringCastException.class, (String)"target is null", (Object[])new Object[0]);
        try {
            return (T)targetType.getMethod("valueOf", String.class).invoke(null, input);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException exception) {
        }
        catch (InvocationTargetException e) {
            throw new StringCastException(e.getTargetException());
        }
        throw new StringCastException(String.format("INVALID target type %s", targetType));
    }

    public static class StringCastException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StringCastException(Throwable cause) {
            super(cause);
        }

        public StringCastException(String message) {
            super(message);
        }
    }

    public static class URLParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public URLParseException(Throwable cause) {
            super(cause);
        }

        public URLParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public URLParseException(String message) {
            super(message);
        }
    }

    protected class DatabaseURLConnection
    extends URLConnection {
        Object[] primaryKeys;

        protected DatabaseURLConnection(URL url) {
            super(url);
        }

        DatabaseURLConnection parse() throws URLParseException {
            ConditionChecks.checkTrue((boolean)BaseColumnStore.this.getProtocol().equals(this.getURL().getProtocol()), URLParseException.class, (String)"INVALID protocol ,%s reqired", (Object)BaseColumnStore.this.getProtocol());
            String[] components = this.url.getPath().split("/");
            try {
                ConditionChecks.checkTrue((boolean)components[0].equals(BaseColumnStore.this.storeColumn), URLParseException.class, (String)"INVALID URL,the URL's path be reqired to start with '%s'", (Object)BaseColumnStore.this.storeColumn);
                ConditionChecks.checkTrue((components.length == BaseColumnStore.this.metaData.primaryKeyCount + 1 ? 1 : 0) != 0, URLParseException.class, (String)"MISMATCH path components acount, %s required", (Object)(BaseColumnStore.this.metaData.primaryKeyCount + 1));
                String last = components[components.length - 1];
                int lastDot = last.lastIndexOf(".");
                if (lastDot >= 0) {
                    components[components.length - 1] = last.substring(0, lastDot);
                }
                this.primaryKeys = new Object[BaseColumnStore.this.metaData.primaryKeyTypes.length];
                for (int i = 0; i < BaseColumnStore.this.metaData.primaryKeyTypes.length; ++i) {
                    this.primaryKeys[i] = BaseColumnStore.valueOf(components[i + 1], BaseColumnStore.this.metaData.primaryKeyTypes[i]);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new URLParseException("URL's path lack the necessary components /${storeColumn}/${pk}...[/${pkN}]", e);
            }
            catch (StringCastException e) {
                throw new URLParseException("FAIL TO get primary key from URL's path", e);
            }
            URLParseChecks.checkURLParse(this.url != null, "NOT DEFINED store column name in ref(#)", new Object[0]);
            Class columnType = (Class)ConditionChecks.checkNotNull((Object)BaseColumnStore.this.metaData.columnTypeOf(BaseColumnStore.this.storeColumn), URLParseException.class, (String)"INVALID column %s", (Object)BaseColumnStore.this.storeColumn);
            URLParseChecks.checkURLParse(byte[].class.equals((Object)columnType) || ByteBuffer.class.isAssignableFrom(columnType), "INVALID column type of %s, binary type ( byte[] or java.nio.ByteBuffer) required", (Object)BaseColumnStore.this.storeColumn);
            return this;
        }

        @Override
        public void connect() throws IOException {
            try {
                this.parse();
                this.connected = true;
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw new IOException(e);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            try {
                BaseBean bean = BaseColumnStore.this.manager.loadByPrimaryKeyChecked(this.primaryKeys);
                Object data = bean.getValue(BaseColumnStore.this.storeColumn);
                ConditionChecks.checkTrue((data != null ? 1 : 0) != 0, DataNotFoundException.class, (String)"column %s of %s is null", (Object[])new Object[]{BaseColumnStore.this.storeColumn, this.url.toString()});
                return new ByteArrayInputStream(BinaryUtils.getBytes((Object)data));
            }
            catch (ObjectRetrievalException e) {
                throw new DataNotFoundException(this.url, (Throwable)e);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
                throw new IOException(e);
            }
        }
    }

    protected class Handler
    extends URLStreamHandler {
        protected Handler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new DatabaseURLConnection(u);
        }
    }
}

