/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import gu.sql2java.BackupHook;
import gu.sql2java.Constant;
import gu.sql2java.EmbeddedInitException;
import gu.sql2java.InterfaceContainer;
import gu.sql2java.Managers;
import gu.sql2java.ScriptRunner;
import gu.sql2java.SimpleLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public abstract class BaseEmbeddedInitializer
implements Closeable {
    static final int DEFAULT_BACKUP_INTERVAL = 300;
    protected final boolean runInMemory;
    protected int backupIntervalSeconds = 300;
    protected final File dbroot;
    protected final File db;
    protected final Properties dbprops = new Properties();
    private final InterfaceContainer<BackupHook> backuphooks = new InterfaceContainer<BackupHook>(BackupHook.class);
    private final URL createSql;
    private long lastBackupBeginTimeMills = 0L;
    private long lastBackupEndTimeMills = 0L;
    private volatile boolean opened = false;
    private static final Map<File, BaseEmbeddedInitializer> dbs = Maps.newHashMap();

    protected BaseEmbeddedInitializer(File db, URL createSql, boolean runInMemory) {
        try {
            this.db = ((File)Preconditions.checkNotNull((Object)db, (Object)"db is null")).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Preconditions.checkArgument((this.db.exists() || null != createSql ? 1 : 0) != 0, (String)"createSql must not be null if %s not exists", (Object)this.db);
        this.createSql = createSql;
        this.dbroot = this.db.getParentFile();
        this.dbroot.mkdirs();
        this.runInMemory = runInMemory;
    }

    protected abstract void doPersist();

    protected abstract void writeDbProps(Properties var1);

    protected abstract void checkExistsDatabse(File var1) throws EmbeddedInitException;

    protected void doInitMemory() {
    }

    protected ScriptRunner normalize(ScriptRunner runner) {
        return runner;
    }

    protected List<String> afterCreateTable(ScriptRunner runner) throws SQLException {
        return Collections.emptyList();
    }

    public synchronized BaseEmbeddedInitializer init() throws EmbeddedInitException {
        if (!this.opened) {
            try {
                SimpleLog.log((String)"database location:[{}]", (Object[])new Object[]{this.db.getAbsolutePath()});
                this.createManagerInstance();
                if (this.db.exists()) {
                    this.checkExistsDatabse(this.db);
                    if (this.runInMemory) {
                        this.doInitMemory();
                    }
                } else {
                    SimpleLog.log((String)"Initializing database {}...", (Object[])new Object[]{this.db});
                    ScriptRunner runner = new ScriptRunner(false, true).setClearComment(true).setAlias(this.dbprops.getProperty(Constant.JdbcProperty.ALIAS.key));
                    this.normalize(runner).runScript(this.createSql.openStream());
                    List<String> sqls = this.afterCreateTable(runner);
                    if (!sqls.isEmpty()) {
                        runner.runScript(sqls);
                    }
                }
                if (this.runInMemory) {
                    this.startBackuper();
                }
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, EmbeddedInitException.class);
                throw new EmbeddedInitException(e);
            }
            this.opened = true;
        }
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.opened) {
            this.persist();
            this.opened = false;
        }
    }

    public InterfaceContainer<BackupHook> getBackuphookContainer() {
        return this.backuphooks;
    }

    public int getBackupIntervalSeconds() {
        return this.backupIntervalSeconds;
    }

    public BaseEmbeddedInitializer setBackupIntervalSeconds(int backupIntervalSeconds) {
        if (backupIntervalSeconds > 0) {
            this.backupIntervalSeconds = backupIntervalSeconds;
        }
        return this;
    }

    public BaseEmbeddedInitializer addProperties(Properties properties) {
        if (null != properties) {
            for (String propertyName : properties.stringPropertyNames()) {
                this.dbprops.setProperty(propertyName, properties.getProperty(propertyName));
            }
        }
        return this;
    }

    private synchronized void persist() {
        this.lastBackupBeginTimeMills = System.currentTimeMillis();
        try {
            ((BackupHook)this.backuphooks.container).onPersistDB();
            if (this.runInMemory) {
                SimpleLog.log((String)"wirte in-memory database to {}", (Object[])new Object[]{this.db.getAbsolutePath()});
                this.doPersist();
                SimpleLog.log((String)"write back success", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            SimpleLog.log((String)e.getMessage(), (Throwable)e);
        }
        finally {
            this.lastBackupEndTimeMills = System.currentTimeMillis();
        }
    }

    private void createManagerInstance() {
        this.writeDbProps(this.dbprops);
        Preconditions.checkState((null != this.dbprops.getProperty(Constant.JdbcProperty.JDBC_URL.key) ? 1 : 0) != 0, (String)"%s not defined", (Object)Constant.JdbcProperty.JDBC_URL.key);
        Managers.createInstance(this.dbprops);
    }

    private void startBackuper() {
        Thread t = new Thread("edb-backuper"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long intervalMills = TimeUnit.MILLISECONDS.convert(BaseEmbeddedInitializer.this.backupIntervalSeconds, TimeUnit.SECONDS);
                SimpleLog.log((String)"backup thread start ,interval(s) :{}", (Object[])new Object[]{BaseEmbeddedInitializer.this.backupIntervalSeconds});
                try {
                    try {
                        while (true) {
                            Thread.sleep(intervalMills);
                            if (BaseEmbeddedInitializer.this.lastBackupBeginTimeMills < BaseEmbeddedInitializer.this.lastBackupEndTimeMills) {
                                if (System.currentTimeMillis() - BaseEmbeddedInitializer.this.lastBackupEndTimeMills < intervalMills) continue;
                                BaseEmbeddedInitializer.this.persist();
                                continue;
                            }
                            if (0L == BaseEmbeddedInitializer.this.lastBackupBeginTimeMills && BaseEmbeddedInitializer.this.lastBackupBeginTimeMills == BaseEmbeddedInitializer.this.lastBackupEndTimeMills) {
                                BaseEmbeddedInitializer.this.persist();
                                continue;
                            }
                            SimpleLog.log((String)"SKIP backup because of too short interval", (Object[])new Object[0]);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        SimpleLog.log((String)"{} end (\u7ed3\u675f)", (Object[])new Object[]{Thread.currentThread().getName()});
                    }
                }
                catch (Throwable throwable) {
                    SimpleLog.log((String)"{} end (\u7ed3\u675f)", (Object[])new Object[]{Thread.currentThread().getName()});
                    throw throwable;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseEmbeddedInitializer)) {
            return false;
        }
        BaseEmbeddedInitializer other = (BaseEmbeddedInitializer)obj;
        return !(this.db == null ? other.db != null : !this.db.equals(other.db));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [runInMemory=");
        builder.append(this.runInMemory);
        builder.append(", opened=");
        builder.append(this.opened);
        builder.append(", db=");
        builder.append(this.db);
        builder.append(", dbprops=");
        builder.append(this.dbprops);
        builder.append(", createSql=");
        builder.append(this.createSql);
        builder.append("]");
        return builder.toString();
    }

    protected static synchronized <T extends BaseEmbeddedInitializer> T init(Class<T> target, File db, URL createSql, boolean runInMemory, Properties properties) {
        try {
            if (dbs.containsKey(db)) {
                return (T)dbs.get(db);
            }
            final BaseEmbeddedInitializer initializer = (BaseEmbeddedInitializer)target.getConstructor(File.class, URL.class, Boolean.TYPE).newInstance(db, createSql, runInMemory);
            initializer.addProperties(properties).init();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    initializer.close();
                }
            }, initializer.getClass().getSimpleName() + "-closer"));
            return (T)initializer;
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getTargetException());
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static <T extends BaseEmbeddedInitializer> T init(Class<T> target, String db, String createSqlURL, boolean runInMemory, Properties properties) {
        try {
            return BaseEmbeddedInitializer.init(target, new File(db), new URL(createSqlURL), runInMemory, properties);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

