/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import gu.sql2java.SimpleLog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;

public class InterfaceContainer<I> {
    private final Set<I> listeners = new LinkedHashSet<I>();
    private final Class<I> interfaceClass;
    private boolean skipOnError = true;
    private boolean logOnError = false;
    public final I container;

    public InterfaceContainer(Class<I> interfaceClass) {
        Preconditions.checkNotNull(interfaceClass, (Object)"interfaceClass is null");
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("param I must be interface");
        }
        this.interfaceClass = interfaceClass;
        this.container = this.proxyInstance();
    }

    private final I proxyInstance() {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)new Handler()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(I listener) {
        if (listener != null) {
            InterfaceContainer interfaceContainer = this;
            synchronized (interfaceContainer) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(I listener) {
        if (listener != null) {
            InterfaceContainer interfaceContainer = this;
            synchronized (interfaceContainer) {
                this.listeners.remove(listener);
            }
        }
    }

    public InterfaceContainer<I> setSkipOnError(boolean skipOnError) {
        this.skipOnError = skipOnError;
        return this;
    }

    public InterfaceContainer<I> setLogOnError(boolean logOnError) {
        this.logOnError = logOnError;
        return this;
    }

    private class Handler
    implements InvocationHandler {
        private Handler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Object listener : InterfaceContainer.this.listeners) {
                try {
                    method.invoke(listener, args);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (InterfaceContainer.this.skipOnError) {
                        if (!InterfaceContainer.this.logOnError) continue;
                        SimpleLog.log((String)("ERROR:" + te.getMessage()), (Throwable)te);
                        continue;
                    }
                    throw te;
                }
                catch (Throwable e) {
                    throw e;
                }
            }
            return null;
        }
    }
}

