/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseRow;
import gu.sql2java.Constant;
import gu.sql2java.DataSourceConfig;
import gu.sql2java.DataSourceFactory;
import gu.sql2java.ListAction;
import gu.sql2java.ListenerContainer;
import gu.sql2java.ListenerContainerLocal;
import gu.sql2java.PageQueryImplType;
import gu.sql2java.ResultSetTypeCast;
import gu.sql2java.ResultSetTypeCastSqliteImpl;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.SqlFormatter;
import gu.sql2java.SqlFormatters;
import gu.sql2java.SqlRunner;
import gu.sql2java.TableManager;
import gu.sql2java.TransactionListener;
import gu.sql2java.UnnameRow;
import gu.sql2java.UnnameRowMetaData;
import gu.sql2java.c3p0.C3p0DataSourceFactory;
import gu.sql2java.druid.DruidDataSourceFactory;
import gu.sql2java.exception.DaoException;
import gu.sql2java.exception.DataAccessException;
import gu.sql2java.exception.RuntimeDaoException;
import gu.sql2java.geometry.GeometryDataCodec;
import gu.sql2java.geometry.GeometryDataCodecs;
import gu.sql2java.pagehelper.Page;
import gu.sql2java.pagehelper.PageHelper;
import gu.sql2java.parser.ParserSupport;
import gu.sql2java.parser.SqlSyntaxNormalizer;
import gu.sql2java.parser.SqlSyntaxNormalizers;
import gu.sql2java.parser.StatementCache;
import gu.sql2java.sqlite.SqliteDataSourceFactory;
import gu.sql2java.utils.JDBCUtility;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;

final class Manager
implements Constant,
SqlRunner {
    static final Map<String, Manager> managers = new Hashtable<String, Manager>();
    static final Map<String, Manager> aliasManagers = new Hashtable<String, Manager>();
    private final ThreadLocal<Connection> transactionConnection = new ThreadLocal();
    private final ThreadLocal<Connection> localConnection = new ThreadLocal();
    private final ThreadLocal<Integer> nestedCount = new ThreadLocal();
    private volatile DataSource dataSource = null;
    private volatile AutoKeyRetrieveType retrieveType;
    private volatile ResultSetTypeCast extensiveResultSetTypeCast;
    private volatile DataSourceFactory dataSourceFactory;
    private volatile String productName;
    private volatile DatabaseMetaData databaseMetaData;
    private volatile StatementCache statementCache;
    private volatile GeometryDataCodec geometryDataCodec;
    final DataSourceConfig config;
    private static final ImmutableMap<String, String> AUTOINC_MECHANISM = ImmutableMap.builder().put((Object)"hsql.generatedkey.retrieve", (Object)"after").put((Object)"hsql.generatedkey.statement", (Object)"CALL IDENTITY()").put((Object)"oracle.generatedkey.retrieve", (Object)"before").put((Object)"oracle.generatedkey.statement", (Object)"SELECT SEQ_<TABLE>.nextval FROM DUAL").put((Object)"maxdb.generatedkey.retrieve", (Object)"before").put((Object)"maxdb.generatedkey.statement", (Object)"SELECT SEQ_<TABLE>_<KEY>.nextval FROM DUAL").put((Object)"mysql.generatedkey.retrieve", (Object)"after").put((Object)"mysql.generatedkey.statement", (Object)"SELECT last_insert_id()").put((Object)"mysql.page.query", (Object)"LIMIT_OFFSET").put((Object)"sqlserver.generatedkey.retrieve", (Object)"after").put((Object)"sqlserver.generatedkey.statement", (Object)"SELECT @@IDENTITY").put((Object)"sqlserver.page.query", (Object)"OFFSET_FETCH").put((Object)"sybase.generatedkey.retrieve", (Object)"after").put((Object)"sybase.generatedkey.statement", (Object)"SELECT @@IDENTITY").put((Object)"postgresql.generatedkey.retrieve", (Object)"before").put((Object)"postgresql.generatedkey.statement", (Object)"SELECT nextval('<TABLE>_<KEY>_SEQ')").put((Object)"postgresql.page.query", (Object)"LIMIT_OFFSET").put((Object)"informix.generatedkey.retrieve", (Object)"after").put((Object)"informix.generatedkey.statement", (Object)"SELECT dbinfo('sqlca.sqlerrd1') FROM systables WHERE tabid=1").put((Object)"firebird.generatedkey.retrieve", (Object)"before").put((Object)"firebird.generatedkey.statement", (Object)"SELECT GEN_ID(SEQ_<TABLE>, 1) FROM RDB$DATABASE").put((Object)"derby.generatedkey.retrieve", (Object)"after").put((Object)"derby.generatedkey.statement", (Object)"VALUES IDENTITY_VAL_LOCAL()").put((Object)"sqlite.page.query", (Object)"LIMIT_OFFSET").put((Object)"phoenix.generatedkey.retrieve", (Object)"before").put((Object)"phoenix.generatedkey.statement", (Object)"SELECT NEXT VALUE FOR SEQ_<TABLE>_<KEY>").put((Object)"phoenix.insert.values", (Object)"false").put((Object)"phoenix.page.query", (Object)"LIMIT_OFFSET").build();
    private static final ThreadLocal<LocalFillPreparedStatementArgs> localFillPreparedStatementArgs = new ThreadLocal();

    private Manager() {
        this(new DataSourceConfig());
    }

    Manager(Properties databaseProperties) {
        this(DataSourceConfig.createConfig(databaseProperties));
    }

    Manager(DataSourceConfig config) {
        this.config = config;
        managers.put((String)Preconditions.checkNotNull((Object)config.jdbcUrl, (Object)"jdbcUrl is null"), this);
        aliasManagers.put(this.config.alias, this);
    }

    static Manager getInstance() {
        return Singleton.INSTANCE;
    }

    void disposePool() {
        if (null != this.dataSourceFactory) {
            this.dataSourceFactory.destroy(this.dataSource);
            this.dataSourceFactory = null;
            this.dataSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceFactory getDataSourceFactory() {
        if (null == this.dataSourceFactory) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.dataSourceFactory) {
                    switch (this.config.dataSource) {
                        case "SQLITE": {
                            this.dataSourceFactory = new SqliteDataSourceFactory();
                            break;
                        }
                        case "C3P0": {
                            this.dataSourceFactory = new C3p0DataSourceFactory();
                            break;
                        }
                        case "DRUID": {
                            this.dataSourceFactory = new DruidDataSourceFactory();
                            break;
                        }
                        default: {
                            throw new RuntimeException("UNSUPPORT DATA SOURCE TYPE:" + this.config.dataSource);
                        }
                    }
                }
            }
        }
        return this.dataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseMetaData getDatabaseMetaData(Connection c) throws SQLException {
        if (null == this.databaseMetaData) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.databaseMetaData) {
                    this.databaseMetaData = c.getMetaData();
                    this.productName = this.databaseMetaData.getDatabaseProductName();
                }
            }
        }
        return this.databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseMetaData getDatabaseMetaData() throws RuntimeDaoException {
        if (null == this.databaseMetaData) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.databaseMetaData) {
                    try {
                        this.initDataSourceLazy();
                    }
                    catch (SQLException e) {
                        throw new RuntimeDaoException((Throwable)e);
                    }
                }
            }
        }
        return this.databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProductName() throws RuntimeDaoException {
        if (null == this.productName) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.productName) {
                    this.getDatabaseMetaData();
                }
            }
        }
        return this.productName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementCache getStatementCache() {
        if (null == this.statementCache) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.statementCache) {
                    SqlFormatter sqlFormatter = SqlFormatters.formatterOf(this.getProductName());
                    SqlSyntaxNormalizer normalizer = SqlSyntaxNormalizers.normalizerOf(this.getProductName());
                    this.statementCache = new StatementCache(sqlFormatter, normalizer);
                }
            }
        }
        return this.statementCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeometryDataCodec getGeometryDataCodec() {
        if (null == this.geometryDataCodec) {
            Manager manager = this;
            synchronized (manager) {
                if (null == this.geometryDataCodec) {
                    this.geometryDataCodec = GeometryDataCodecs.getGeometryDataCodec((String)this.getProductName());
                }
            }
        }
        return this.geometryDataCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataSourceLazy() throws SQLException, RuntimeDaoException {
        if (this.dataSource == null) {
            Manager manager = this;
            synchronized (manager) {
                if (this.dataSource == null) {
                    try {
                        this.dataSource = this.getDataSourceFactory().createDataSource(this.config);
                        try (Connection c = this.getConnection0();){
                            if ("SQLite".equals(this.getDatabaseMetaData(c).getDatabaseProductName())) {
                                this.extensiveResultSetTypeCast = ResultSetTypeCastSqliteImpl.SQLITE_CAST;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        Throwables.throwIfInstanceOf((Throwable)e, RuntimeDaoException.class);
                        throw new RuntimeDaoException((Throwable)e);
                    }
                }
            }
        }
    }

    void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.setDataSource(null);
    }

    private Connection getConnection0() throws SQLException {
        return this.dataSource.getConnection();
    }

    Connection getConnection() throws SQLException {
        Connection tc = this.transactionConnection.get();
        if (tc != null) {
            return tc;
        }
        Connection c = this.localConnection.get();
        if (null != c) {
            this.nestedCount.set(this.nestedCount.get() + 1);
            return c;
        }
        this.initDataSourceLazy();
        c = this.getConnection0();
        this.localConnection.set(c);
        this.nestedCount.set(0);
        return c;
    }

    void releaseConnection(Connection c) {
        Connection tc = this.transactionConnection.get();
        if (tc != null) {
            return;
        }
        if (c == this.localConnection.get()) {
            if (null != this.nestedCount.get() && this.nestedCount.get() > 0) {
                this.nestedCount.set(this.nestedCount.get() - 1);
                return;
            }
            this.nestedCount.remove();
            this.localConnection.remove();
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
    }

    private Connection beginTransaction() throws SQLException {
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        this.transactionConnection.set(c);
        return c;
    }

    private void endTransaction(boolean commit) throws SQLException {
        Connection c = this.transactionConnection.get();
        if (c == null) {
            return;
        }
        try {
            if (commit) {
                c.commit();
            } else {
                c.rollback();
            }
        }
        finally {
            c.setAutoCommit(true);
            this.transactionConnection.remove();
            this.releaseConnection(c);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T runAsTransaction(Callable<T> fun, TransactionListener transactionListener) throws RuntimeDaoException {
        Preconditions.checkArgument((fun != null ? 1 : 0) != 0, (Object)"fun is null");
        Preconditions.checkArgument((null != transactionListener ? 1 : 0) != 0, (Object)"transactionListener is null");
        try {
            this.beginTransaction();
            transactionListener.onBegin();
            boolean commit = false;
            try {
                T result = fun.call();
                commit = true;
                transactionListener.onCommit();
                T t = result;
                return t;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.endTransaction(commit);
                transactionListener.onEnd();
            }
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
    }

    void runAsTransaction(final Runnable fun, TransactionListener transactionListener) throws RuntimeDaoException {
        Preconditions.checkArgument((fun != null ? 1 : 0) != 0, (Object)"fun is null");
        this.runAsTransaction(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                fun.run();
                return null;
            }
        }, transactionListener);
    }

    public <T> T runAsTransaction(Callable<T> fun) throws RuntimeDaoException {
        return this.runAsTransaction(fun, (TransactionListener)ListenerContainerLocal.TRANSACTION_LISTENER);
    }

    public void runAsTransaction(Runnable fun) throws RuntimeDaoException {
        this.runAsTransaction(fun, (TransactionListener)ListenerContainerLocal.TRANSACTION_LISTENER);
    }

    public <T> T runWithNoPage(Callable<T> fun) throws RuntimeDaoException {
        Preconditions.checkArgument((fun != null ? 1 : 0) != 0, (Object)"fun is null");
        Page page = PageHelper.getLocalPage();
        boolean enable = false;
        if (null != page && (enable = page.isEnable())) {
            PageHelper.setEnable((boolean)false);
        }
        try {
            T t = fun.call();
            return t;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, RuntimeDaoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeDaoException((Throwable)e);
        }
        finally {
            if (null != page && enable) {
                PageHelper.setEnable((boolean)enable);
            }
        }
    }

    public void runWithNoPage(final Runnable fun) throws RuntimeDaoException {
        if (null != fun) {
            this.runWithNoPage(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    fun.run();
                    return false;
                }
            });
        }
    }

    void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException x) {
            SimpleLog.log((String)("Could not close statement!: " + x.toString()), (Object[])new Object[0]);
        }
    }

    void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException x) {
            SimpleLog.log((String)("Could not close result set!: " + x.toString()), (Object[])new Object[0]);
        }
    }

    void close(Statement s, ResultSet rs) {
        this.close(rs);
        this.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    private static void setBytes(int sqlType, PreparedStatement ps, int pos, ByteBuffer bytes) throws SQLException {
        Manager.setBytes(sqlType, ps, pos, Manager.getBytesInBuffer(bytes));
    }

    private static void setBytes(int sqlType, PreparedStatement ps, int pos, byte[] bytes) throws SQLException {
        if (null == bytes) {
            ps.setNull(pos, sqlType);
        } else {
            ps.setBytes(pos, bytes);
        }
    }

    static Calendar getCalendar(ResultSet rs, int pos) throws SQLException {
        Timestamp date = rs.getTimestamp(pos);
        if (rs.wasNull()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    static Calendar getCalendar(ResultSet rs, String column) throws SQLException {
        Timestamp date = rs.getTimestamp(column);
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    static void setCalendar(PreparedStatement ps, int pos, Calendar calendar) throws SQLException {
        if (calendar == null) {
            ps.setNull(pos, 93);
        } else {
            ps.setTimestamp(pos, new Timestamp(calendar.getTimeInMillis()));
        }
    }

    <T> T getObject(ResultSet rs, int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Type parameter can not be null");
        }
        Object t = null;
        if (type.equals(String.class)) {
            t = rs.getString(columnIndex);
        } else if (type.equals(BigDecimal.class)) {
            t = rs.getBigDecimal(columnIndex);
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            t = rs.getBoolean(columnIndex);
        } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            t = rs.getByte(columnIndex);
        } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            t = rs.getShort(columnIndex);
        } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            t = rs.getInt(columnIndex);
        } else if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            t = rs.getLong(columnIndex);
        } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            t = Float.valueOf(rs.getFloat(columnIndex));
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            t = rs.getDouble(columnIndex);
        } else if (type.equals(byte[].class)) {
            t = rs.getBytes(columnIndex);
        } else if (type.equals(ByteBuffer.class)) {
            byte[] array = rs.getBytes(columnIndex);
            t = array == null ? null : ByteBuffer.wrap(array);
        } else if (type.equals(Date.class)) {
            t = rs.getDate(columnIndex);
        } else if (type.equals(Time.class)) {
            t = rs.getTime(columnIndex);
        } else if (type.equals(Timestamp.class)) {
            t = rs.getTimestamp(columnIndex);
        } else if (type.equals(Calendar.class)) {
            java.util.Date date = (java.util.Date)rs.getObject(columnIndex);
            if (date == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            t = calendar;
        } else if (type.equals(Clob.class)) {
            t = rs.getClob(columnIndex);
        } else if (type.equals(Blob.class)) {
            t = rs.getBlob(columnIndex);
        } else if (type.equals(Array.class)) {
            t = rs.getArray(columnIndex);
        } else if (type.equals(Ref.class)) {
            t = rs.getRef(columnIndex);
        } else if (type.equals(URL.class)) {
            t = rs.getURL(columnIndex);
        } else if (Geometry.class.isAssignableFrom(type)) {
            t = this.getGeometryDataCodec().readGeometryData(rs, columnIndex);
        } else {
            Object obj = rs.getObject(columnIndex);
            try {
                t = type.cast(obj);
            }
            catch (ClassCastException e) {
                if (null != this.extensiveResultSetTypeCast) {
                    try {
                        t = this.extensiveResultSetTypeCast.cast(obj, type);
                    }
                    catch (ClassCastException e2) {
                        throw new SQLException("Conversion not supported for type " + type.getName(), e2);
                    }
                }
                throw new SQLException("Conversion not supported for type " + type.getName(), e);
            }
        }
        return (T)(rs.wasNull() ? null : t);
    }

    static String buildProcedureCall(String packageName, String procedureName, int paramCount) {
        return Manager.buildProcedureCall(packageName + "." + procedureName, paramCount);
    }

    static String buildProcedureCall(String procedureName, int paramCount) {
        StringBuilder sb = new StringBuilder("{call ").append(procedureName).append("(");
        for (int n = 1; n <= paramCount; ++n) {
            sb.append("?,");
        }
        if (paramCount > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.append(")}").toString();
    }

    int runPreparedStatementAsList(Map<String, Class<?>> targetTypes, PreparedStatement ps, TableManager.Action<BaseBean> action) {
        Preconditions.checkArgument((null != ps ? 1 : 0) != 0, (Object)"ps is null");
        Preconditions.checkArgument((null != action ? 1 : 0) != 0, (Object)"action is null");
        ResultSet rs = null;
        try {
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            UnnameRowMetaData metaData = new UnnameRowMetaData(rs.getMetaData(), targetTypes);
            int count = 0;
            while (rs.next()) {
                UnnameRow row = new UnnameRow((RowMetaData)metaData);
                for (int i = 0; i < metaData.defaultColumnIdList.length; ++i) {
                    row.setValue(i, this.getObject(rs, i + 1, metaData.fieldTypeOf(i)));
                }
                action.call((Object)row);
                ++count;
            }
            int n = count;
            this.close(rs);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
            }
            catch (Throwable throwable) {
                this.close(rs);
                throw throwable;
            }
        }
    }

    List<BaseBean> runPreparedStatementAsList(Map<String, Class<?>> targetTypes, PreparedStatement ps) {
        ListAction<BaseBean> action = new ListAction<BaseBean>();
        this.runPreparedStatementAsList(targetTypes, ps, action);
        return action.getList();
    }

    public List<BaseBean> runSqlAsList(Map<String, Class<?>> targetTypes, String sql, Object ... argList) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)"sql is null or empty");
        PreparedStatement ps = null;
        Connection c = null;
        try {
            c = this.getConnection();
            AtomicLong count = new AtomicLong(-1L);
            sql = this.getStatementCache().normalize(sql, true);
            String wrapped = this.rebuildSelectSql(c, sql, argList, 1, -1, count, DataSourceConfig.isDebugOutput());
            if (0L == count.get()) {
                List<BaseBean> list = new ListAction().getList();
                return list;
            }
            sql = (String)MoreObjects.firstNonNull((Object)wrapped, (Object)sql);
            ps = this.getStatementCache().prepareStatement(c, sql, false, DataSourceConfig.isDebugOutput(), "runSqlAsList", 1003, 1007);
            this.fillPrepareStatement(ps, argList);
            List<BaseBean> list = this.runPreparedStatementAsList(targetTypes, ps);
            this.close(ps);
            this.releaseConnection(c);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)new DataAccessException((Throwable)e));
        }
        finally {
            this.close(ps);
            this.releaseConnection(c);
        }
    }

    public List<Map<String, Object>> runSqlForMap(Map<String, Class<?>> targetTypes, String sql, Object ... argList) throws RuntimeDaoException {
        List<BaseBean> list = this.runSqlAsList(targetTypes, sql, argList);
        return new ArrayList<Map<String, Object>>(Lists.transform(list, input -> null == input ? null : new HashMap(input.asNameValueMap())));
    }

    private <T> List<T> fetchOnlyOneColumn(List<BaseBean> list, Class<T> targetType) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        BaseBean row = list.get(0);
        Object[] values = row.asValueArray(new int[0]);
        Preconditions.checkArgument((values.length == 1 ? 1 : 0) != 0, (Object)"more than  1 column returned");
        if (null == targetType) {
            return new ArrayList(Lists.transform(list, input -> null == input ? null : input.getValue(0)));
        }
        return new ArrayList(Lists.transform(list, input -> null == input ? null : targetType.cast(input.getValue(0))));
    }

    <T> List<T> runPreparedStatementAsList(Class<T> targetType, PreparedStatement ps) throws RuntimeDaoException {
        List<BaseBean> list = this.runPreparedStatementAsList((Map)null, ps);
        return this.fetchOnlyOneColumn(list, targetType);
    }

    public List<BaseBean> runSqlAsList(String sql, Object ... argList) throws RuntimeDaoException {
        return this.runSqlAsList(Collections.emptyMap(), sql, argList);
    }

    public <T> List<T> runSqlAsList(Class<T> targetType, String sql, Object ... argList) throws RuntimeDaoException {
        List<BaseBean> list = this.runSqlAsList((Map)null, sql, argList);
        return this.fetchOnlyOneColumn(list, targetType);
    }

    public <T> T runSqlForValue(Class<T> targetType, String sql, Object ... argList) throws RuntimeDaoException {
        List<T> list = this.runSqlAsList(targetType, sql, argList);
        Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (String)"more than  1 row returned for SQL: %s", (Object)sql);
        return list.get(0);
    }

    public boolean runSql(String sql, Object[] argList) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)"sql is null or empty");
        if (DataSourceConfig.isDebugOutput()) {
            SimpleLog.log((String)("runSql:" + sql), (Object[])new Object[0]);
        }
        PreparedStatement ps = null;
        Connection c = null;
        try {
            c = this.getConnection();
            ps = this.getStatementCache().prepareStatement(c, sql, true, DataSourceConfig.isDebugOutput(), "runSql");
            this.fillPrepareStatement(ps, argList);
            boolean bl = ps.execute();
            this.close(ps);
            this.releaseConnection(c);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.releaseConnection(c);
                throw throwable;
            }
        }
    }

    public int runSql(String sql) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)"sql is null or empty");
        if (DataSourceConfig.isDebugOutput()) {
            SimpleLog.log((String)("runSql:" + sql), (Object[])new Object[0]);
        }
        Statement stat = null;
        Connection c = null;
        try {
            c = this.getConnection();
            stat = c.createStatement();
            int n = stat.executeUpdate(sql);
            this.close(stat);
            this.releaseConnection(c);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeDaoException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(stat);
                this.releaseConnection(c);
                throw throwable;
            }
        }
    }

    public long rowCountOf(String sql) throws RuntimeDaoException {
        Connection c = null;
        try {
            c = this.getConnection();
            long l = this.rowCountOf(c, sql, null, null, DataSourceConfig.isDebugOutput(), true);
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    <T> T runPreparedStatementForValue(Class<T> targetType, PreparedStatement ps) throws RuntimeDaoException {
        return (T)this.runWithNoPage(() -> {
            List list = this.runPreparedStatementAsList(targetType, ps);
            Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (Object)"more than  1 row or none row returned");
            return list.get(0);
        });
    }

    protected void fillPrepareStatement(PreparedStatement ps, Object[] argList) throws SQLException {
        if (argList != null && ps != null) {
            for (int i = 0; i < argList.length; ++i) {
                if (argList[i] instanceof ByteBuffer) {
                    ps.setBytes(i + 1, Manager.getBytesInBuffer((ByteBuffer)argList[i]));
                }
                if (argList[i] instanceof Geometry) {
                    ps.setBytes(i + 1, this.getGeometryDataCodec().toWKB(argList[i]));
                    continue;
                }
                ps.setObject(i + 1, argList[i]);
            }
        }
    }

    protected void fillPreparedStatement(PreparedStatement ps, int pos, Object value, int sqlType, String columnTypeName) throws SQLException {
        if (value instanceof ByteBuffer) {
            Manager.setBytes(sqlType, ps, pos, (ByteBuffer)value);
        } else if (this.getGeometryDataCodec().isGeometryDataType(columnTypeName)) {
            if (sqlType == 1111) {
                Manager.setBytes(sqlType, ps, pos, this.getGeometryDataCodec().toWKB(value));
            } else if (String.class.equals((Object)JDBCUtility.getJavaClass((int)sqlType))) {
                try {
                    ps.setObject(pos, (Object)this.getGeometryDataCodec().toWKT(value), sqlType);
                }
                catch (ParseException e) {
                    throw new SQLException(e);
                }
            } else {
                ps.setObject(pos, value, sqlType);
            }
        } else {
            ps.setObject(pos, value, sqlType);
        }
    }

    private static final String getMechanismPropertyWithSuffix(String productName, String suffix) {
        StringTokenizer token = new StringTokenizer(productName);
        while (token.hasMoreTokens()) {
            String value = (String)AUTOINC_MECHANISM.get((Object)(token.nextToken().toLowerCase() + "." + suffix));
            if (value == null) continue;
            return value;
        }
        throw new NullPointerException(String.format("NOT FOUND %s property for %s database", suffix, productName));
    }

    private synchronized void autokeyMechanismInit() throws SQLException {
        if (this.getDatabaseMetaData().supportsGetGeneratedKeys()) {
            this.config.generatedkeyRetrieve = "auto";
            this.config.generatedkeyStatement = null;
        } else {
            this.config.generatedkeyRetrieve = Manager.getMechanismPropertyWithSuffix(this.getProductName(), "generatedkey.retrieve").toLowerCase();
            this.config.generatedkeyStatement = Manager.getMechanismPropertyWithSuffix(this.getProductName(), "generatedkey.statement");
        }
    }

    private void initPageQueryImplType() {
        this.config.pageQueryImplType = PageQueryImplType.NO_IMPL;
        try {
            this.config.pageQueryImplType = PageQueryImplType.valueOf(Manager.getMechanismPropertyWithSuffix(this.getProductName(), "page.query").toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PageQueryImplType getPageQueryImplType() {
        if (this.config.pageQueryImplType == null) {
            Manager manager = this;
            synchronized (manager) {
                if (this.config.pageQueryImplType == null) {
                    this.initPageQueryImplType();
                }
            }
        }
        return this.config.pageQueryImplType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getGeneratedkeyRetrieve() throws SQLException {
        if (this.config.generatedkeyRetrieve == null) {
            Manager manager = this;
            synchronized (manager) {
                if (this.config.generatedkeyRetrieve == null) {
                    this.autokeyMechanismInit();
                }
            }
        }
        return this.config.generatedkeyRetrieve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSupportInsertValues() throws SQLException {
        if (this.config.supportInsertValues == null) {
            Manager manager = this;
            synchronized (manager) {
                if (this.config.supportInsertValues == null) {
                    this.config.supportInsertValues = true;
                    try {
                        this.config.supportInsertValues = Boolean.valueOf(Manager.getMechanismPropertyWithSuffix(this.getProductName(), "insert.values").toLowerCase());
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.config.supportInsertValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AutoKeyRetrieveType getGeneratedkeyRetrieveType() throws SQLException {
        if (this.retrieveType == null) {
            Manager manager = this;
            synchronized (manager) {
                if (this.retrieveType == null) {
                    this.retrieveType = AutoKeyRetrieveType.valueOf(this.getGeneratedkeyRetrieve());
                }
            }
        }
        return this.retrieveType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getGeneratedkeyStatement() {
        if (this.config.generatedkeyStatement == null && !AutoKeyRetrieveType.auto.equals((Object)this.retrieveType)) {
            Manager manager = this;
            synchronized (manager) {
                if (this.config.generatedkeyStatement == null && !AutoKeyRetrieveType.auto.equals((Object)this.retrieveType)) {
                    try {
                        this.autokeyMechanismInit();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.config.generatedkeyStatement;
    }

    ListenerContainer.FireType getFireType() {
        return this.config.fireType;
    }

    int fillPreparedStatement(RowMetaData metaData, PreparedStatement ps, BaseBean bean, int searchType, boolean fillNull, boolean checkModified, int[] fieldList, int dirtyCount) throws DaoException {
        if (bean == null) {
            return 0;
        }
        try {
            block8: for (int columnId : fieldList = (int[])MoreObjects.firstNonNull((Object)fieldList, (Object)metaData.defaultColumnIdList)) {
                Object value = bean.getJdbcValue(columnId);
                if (null == value && !fillNull || checkModified && !bean.isModified(columnId)) continue;
                if (String.class == metaData.columnTypeOf(columnId)) {
                    switch (searchType) {
                        case 0: {
                            this.fillPreparedStatement(ps, ++dirtyCount, value, metaData.sqlTypes[columnId], (String)metaData.columnTypeNames.get(columnId));
                            continue block8;
                        }
                        case 1: {
                            this.fillPreparedStatement(ps, ++dirtyCount, "%" + value + "%", metaData.sqlTypes[columnId], (String)metaData.columnTypeNames.get(columnId));
                            continue block8;
                        }
                        case 2: {
                            this.fillPreparedStatement(ps, ++dirtyCount, "%" + value, metaData.sqlTypes[columnId], (String)metaData.columnTypeNames.get(columnId));
                            continue block8;
                        }
                        case 3: {
                            this.fillPreparedStatement(ps, ++dirtyCount, value + "%", metaData.sqlTypes[columnId], (String)metaData.columnTypeNames.get(columnId));
                            continue block8;
                        }
                        default: {
                            throw new DaoException("Unknown search type : " + searchType);
                        }
                    }
                }
                this.fillPreparedStatement(ps, ++dirtyCount, value, metaData.sqlTypes[columnId], (String)metaData.columnTypeNames.get(columnId));
            }
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        return dirtyCount;
    }

    static void setLocalfillPreparedStatement(BaseRow bean, int searchType, boolean fillNull) {
        localFillPreparedStatementArgs.set(new LocalFillPreparedStatementArgs(bean, searchType, fillNull));
    }

    static void removeLocalfillPreparedStatement() {
        localFillPreparedStatementArgs.remove();
    }

    private void localFillPreparedStatement(PreparedStatement ps) throws DaoException {
        LocalFillPreparedStatementArgs args = localFillPreparedStatementArgs.get();
        if (null != args) {
            this.fillPreparedStatement(args.bean.metaData, ps, (BaseBean)args.bean, args.searchType, args.fillNull, true, null, 0);
        }
    }

    String rebuildSelectSql(Connection c, String sql, Object[] argList, Integer startRow, Integer numRows, AtomicLong count, boolean debug) throws SQLException {
        if (null != sql) {
            Page page;
            startRow = (Integer)MoreObjects.firstNonNull((Object)startRow, (Object)1);
            numRows = (Integer)MoreObjects.firstNonNull((Object)numRows, (Object)-1);
            PageQueryImplType pageQueryImplType = this.getPageQueryImplType();
            String wrapped = pageQueryImplType.wrap(sql, startRow, numRows);
            if (null != wrapped && null != (page = PageHelper.getLocalPage()) && page.isEnable() && page.isCount()) {
                long total = this.rowCountOf(c, wrapped, argList, page.getCountColumn(), debug, false);
                page.setTotal(total);
                if (null != count) {
                    count.set(total);
                }
            }
            return wrapped;
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long rowCountOf(Connection c, String sql, Object[] argList, String countColumn, boolean debug, boolean injectAnalyze) throws SQLException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)"sql is null or empty");
        String countSql = ParserSupport.countSql(sql, countColumn);
        PreparedStatement ps = null;
        try {
            ps = this.getStatementCache().prepareStatement(c, countSql, injectAnalyze, debug, "rowCountOf", 1003, 1007);
            this.fillPrepareStatement(ps, argList);
            this.localFillPreparedStatement(ps);
            long l = this.runPreparedStatementForValue(Long.class, ps);
            this.close(ps);
            return l;
        }
        catch (Throwable throwable) {
            this.close(ps);
            throw throwable;
        }
    }

    static class LocalFillPreparedStatementArgs {
        BaseRow bean;
        int searchType;
        boolean fillNull;

        public LocalFillPreparedStatementArgs(BaseRow bean, int searchType, boolean fillNull) {
            this.bean = bean;
            this.searchType = searchType;
            this.fillNull = fillNull;
        }
    }

    static enum AutoKeyRetrieveType {
        auto,
        after,
        before;

    }

    private static class Singleton {
        private static final Manager INSTANCE = new Manager();

        private Singleton() {
        }
    }
}

