/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.CacheManager;
import gu.sql2java.ColumnCache;
import gu.sql2java.Constant;
import gu.sql2java.DataSourceConfig;
import gu.sql2java.Manager;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.SqlRunner;
import gu.sql2java.TableManager;
import gu.sql2java.TableManagerDecorator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class Managers
implements Constant {
    private static boolean debug = false;
    private static final ImmutableMap<String, TableManager<? extends BaseBean>> tableManagerInstances = Managers.loadTableManager();
    private static final ImmutableMap<Class<?>, TableManager<? extends BaseBean>> tableManagerTypeMaps = Managers.asTypeMap(tableManagerInstances);
    private static final ImmutableMap<Class<?>, TableManager<? extends BaseBean>> tableManagerBeanTypeMaps = Managers.asBeanTypeMap(tableManagerInstances);
    private static final Map<Class<?>, TableManager<? extends BaseBean>> cacheManagers = Maps.newHashMap();
    private static final Map<Class<?>, TableManager<? extends BaseBean>> cacheBeanTypeManagers = Maps.newHashMap();
    private static final Map<String, TableManager<? extends BaseBean>> cacheNameManagers = Maps.newHashMap();

    private Managers() {
    }

    public static ImmutableMap<String, TableManager<? extends BaseBean>> getTableManagers() {
        return tableManagerInstances;
    }

    private static ImmutableMap<String, TableManager<? extends BaseBean>> loadTableManager() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RowMetaData data : RowMetaData.tableMetadata.values()) {
            try {
                TableManager manager = TableManagerDecorator.makeInterfaceInstance(new BaseTableManager(data.tablename));
                builder.put((Object)data.tablename, manager);
                if (!debug) continue;
                SimpleLog.log((String)"TableManagerDecorator instance create for {} ", (Object[])new Object[]{data.tablename});
            }
            catch (RuntimeException e) {
                if (!debug) continue;
                SimpleLog.log((String)"FAIL TO create manager for  {} caused by {}", (Object[])new Object[]{data.tablename, e.getMessage()});
            }
        }
        return builder.build();
    }

    private static final ImmutableMap<Class<?>, TableManager<? extends BaseBean>> asTypeMap(Map<String, TableManager<? extends BaseBean>> input) {
        return Maps.uniqueIndex(input.values(), (Function)new Function<TableManager<? extends BaseBean>, Class<?>>(){

            public Class<?> apply(TableManager<? extends BaseBean> input) {
                for (Class<?> clazz : input.getClass().getInterfaces()) {
                    if (!TableManager.class.isAssignableFrom(clazz)) continue;
                    return clazz;
                }
                throw new IllegalStateException(SimpleLog.logString((String)"NOT FOUND immplements interface class for %s ", (Object[])new Object[]{input.getClass()}));
            }
        });
    }

    private static final ImmutableMap<Class<?>, TableManager<? extends BaseBean>> asBeanTypeMap(Map<String, TableManager<? extends BaseBean>> input) {
        return Maps.uniqueIndex(input.values(), (Function)new Function<TableManager<? extends BaseBean>, Class<?>>(){

            public Class<?> apply(TableManager<? extends BaseBean> input) {
                if (input instanceof BaseTableManager) {
                    return ((BaseTableManager)input).metaData.beanType;
                }
                if (Proxy.isProxyClass(input.getClass())) {
                    InvocationHandler handler = Proxy.getInvocationHandler(input);
                    Preconditions.checkArgument((boolean)(handler instanceof TableManagerDecorator), (String)"UNKNOW HANDLER %s", handler.getClass());
                    return ((TableManagerDecorator)handler).metaData.beanType;
                }
                throw new IllegalArgumentException(SimpleLog.logString((String)"UNKNOW SUPPORTED TableManager instance %s", (Object[])new Object[]{input.getClass()}));
            }
        });
    }

    public static final <M extends TableManager<?>> M getTableManager(Class<M> interfaceClass) {
        TableManager manager = (TableManager)tableManagerTypeMaps.get(interfaceClass);
        return (M)((TableManager)Preconditions.checkNotNull((Object)manager, (String)"INVALID manager type %s", interfaceClass));
    }

    public static final <T extends BaseBean, M extends TableManager<T>> M getTableManagerByBeanType(Class<T> beanType) {
        TableManager manager = (TableManager)tableManagerBeanTypeMaps.get(beanType);
        return (M)((TableManager)Preconditions.checkNotNull((Object)manager, (String)"INVALID bean type %s", beanType));
    }

    public static final <M extends TableManager<?>> M getTableManager(String tablename) {
        TableManager manager = (TableManager)tableManagerInstances.get((Object)tablename);
        return (M)((TableManager)Preconditions.checkNotNull((Object)manager, (String)"INVALID tablename %s", (Object)tablename));
    }

    public static final <M extends BaseTableManager<?>> M getBaseTableManager(String tablename) {
        return (M)Managers.baseManagerOf(Managers.getTableManager(tablename));
    }

    public static final synchronized <I extends TableManager<?>> void registerCacheManager(String tablename, Constant.UpdateStrategy updateStrategy, long maximumSize, long duration, TimeUnit unit) {
        TableManager<?> cacheManager = CacheManager.makeCacheInstance(tablename, updateStrategy, maximumSize, duration, unit);
        BaseTableManager<?> manager = Managers.baseManagerOf(cacheManager);
        cacheManagers.put(manager.metaData.managerInterfaceClass, cacheManager);
        cacheNameManagers.put(manager.metaData.tablename, cacheManager);
        cacheBeanTypeManagers.put(manager.metaData.beanType, cacheManager);
        if (debug) {
            SimpleLog.log((String)"REGISTER CACHE MANAGER {}", (Object[])new Object[]{cacheManager});
        }
    }

    public static Map<Class<?>, TableManager<? extends BaseBean>> getCacheManagers() {
        return Collections.unmodifiableMap(cacheManagers);
    }

    public static final <M extends TableManager<? extends BaseBean>> M getCacheManager(final Class<M> interfaceClass) throws NoSuchElementException {
        Preconditions.checkArgument((interfaceClass != null ? 1 : 0) != 0, (Object)"targetType is null");
        TableManager<? extends BaseBean> manager = cacheManagers.get(interfaceClass);
        if (null != manager) {
            return (M)manager;
        }
        return (M)((TableManager)Iterables.find(cacheManagers.values(), (Predicate)new Predicate<TableManager<?>>(){

            public boolean apply(TableManager<?> input) {
                return interfaceClass.isInstance(input);
            }
        }));
    }

    public static final <B extends BaseBean> TableManager<B> getCacheManagerByBeanType(Class<?> beanType) {
        TableManager<? extends BaseBean> manager = cacheBeanTypeManagers.get(beanType);
        return (TableManager)Preconditions.checkNotNull(manager, (String)"INVALID bean type %s", beanType);
    }

    public static final <B extends BaseBean> TableManager<B> getCacheManager(String tablename) {
        TableManager<? extends BaseBean> manager = cacheNameManagers.get(tablename);
        return (TableManager)Preconditions.checkNotNull(manager, (String)"INVALID table name %s", (Object)tablename);
    }

    public static final CacheManager getCacheManagerByBeanTypeOrNull(Class<?> beanType) {
        TableManager<? extends BaseBean> manager = cacheBeanTypeManagers.get(beanType);
        if (null != manager) {
            TableManagerDecorator handler = (TableManagerDecorator)Proxy.getInvocationHandler(manager);
            return (CacheManager)handler.delegate;
        }
        return null;
    }

    public static final CacheManager getCacheManagerOrNull(String tablename) {
        TableManager<? extends BaseBean> manager = cacheNameManagers.get(tablename);
        if (null != manager) {
            TableManagerDecorator handler = (TableManagerDecorator)Proxy.getInvocationHandler(manager);
            return (CacheManager)handler.delegate;
        }
        return null;
    }

    public static <M extends TableManager<? extends BaseBean>> M instanceOf(Class<M> interfaceClass) {
        try {
            return Managers.getCacheManager(interfaceClass);
        }
        catch (Exception e) {
            return Managers.getTableManager(interfaceClass);
        }
    }

    public static <B extends BaseBean> TableManager<B> managerOf(String tablename) {
        try {
            return Managers.getCacheManager(tablename);
        }
        catch (Exception e) {
            return Managers.getTableManager(tablename);
        }
    }

    static <B extends BaseBean> BaseTableManager<B> baseManagerOf(TableManager<B> manager) {
        Preconditions.checkArgument((manager != null ? 1 : 0) != 0, (Object)"manager is null");
        if (manager instanceof BaseTableManager) {
            return (BaseTableManager)manager;
        }
        if (Proxy.isProxyClass(manager.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(manager);
            Preconditions.checkArgument((boolean)(handler instanceof TableManagerDecorator), (String)"UNKNOW HANDLER TYPE %s", manager.getClass());
            return ((TableManagerDecorator)handler).delegate;
        }
        throw new IllegalArgumentException(SimpleLog.logString((String)"UNKNOW TableManager instance type %s", (Object[])new Object[]{manager.getClass()}));
    }

    static <B extends BaseBean, M extends TableManager<B>> BaseTableManager<B> baseManagerOf(Class<M> interfaceClass) {
        return Managers.baseManagerOf(Managers.instanceOf(interfaceClass));
    }

    static <B extends BaseBean> BaseTableManager<B> baseManagerOf(String tablename) {
        return Managers.baseManagerOf(Managers.managerOf(tablename));
    }

    public static <B extends BaseBean> TableManager<B> managerOfCoreClass(String coreClass, String alias) {
        String tablename = RowMetaData.getRowMetaDataByCoreClassName((String)coreClass, (String)alias).tablename;
        try {
            return Managers.getCacheManager(tablename);
        }
        catch (Exception e) {
            return Managers.getTableManager(tablename);
        }
    }

    public static <B extends BaseBean> TableManager<B> managerOf(Class<B> beanType) {
        try {
            return Managers.getCacheManagerByBeanType(beanType);
        }
        catch (Exception e) {
            return Managers.getTableManagerByBeanType(beanType);
        }
    }

    public static void setDebug(boolean debug, Module ... modules) {
        if (modules == null || modules.length == 0) {
            modules = Module.values();
        }
        block7: for (Module module : modules) {
            if (null == module) continue;
            switch (module) {
                case MANAGER: {
                    DataSourceConfig.setDebugOutput(debug);
                    continue block7;
                }
                case CACHE: {
                    ColumnCache.setDebug(debug);
                    continue block7;
                }
                case DECORATOR: {
                    TableManagerDecorator.setDebug(debug);
                    continue block7;
                }
                case MANAGERS: {
                    Managers.debug = debug;
                    continue block7;
                }
                case BASETABLEMANAGER: {
                    BaseTableManager.setDebug(debug);
                    continue block7;
                }
            }
        }
    }

    public static void setWhereCheckFlag(int whereCheckFlag) {
        BaseTableManager.setWhereCheckFlag(whereCheckFlag);
    }

    public static void setDebugOfManager(String alias, boolean debug) {
    }

    private static Map cleanNotString(Map properties) {
        if (null != properties) {
            for (Constant.JdbcProperty property : Constant.JdbcProperty.values()) {
                if (!(properties.get(property.key) instanceof String)) {
                    properties.remove(property.key);
                }
                if (property.isGlobal()) continue;
                String key = property.withPrefix("debug.");
                if (!(properties.get(key) instanceof String)) {
                    properties.remove(key);
                }
                if (properties.get(key = property.withPrefix("work.")) instanceof String) continue;
                properties.remove(key);
            }
        }
        return properties;
    }

    static final Map normailze(Map properties) {
        HashMap<String, String> m = new HashMap<String, String>(properties);
        if (null != properties) {
            boolean isDebug;
            Managers.cleanNotString(m);
            if (!m.containsKey(Constant.JdbcProperty.DEBUG.key)) {
                m.put(Constant.JdbcProperty.DEBUG.key, "false");
            }
            String prefix = (isDebug = Boolean.valueOf((String)m.get(Constant.JdbcProperty.DEBUG.key)).booleanValue()) ? "debug." : "work.";
            for (Constant.JdbcProperty property : Constant.JdbcProperty.values()) {
                if (property.isGlobal() || !m.containsKey(property.key)) continue;
                Object value = m.remove(property.key);
                if (m.containsKey(property.withPrefix(prefix))) continue;
                m.put(property.withPrefix(prefix), (String)value);
            }
        }
        return m;
    }

    public static final void injectProperties(Map properties, String prefix) {
        DataSourceConfig.injectProperties(DataSourceConfig.asEnumMap(properties, prefix));
    }

    public static final void injectProperties(Map properties) {
        Managers.injectProperties(properties, null);
    }

    public static SqlRunner getSqlRunner() {
        return Manager.getInstance();
    }

    public static SqlRunner getSqlRunner(String alias) {
        Manager manager = Managers.managerInstanceOfAlias(alias);
        return manager == null ? Managers.getSqlRunner() : manager;
    }

    public static Manager managerInstanceOf(String jdbcUrl) {
        return null == jdbcUrl ? null : Manager.managers.get(jdbcUrl);
    }

    public static Manager managerInstanceOfAlias(String alias) {
        if (Strings.isNullOrEmpty((String)alias)) {
            alias = "DEFAULT";
        }
        return Manager.aliasManagers.get(alias);
    }

    public static synchronized Manager createInstance(Map properties) {
        properties = Managers.normailze((Map)Preconditions.checkNotNull((Object)properties, (Object)"properties is null"));
        String alias = DataSourceConfig.parseValue(properties, Constant.JdbcProperty.ALIAS);
        Manager manager = null;
        if (!Strings.isNullOrEmpty((String)alias)) {
            manager = Managers.managerInstanceOfAlias(alias);
            if (null != manager) {
                return manager;
            }
            DataSourceConfig config = DataSourceConfig.createConfig(Managers.asProperties(properties));
            return new Manager(config);
        }
        String jdbcUrl = (String)Preconditions.checkNotNull((Object)DataSourceConfig.parseValue(properties, Constant.JdbcProperty.JDBC_URL), (Object)"JDBC connect string is not defined");
        manager = Managers.managerInstanceOf(jdbcUrl);
        if (manager == null) {
            manager = new Manager(Managers.asProperties(properties));
        }
        return manager;
    }

    public static Manager createInstance(EnumMap<Constant.JdbcProperty, String> properties) {
        return Managers.createInstance(Managers.asProperties(properties));
    }

    private static Properties asProperties(Map properties) {
        if (properties instanceof Properties) {
            return (Properties)properties;
        }
        Properties props = new Properties();
        if (null != properties) {
            props.putAll((Map<?, ?>)properties);
        }
        return props;
    }

    private static final Properties asProperties(EnumMap<Constant.JdbcProperty, String> input) {
        Properties properties = new Properties();
        DataSourceConfig.injectToProperties(properties, input);
        return properties;
    }

    public static enum Module {
        MANAGER,
        CACHE,
        DECORATOR,
        MANAGERS,
        BASETABLEMANAGER;

    }
}

