/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Strings;
import gu.sql2java.IPageQueryWrap;
import gu.sql2java.pagehelper.Page;
import gu.sql2java.pagehelper.PageHelper;
import gu.sql2java.parser.ParserSupport;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

class PageQueryLimitOffsetImpl
implements IPageQueryWrap {
    @Override
    public String wrap(String sql, int startRow, int numRows) {
        Select select;
        if (!Strings.isNullOrEmpty((String)sql) && null != (select = ParserSupport.parseSelectUnchecked(sql))) {
            boolean rebuild = true;
            if (startRow == 1 && numRows < 0) {
                Page page = PageHelper.getLocalPage();
                if (null != page && page.isEnable()) {
                    startRow = (page.getPageNum() - 1) * page.getPageSize();
                    numRows = page.getPageSize();
                } else {
                    rebuild = false;
                }
            } else {
                --startRow;
            }
            if (rebuild) {
                PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
                if (numRows > 0) {
                    Limit limit = new Limit();
                    limit.setRowCount((Expression)new LongValue((long)numRows));
                    plainSelect.setLimit(limit);
                }
                if (startRow >= 0) {
                    Offset offset = new Offset();
                    offset.setOffset((Expression)new LongValue((long)startRow));
                    plainSelect.setOffset(offset);
                }
                return select.toString();
            }
        }
        return null;
    }
}

