/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableManager;
import gu.sql2java.exception.QueueStopException;
import gu.sql2java.exception.QueueTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class QueueBufferProducerAction<B extends BaseBean, T>
implements TableManager.Action<B> {
    static final int DEFAULT_QUEUE_CAPACITY = 1000;
    static final int DEFAULT_QUEUE_TIMEOUT = 10;
    static final int DEFAULT_BUFFER_CAPACITY = 100;
    private final BlockingQueue<List<T>> queue;
    private final Function<B, T> transformer;
    private final int queueTimeout;
    private final int bufferCapacity;
    private final long rowCount;
    private final AtomicBoolean stopped;
    private final boolean outputProgress;
    private final AtomicLong totalFetchCount;
    private final AtomicLong startTimeMills;
    private volatile long count = 0L;
    private List<T> buffer;

    private QueueBufferProducerAction(BlockingQueue<List<T>> queue, int bufferCapacity, int queueTimeout, AtomicBoolean stopped, Function<B, T> transformer, AtomicLong totalFetchCount, AtomicLong startTimeMills, boolean outputProgress, long rowCount) {
        this.queue = (BlockingQueue)Preconditions.checkNotNull(queue, (Object)"queue is null");
        this.queueTimeout = queueTimeout > 0 ? queueTimeout : 10;
        this.bufferCapacity = bufferCapacity > 0 ? bufferCapacity : 100;
        this.transformer = (Function)Preconditions.checkNotNull(transformer, (Object)"transformer is null");
        this.totalFetchCount = null == totalFetchCount ? new AtomicLong(0L) : totalFetchCount;
        this.startTimeMills = null == startTimeMills ? new AtomicLong(System.currentTimeMillis()) : startTimeMills;
        this.outputProgress = outputProgress;
        this.rowCount = rowCount;
        this.stopped = stopped;
    }

    public QueueBufferProducerAction(BlockingQueue<List<T>> queue, int bufferCapacity, int queueTimeout, AtomicBoolean stopped, Function<B, T> transformer, boolean outputProgress, long rowCount) {
        this(queue, bufferCapacity, queueTimeout, stopped, transformer, null, null, outputProgress, rowCount);
    }

    public QueueBufferProducerAction(int queueCapaticy, int bufferCapacity, int queueTimeout, AtomicBoolean stopped, Function<B, T> transformer, boolean outputProgress, long rowCount) {
        this(new LinkedBlockingQueue<List<T>>(queueCapaticy > 0 ? queueCapaticy : 1000), bufferCapacity, queueTimeout, stopped, transformer, outputProgress, rowCount);
    }

    public QueueBufferProducerAction(QueueBufferProducerAction<B, T> action, long rowCount) {
        this(action.queue, action.bufferCapacity, action.queueTimeout, action.stopped, action.transformer, action.totalFetchCount, action.startTimeMills, action.outputProgress, rowCount);
    }

    public QueueBufferProducerAction(AtomicBoolean stopped, Function<B, T> transformer, long rowCount) {
        this(0, 100, 0, stopped, transformer, false, rowCount);
    }

    public BlockingQueue<List<T>> getQueue() {
        return this.queue;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void call(B bean) {
        long cms;
        long sms;
        if (null != this.stopped && this.stopped.get()) {
            throw new QueueStopException("stop flag is true");
        }
        long tc = this.totalFetchCount.incrementAndGet();
        ++this.count;
        if (null == this.buffer) {
            this.buffer = new ArrayList<T>(this.bufferCapacity);
        }
        this.buffer.add(this.transformer.apply(bean));
        if (this.buffer.size() == this.bufferCapacity || this.count == this.rowCount) {
            try {
                if (!this.queue.offer(this.buffer, this.queueTimeout, TimeUnit.SECONDS)) {
                    throw new QueueTimeoutException("CANNOT insert to queue for " + this.queueTimeout + " seconds ,stop");
                }
            }
            catch (InterruptedException e) {
                throw new QueueTimeoutException((Throwable)e);
            }
            this.buffer = null;
        }
        if ((0L == tc % 100000L || this.count == this.rowCount && this.count == tc) && this.startTimeMills.compareAndSet(sms = this.startTimeMills.get(), cms = System.currentTimeMillis())) {
            SimpleLog.log((this.outputProgress || BaseTableManager.isDebug() ? 1 : 0) != 0, (String)"FETCH {} rows,{}s", (Object[])new Object[]{tc, Float.valueOf((float)(cms - sms) / 1000.0f)});
        }
    }

    public static class SimpleQueueProducerAction<B extends BaseBean>
    extends QueueBufferProducerAction<B, B> {
        public SimpleQueueProducerAction(BlockingQueue<List<B>> queue, int bufferCapacity, int queueTimeout, AtomicBoolean stopped, long rowCount) {
            super(queue, bufferCapacity, queueTimeout, stopped, b -> b, false, rowCount);
        }

        public SimpleQueueProducerAction(int queueCapaticy, int bufferCapacity, int queueTimeout, AtomicBoolean stopped, boolean outputProgress, long rowCount) {
            super(queueCapaticy, bufferCapacity, queueTimeout, stopped, b -> b, outputProgress, rowCount);
        }

        public SimpleQueueProducerAction(AtomicBoolean stopped, long rowCount) {
            super(stopped, b -> b, rowCount);
        }

        public SimpleQueueProducerAction(SimpleQueueProducerAction<B> action, long rowCount) {
            super(action, rowCount);
        }
    }
}

