/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.sql2java.ResultSetTypeCast;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class ResultSetTypeCastSqliteImpl
implements ResultSetTypeCast {
    static final ResultSetTypeCastSqliteImpl SQLITE_CAST = new ResultSetTypeCastSqliteImpl();
    static final String ISO8601_FORMATTER_STR = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final String TIMESTAMP_FORMATTER_STR = "yyyy-MM-dd HH:mm:ss";
    static final String DATE_FORMATTER_STR = "yyyy-MM-dd";

    private ResultSetTypeCastSqliteImpl() {
    }

    private static Date toDate(String date) throws ParseException {
        if (Strings.isNullOrEmpty((String)date)) {
            return null;
        }
        try {
            return new SimpleDateFormat(TIMESTAMP_FORMATTER_STR).parse(date);
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat(ISO8601_FORMATTER_STR).parse(date);
            }
            catch (ParseException e2) {
                return new SimpleDateFormat(DATE_FORMATTER_STR).parse(date);
            }
        }
    }

    private static Object valueOf(String input, Class<?> target) throws Exception {
        Method m = target.getMethod("valueOf", String.class);
        if (Modifier.isStatic(m.getModifiers())) {
            return m.invoke(null, input);
        }
        throw new ClassCastException("not suported valueOf(String)  for " + target);
    }

    @Override
    public Object cast(Object input, Type target) throws ClassCastException {
        if (null == input) {
            return input;
        }
        Preconditions.checkArgument((boolean)(input instanceof String), (Object)"input must be string");
        Preconditions.checkArgument((null != target ? 1 : 0) != 0, (Object)"target is null");
        String v = (String)input;
        try {
            if (URL.class.equals((Object)target)) {
                return new URL(v);
            }
            if (URI.class.equals((Object)target)) {
                return new URI(v);
            }
            if (Date.class.equals((Object)target)) {
                return ResultSetTypeCastSqliteImpl.toDate(v);
            }
            if (target instanceof Class) {
                return ResultSetTypeCastSqliteImpl.valueOf(v, (Class)target);
            }
            throw new ClassCastException("Conversion not supported for type " + target);
        }
        catch (Exception e) {
            throw new ClassCastException("Conversion not supported for type " + target + "caused by " + e.getMessage());
        }
    }
}

