/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.sql2java.Managers;
import gu.sql2java.exception.DaoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private boolean stopOnError;
    private boolean autoCommit;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;
    private boolean clearComment = false;
    private String alias = null;
    private final List<Pattern> clearnPatterns = Lists.newArrayList();
    private final List<Pattern> ignorePatterns = Lists.newArrayList();
    private final Map<Pattern, String> replacePatterns = Maps.newHashMap();
    private final List<String> executableSqls = Lists.newLinkedList();

    public ScriptRunner(boolean autoCommit, boolean stopOnError) {
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public ScriptRunner setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
        return this;
    }

    public ScriptRunner setClearComment(boolean clearComment) {
        this.clearComment = clearComment;
        return this;
    }

    public ScriptRunner setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public ScriptRunner addClearRegex(String regex) {
        if (!Strings.isNullOrEmpty((String)regex)) {
            this.clearnPatterns.add(Pattern.compile(regex));
        }
        return this;
    }

    public ScriptRunner addClearRegex(Pattern pattern) {
        if (null != pattern) {
            this.clearnPatterns.add(pattern);
        }
        return this;
    }

    public ScriptRunner addIgnoreRegex(Pattern pattern) {
        if (null != pattern) {
            this.ignorePatterns.add(pattern);
        }
        return this;
    }

    public ScriptRunner addReplaceRegex(Pattern pattern, String replacement) {
        if (null != pattern && null != replacement) {
            this.replacePatterns.put(pattern, replacement);
        }
        return this;
    }

    public ScriptRunner setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
        return this;
    }

    public ScriptRunner setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader) throws IOException, DaoException {
        try {
            Connection connection = Managers.managerInstanceOfAlias(this.alias).getConnection();
            boolean originalAutoCommit = connection.getAutoCommit();
            boolean commit = false;
            try {
                if (originalAutoCommit != this.autoCommit) {
                    connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(connection, (Reader)Preconditions.checkNotNull((Object)reader, (Object)"reader is null"));
                commit = true;
            }
            finally {
                if (!this.autoCommit) {
                    if (commit) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                }
                connection.setAutoCommit(originalAutoCommit);
                Managers.managerInstanceOfAlias(this.alias).releaseConnection(connection);
            }
        }
        catch (SQLException e) {
            throw new DaoException((Throwable)e);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void runScript(String input) throws IOException, DaoException {
        this.runScript(new StringReader((String)Preconditions.checkNotNull((Object)input, (Object)"input is null")));
    }

    public void runScript(List<String> input) throws IOException, DaoException {
        this.runScript(new StringReader((String)Preconditions.checkNotNull((Object)Joiner.on((char)'\n').join(input), (Object)"input is null")));
    }

    public void runScript(InputStream input) throws IOException, DaoException {
        this.runScript(new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)input, (Object)"input is null")));
    }

    public List<String> getExecutableSqls() {
        return this.executableSqls;
    }

    private boolean isIgnore(String sql) {
        for (Pattern p : this.ignorePatterns) {
            p.matcher(sql);
            if (!p.matcher(sql).matches()) continue;
            this.println("--" + sql);
            return true;
        }
        return false;
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuilder command = null;
        this.executableSqls.clear();
        try (LineNumberReader lineReader = new LineNumberReader(reader);){
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuilder();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    this.println(trimmedLine);
                    continue;
                }
                if (trimmedLine.startsWith("#")) {
                    this.println(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    String sql = command.toString();
                    if (this.isIgnore(sql)) {
                        command = null;
                        continue;
                    }
                    if (this.clearComment) {
                        sql = sql.replaceAll("COMMENT +'[^']*'", "");
                    }
                    this.executableSqls.add(sql);
                    for (Pattern pattern : this.clearnPatterns) {
                        sql = pattern.matcher(sql).replaceAll("");
                    }
                    for (Map.Entry entry : this.replacePatterns.entrySet()) {
                        sql = ((Pattern)entry.getKey()).matcher(sql).replaceAll((String)entry.getValue());
                    }
                    this.println(sql);
                    boolean hasResults = false;
                    if (this.stopOnError) {
                        hasResults = statement.execute(sql);
                    } else {
                        try {
                            statement.execute(sql);
                        }
                        catch (SQLException sQLException) {
                            sQLException.fillInStackTrace();
                            this.printlnError("Error executing: " + sql);
                            this.printlnError(sQLException);
                        }
                    }
                    ResultSet resultSet = statement.getResultSet();
                    if (hasResults && resultSet != null) {
                        int i;
                        ResultSetMetaData md = resultSet.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 0; i < cols; ++i) {
                            String name = md.getColumnLabel(i + 1);
                            this.print(name + "\t");
                        }
                        this.println("");
                        while (resultSet.next()) {
                            for (i = 0; i < cols; ++i) {
                                String value = resultSet.getString(i + 1);
                                this.print(value + "\t");
                            }
                            this.println("");
                        }
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        finally {
            this.flush();
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            System.out.print(o);
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

