/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.ColumnCache;
import gu.sql2java.Constant;
import gu.sql2java.IKeyCache;
import gu.sql2java.IndexMetaData;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableListener;
import gu.sql2java.TableManager;
import gu.sql2java.exception.ObjectRetrievalException;
import gu.sql2java.exception.RuntimeDaoException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class TableCache<B extends BaseBean>
extends ColumnCache<B>
implements TableListener<B> {
    private static final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("sql2java-cache-updater-%d").build()));
    private final Map<String, IKeyCache<B>> indexCachers;

    public TableCache(RowMetaData metaData, Constant.UpdateStrategy updateStrategy, Long maximumSize, Long duration, TimeUnit unit) {
        super(metaData, null, updateStrategy, maximumSize, duration, unit);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Constant.UpdateStrategy indexStrategy = Constant.UpdateStrategy.refresh.equals((Object)this.updateStrategy) ? Constant.UpdateStrategy.always : this.updateStrategy;
        for (IndexMetaData index : metaData.getUniqueIndices().values()) {
            builder.put((Object)index.name, new ColumnCache(this.metaData, index.name, indexStrategy, this.maximumSize, this.duration, this.unit));
        }
        this.indexCachers = builder.build();
        this.manager.bindForeignKeyListenerForDeleteRule();
    }

    public void registerListener() {
        this.manager.registerListener(this);
        if (debug) {
            SimpleLog.log((String)("REGISTER LISTENER FOR INDEX AND PRIMARY KEY of " + this.metaData.tablename), (Object[])new Object[0]);
        }
    }

    public void unregisterListener() {
        this.manager.unregisterListener(this);
    }

    private void updateAll(B bean) {
        this.update(bean, Constant.UpdateStrategy.always);
        for (IKeyCache<B> cache : this.indexCachers.values()) {
            cache.update(bean, Constant.UpdateStrategy.always);
        }
    }

    public B getBeanByIndex(String indexName, Object ... keys) throws ObjectRetrievalException {
        return ((IKeyCache)Preconditions.checkNotNull(this.indexCachers.get(indexName), (String)"INVALID indexName %s", (Object)indexName)).getBean(keys);
    }

    public B getBeanByIndexUnchecked(String indexName, Object ... keys) {
        return ((IKeyCache)Preconditions.checkNotNull(this.indexCachers.get(indexName), (String)"INVALID indexName %s", (Object)indexName)).getBeanUnchecked(keys);
    }

    public TableManager.Action<B> wrap(TableManager.Action<B> action) {
        if (action == null || action instanceof CacheWrapper || action instanceof BaseTableManager.DeleteBeanAction) {
            return action;
        }
        return new CacheWrapper(action);
    }

    @Override
    public B remove(B bean) {
        B mem = super.remove(bean);
        for (IKeyCache<B> cache : this.indexCachers.values()) {
            if (cache.hasValidKey(bean)) {
                cache.remove(bean);
                continue;
            }
            if (!cache.hasValidKey(mem)) continue;
            cache.remove(mem);
        }
        return mem;
    }

    @Override
    public B removeCached(Object ... primaryKeys) {
        Object removed = super.removeCached(primaryKeys);
        for (IKeyCache cache : this.indexCachers.values()) {
            cache.remove(removed);
        }
        return removed;
    }

    public B removeCachedByIndex(String indexName, Object ... indexKeys) {
        if (null != indexName) {
            IKeyCache indexCache = (IKeyCache)Preconditions.checkNotNull(this.indexCachers.get(indexName), (String)"INVALID indexName %s", (Object)indexName);
            return this.remove(indexCache.removeCached(indexKeys));
        }
        return null;
    }

    public void afterUpdate(B bean) {
        if (!Constant.UpdateStrategy.refresh.equals((Object)this.updateStrategy)) {
            bean = this.loadfromDatabase(bean.primaryValues());
        }
        this.update(bean);
        if (Constant.UpdateStrategy.refresh.equals((Object)this.updateStrategy)) {
            bean = this.getBean(bean.primaryValues());
        }
        for (IKeyCache<B> cache : this.indexCachers.values()) {
            cache.update(bean);
        }
    }

    public void afterInsert(B bean) {
        this.update(bean);
        for (IKeyCache<B> cache : this.indexCachers.values()) {
            cache.update(bean);
        }
    }

    public void afterDelete(B bean) {
        this.remove(bean);
    }

    public void beforeInsert(B bean) throws RuntimeDaoException {
    }

    public void beforeUpdate(B bean) throws RuntimeDaoException {
    }

    public void beforeDelete(B bean) throws RuntimeDaoException {
    }

    public void done() throws RuntimeDaoException {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.indexCachers == null ? 0 : this.indexCachers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TableCache)) {
            return false;
        }
        TableCache other = (TableCache)obj;
        return !(this.indexCachers == null ? other.indexCachers != null : !this.indexCachers.equals(other.indexCachers));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableCache [super=");
        builder.append(super.toString());
        builder.append(",indexCachers=");
        builder.append(this.indexCachers);
        builder.append("]");
        return builder.toString();
    }

    private class CacheWrapper
    implements TableManager.Action<B> {
        private final TableManager.Action<B> action;

        public CacheWrapper(TableManager.Action<B> action) {
            this.action = (TableManager.Action)Preconditions.checkNotNull(action, (Object)"action is null");
        }

        public void call(B bean) {
            this.action.call(bean);
            executor.execute(new Runnable((BaseBean)bean){
                final /* synthetic */ BaseBean val$bean;
                {
                    this.val$bean = baseBean;
                }

                @Override
                public void run() {
                    TableCache.this.updateAll(this.val$bean);
                }
            });
        }
    }
}

