/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.ForeignKeyMetaData;
import gu.sql2java.IndexMetaData;
import gu.sql2java.Managers;
import gu.sql2java.NameUtilities;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.TableManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableManagerDecorator<I extends TableManager<?>>
implements InvocationHandler {
    private final Class<I> interfaceClass;
    final BaseTableManager<? extends BaseBean> delegate;
    private final Map<Method, Invoker> invokers = Maps.newLinkedHashMap();
    private final Class<? extends BaseTableManager> implClass;
    final RowMetaData metaData;
    private static boolean debug = false;
    private static final String M_LOADBYPRIMARYKEY = "loadByPrimaryKey";
    private static final String D_LOADBYPKS = "loadByPks";
    private static final String M_LOADBYPRIMARYKEYCHECKED = "loadByPrimaryKeyChecked";
    private static final String M_EXISTSPRIMARYKEY = "existsPrimaryKey";
    private static final String M_CHECKDUPLICATE = "checkDuplicate";
    private static final String D_CHECKDUPLICATEBYPK = "checkDuplicateByPk";
    private static final String M_DELETEBYPRIMARYKEY = "deleteByPrimaryKey";
    private static final String D_DELETEBYPKS = "deleteByPks";
    private static final String M_TOPRIMARYKEYLIST = "toPrimaryKeyList";
    private static final String P_ADDJUNCTION = "addJunction(With(\\w+))?";
    private static final String D_ADDJUNCTION = "addJunction";
    private static final String P_DELETEJUNCTION = "deleteJunction(With(\\w+))?";
    private static final String D_DELETEJUNCTION = "deleteJunction";
    private static final String P_GETIMPORTEDBEANS = "get(\\w+)sBy(\\w+)$";
    private static final String D_GETIMPORTEDBEANS = "getImportedBeans";
    private static final String P_GETIMPORTEDBEANSASLIST = "get(\\w+)sBy(\\w+)AsList";
    private static final String D_GETIMPORTEDBEANSASLIST = "getImportedBeansAsList";
    private static final String P_DELETEIMPORTEDBEANS = "delete(\\w+)sBy(\\w+)";
    private static final String D_DELETEIMPORTEDBEANS = "deleteImportedBeans";
    private static final String P_SETIMPORTEDBEANS = "set(\\w+)sBy(\\w+)";
    private static final String D_SETIMPORTEDBEANS = "setImportedBeans";
    private static final String M_SAVE = "save";
    private static final String D_SAVEFULLY = "saveFully";
    private static final String M_SAVEASTRANSACTION = "saveAsTransaction";
    private static final String D_SAVEFULLYASTRANSACTION = "saveFullyAsTransaction";
    private static final String P_GETREFERENCEDBEAN = "getReferencedBy(\\w+)";
    private static final String D_GETREFERENCEDBEAN = "getReferencedBean";
    private static final String P_SETREFERENCEDBEAN = "setReferencedBy(\\w+)";
    private static final String D_SETREFERENCEDBEAN = "setReferencedBean";
    private static final String P_LOADBYINDEX = "loadByIndex(\\w+)";
    private static final String D_LOADBYINDEX = "loadByIndex";
    private static final String P_LOADUNIQUEBYINDEXCHECKED = "loadByIndex(\\w+)Checked";
    private static final String D_LOADUNIQUEBYINDEXCHECKED = "loadUniqueByIndexChecked";
    private static final String D_LOADBYINDEXFORINDICES = "loadByIndexForIndices";
    private static final String D_LOADUNIQUEBYINDEX = "loadUniqueByIndex";
    private static final String P_LOADBYINDEXASLIST = "loadByIndex(\\w+)AsList";
    private static final String D_LOADBYINDEXASLIST = "loadByIndexAsList";
    private static final String P_DELETEBYINDEX = "deleteByIndex(\\w+)";
    private static final String D_DELETEBYINDEX = "deleteByIndex";
    private static final String P_LOADVIAJUNCTIONASLIST = "loadVia(\\w+)AsList";
    private static final String D_LOADVIAJUNCTIONASLIST = "loadViaJunctionAsList";
    private static final String P_LISTOFSELFREF = "listOf(\\w+)";
    private static final String D_LISTOFSELFREF = "listOfSelfRef";
    private static final String P_LEVELOFSELFREF = "levelOf(\\w+)";
    private static final String D_LEVELOFSELFREF = "levelOfSelfRef";
    private static final String P_ISCYCLEOFSELFREF = "isCycleOn(\\w+)";
    private static final String D_ISCYCLEOFSELFREF = "isCycleOfSelfRef";
    private static final String P_CHECKCYCLEOFSELFREF = "checkCycleOf(\\w+)";
    private static final String D_CHECKCYCLEOFSELFREF = "checkCycleOfSelfRef";
    private static final String P_TOPOFSELFREF = "topOf(\\w+)";
    private static final String D_TOPOFSELFREF = "topOfSelfRef";
    private static final String P_CHILDLISTOFSELFREF = "childListBy(\\w+)";
    private static final String D_CHILDLISTOFSELFREF = "childListOfSelfRef";
    private static final String P_CHILDRENOFSELFREF = "childrenBy(\\w+)";
    private static final String D_CHILDRENOFSELFREF = "childrenOfSelfRef";
    private static final String P_CHILDRENOFBEANSOFSELFREF = "childrenOfBeansBy(\\w+)";
    private static final String D_CHILDRENOFBEANSOFSELFREF = "childrenOfBeansOfSelfRef";
    private static final String P_CHILDRENOFPKSOFSELFREF = "childrenOfPksBy(\\w+)";
    private static final String D_CHILDRENOFPKSOFSELFREF = "childrenOfPksOfSelfRef";
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            return NameUtilities.signatureOf((Method)o1).compareTo(NameUtilities.signatureOf((Method)o2));
        }
    };

    TableManagerDecorator(Class<I> interfaceClass, BaseTableManager<? extends BaseBean> delegate) {
        TableManagerDecorator.checkType(interfaceClass, delegate);
        this.interfaceClass = interfaceClass;
        this.delegate = delegate;
        this.implClass = delegate.getClass();
        this.metaData = delegate.metaData;
        try {
            this.compile();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    TableManagerDecorator(Class<I> interfaceClass, String tablename) {
        this(interfaceClass, new BaseTableManager(tablename));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return ((Invoker)Preconditions.checkNotNull((Object)this.invokers.get(method), (String)"UNSUPPORT method %s", (Object)method)).invoke(args);
    }

    public final I proxyInstance() {
        return (I)((TableManager)this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this)));
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        String simulateClassName = this.interfaceClass.getSimpleName() + "Decorator";
        String simulateTableManagerClass = BaseTableManager.class.getName() + "<" + this.metaData.beanType.getName() + ">";
        builder.append("class ").append(simulateClassName).append(" implements ").append(this.interfaceClass.getName()).append("{\n");
        builder.append("    private final ").append(simulateTableManagerClass).append(" delegate;\n");
        builder.append("    public ").append(simulateClassName).append("(").append(simulateTableManagerClass).append(" delegate){\n");
        builder.append("        this.delegate = delegate\n");
        builder.append("    }\n");
        for (Invoker invoker : this.invokers.values()) {
            builder.append(invoker);
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static void checkType(Class<?> interfaceClass, BaseTableManager<?> delegate) {
        Preconditions.checkArgument((interfaceClass != null ? 1 : 0) != 0, (Object)"interfaceClass is null");
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (Object)"delegate is null");
        Preconditions.checkArgument((boolean)delegate.metaData.managerInterfaceClass.equals(interfaceClass), (String)"MISMATCH interface class of delegate(%s) with %s", (Object)delegate.metaData.managerInterfaceClass.getSimpleName(), (Object)interfaceClass.getName());
    }

    static final <I extends TableManager<?>> I makeInterfaceInstance(Class<I> interfaceClass, BaseTableManager<?> delegate) {
        return new TableManagerDecorator<I>(interfaceClass, delegate).proxyInstance();
    }

    static final <I extends TableManager<?>> I makeInterfaceInstance(Class<I> interfaceClass, String tablename) {
        return new TableManagerDecorator<I>(interfaceClass, tablename).proxyInstance();
    }

    static final <I extends TableManager<?>> TableManager<?> makeInterfaceInstance(BaseTableManager<?> delegate) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (Object)"delegate is null");
        Preconditions.checkArgument((delegate.metaData.managerInterfaceClass != null ? 1 : 0) != 0, (Object)"delegate.metaData.managerInterfaceClass is null");
        return TableManagerDecorator.makeInterfaceInstance(delegate.metaData.managerInterfaceClass, delegate);
    }

    static final <I extends TableManager<?>> TableManager<?> makeInterfaceInstance(String tablename) {
        return TableManagerDecorator.makeInterfaceInstance(Managers.getBaseTableManager(tablename));
    }

    static void setDebug(boolean debug) {
        TableManagerDecorator.debug = debug;
    }

    private static boolean declaredBySuper(Method method, Class<?> superClazz) {
        if (method.getDeclaringClass().equals(superClazz)) {
            return true;
        }
        for (Class<?> clazz : superClazz.getInterfaces()) {
            if (!TableManagerDecorator.declaredBySuper(method, clazz)) continue;
            return true;
        }
        return false;
    }

    private static Method recursiveGetDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (null != superClass) {
                return TableManagerDecorator.recursiveGetDeclaredMethod(superClass, name, parameterTypes);
            }
            throw e;
        }
    }

    private Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return TableManagerDecorator.recursiveGetDeclaredMethod(this.implClass, name, parameterTypes);
    }

    private NoSuchMethodException makeNoSuchMethodException(Method def) {
        return new NoSuchMethodException(SimpleLog.logString((String)"NO FOUND MATCHED METHOD for %s in %s", (Object[])new Object[]{def, this.implClass}));
    }

    private Invoker compile(Method def) throws NoSuchMethodException, SecurityException {
        String name = def.getName();
        if (TableManagerDecorator.declaredBySuper(def, TableManager.class)) {
            Method impl = BaseTableManager.class.getDeclaredMethod(name, def.getParameterTypes());
            return new MethodInvoker(def, impl, this.delegate, new Object[0]);
        }
        switch (name) {
            case "loadByPrimaryKey": {
                return this.loadByPrimaryKey(def);
            }
            case "loadByPrimaryKeyChecked": {
                Method impl = this.getDeclaredMethod(M_LOADBYPRIMARYKEYCHECKED, Object[].class);
                return new MethodInvoker(def, impl, this.delegate, new Object[0]);
            }
            case "existsPrimaryKey": {
                Method impl = this.getDeclaredMethod(M_EXISTSPRIMARYKEY, Object[].class);
                return new MethodInvoker(def, impl, this.delegate, new Object[0]);
            }
            case "checkDuplicate": {
                Method impl = this.getDeclaredMethod(D_CHECKDUPLICATEBYPK, Object.class);
                return new MethodInvoker(def, impl, this.delegate, new Object[0]);
            }
            case "deleteByPrimaryKey": {
                return this.deleteByPrimaryKey(def);
            }
            case "toPrimaryKeyList": {
                return this.toPrimaryKeyList(def);
            }
            case "save": {
                return this.saveFully(def);
            }
            case "saveAsTransaction": {
                return this.saveFullyAsTransaction(def);
            }
        }
        if (name.matches(P_ADDJUNCTION)) {
            return this.addJunction(def);
        }
        if (name.matches(P_DELETEJUNCTION)) {
            return this.deleteJunction(def);
        }
        if (name.matches(P_GETIMPORTEDBEANSASLIST)) {
            return this.getImportedBeansAsList(def);
        }
        if (name.matches(P_GETIMPORTEDBEANS)) {
            return this.getImportedBeans(def);
        }
        if (name.matches(P_DELETEIMPORTEDBEANS)) {
            return this.deleteImportedBeans(def);
        }
        if (name.matches(P_SETIMPORTEDBEANS)) {
            return this.setImportedBeans(def);
        }
        if (name.matches(P_GETREFERENCEDBEAN)) {
            return this.getReferencedBean(def);
        }
        if (name.matches(P_SETREFERENCEDBEAN)) {
            return this.setReferencedBean(def);
        }
        if (name.matches(P_LOADBYINDEXASLIST)) {
            return this.loadByIndexAsList(def);
        }
        if (name.matches(P_LOADUNIQUEBYINDEXCHECKED)) {
            return this.loadUniqueByIndexChecked(def);
        }
        if (name.matches(P_LOADBYINDEX)) {
            return this.loadByIndex(def);
        }
        if (name.matches(P_DELETEBYINDEX)) {
            return this.deleteByIndex(def);
        }
        if (name.matches(P_LOADVIAJUNCTIONASLIST)) {
            return this.loadViaJunctionAsList(def);
        }
        if (name.matches(P_LISTOFSELFREF)) {
            return this.listOfSelfRef(def);
        }
        if (name.matches(P_LEVELOFSELFREF)) {
            return this.levelOfSelfRef(def);
        }
        if (name.matches(P_ISCYCLEOFSELFREF)) {
            return this.isCycleOfSelfRef(def);
        }
        if (name.matches(P_CHECKCYCLEOFSELFREF)) {
            return this.checkCycleOfSelfRef(def);
        }
        if (name.matches(P_TOPOFSELFREF)) {
            return this.topOfSelfRef(def);
        }
        if (name.matches(P_CHILDLISTOFSELFREF)) {
            return this.childListOfSelfRef(def);
        }
        if (name.matches(P_CHILDRENOFSELFREF)) {
            return this.childrenOfSelfRef(def);
        }
        if (name.matches(P_CHILDRENOFBEANSOFSELFREF)) {
            return this.childrenOfSelfRefForBeans(def);
        }
        if (name.matches(P_CHILDRENOFPKSOFSELFREF)) {
            return this.childrenOfSelfRefForPks(def);
        }
        throw new IllegalArgumentException(SimpleLog.logString((String)"NO SUCH METHOD maped %s", (Object[])new Object[]{def.getName()}));
    }

    private void addObjectInvoker(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = Object.class.getMethod(methodName, parameterTypes);
        ObjectInvoker objectInvoker = new ObjectInvoker(method);
        this.invokers.put(method, objectInvoker);
        if (debug) {
            SimpleLog.log((String)"{}", (Object[])new Object[]{objectInvoker});
        }
    }

    private void compile(Method[] methods) throws NoSuchMethodException, SecurityException {
        Arrays.sort(methods, METHOD_COMPARATOR);
        for (Method method : methods) {
            Invoker invokder = this.compile(method);
            this.invokers.put(method, invokder);
            if (!debug) continue;
            SimpleLog.log((String)"{}", (Object[])new Object[]{invokder});
        }
    }

    private void compile() throws NoSuchMethodException, SecurityException {
        this.addObjectInvoker("toString", new Class[0]);
        this.addObjectInvoker("hashCode", new Class[0]);
        this.addObjectInvoker("equals", Object.class);
        this.compile(TableManager.class.getMethods());
        Method[] noBridgeMethods = (Method[])Arrays.stream(this.interfaceClass.getDeclaredMethods()).filter(m -> !m.isBridge()).toArray(Method[]::new);
        this.compile(noBridgeMethods);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MethodInvoker loadByPrimaryKey(Method def) throws NoSuchMethodException, SecurityException {
        Method impl;
        Object[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == this.metaData.primaryKeyCount ? 1 : 0) != 0, (String)"only %s parameter required for %s", (int)this.metaData.primaryKeyCount, (Object)def);
        if (Arrays.equals(this.metaData.primaryKeyTypes, paramTypes)) {
            impl = this.getDeclaredMethod(M_LOADBYPRIMARYKEY, Object[].class);
            return new MethodInvoker(def, impl, this.delegate, new Object[0]);
        } else {
            if (this.metaData.primaryKeyCount != 1) throw this.makeNoSuchMethodException(def);
            if (Collection.class.isAssignableFrom((Class<?>)paramTypes[0])) {
                impl = this.getDeclaredMethod(D_LOADBYPKS, Collection.class);
                return new MethodInvoker(def, impl, this.delegate, new Object[0]);
            } else {
                Class pkType = this.metaData.columnTypeOf(this.metaData.primaryKeyIds[0]);
                Object pkArray = Array.newInstance(pkType, 0);
                if (paramTypes[0] != pkArray.getClass()) throw this.makeNoSuchMethodException(def);
                impl = this.getDeclaredMethod(D_LOADBYPKS, Object[].class);
            }
        }
        return new MethodInvoker(def, impl, this.delegate, new Object[0]);
    }

    private MethodInvoker deleteByPrimaryKey(Method def) throws NoSuchMethodException, SecurityException {
        Method impl;
        Object[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == this.metaData.primaryKeyCount ? 1 : 0) != 0, (String)"%s parameter required for %s", (int)this.metaData.primaryKeyCount, (Object)def);
        if (Arrays.equals(this.metaData.primaryKeyTypes, paramTypes)) {
            impl = this.getDeclaredMethod(M_DELETEBYPRIMARYKEY, Object[].class);
        } else if (Collection.class.isAssignableFrom((Class<?>)paramTypes[0])) {
            impl = this.getDeclaredMethod(D_DELETEBYPKS, Collection.class);
        } else {
            Class pkType = this.metaData.columnTypeOf(this.metaData.primaryKeyIds[0]);
            Object pkArray = Array.newInstance(pkType, 0);
            if (paramTypes[0] == pkArray.getClass()) {
                impl = this.getDeclaredMethod(D_DELETEBYPKS, Object[].class);
            } else {
                throw this.makeNoSuchMethodException(def);
            }
        }
        return new MethodInvoker(def, impl, this.delegate, new Object[0]);
    }

    private MethodInvoker getImportedBeans(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_GETIMPORTEDBEANS);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_GETIMPORTEDBEANS);
        String importeBeanName = matcher.group(1);
        String readableName = matcher.group(2);
        ForeignKeyMetaData importedKey = RowMetaData.getForeignKey((String)importeBeanName, (String)readableName, (String)this.metaData.alias);
        Method impl = this.getDeclaredMethod(D_GETIMPORTEDBEANS, TableManagerDecorator.paramBuilder().add(importedKey.name.getClass(), paramTypes).normalizeLast(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{importedKey.name});
    }

    private MethodInvoker getImportedBeansAsList(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        switch (paramTypes.length) {
            case 1: {
                break;
            }
            case 3: {
                if (BaseBean.class.isAssignableFrom(paramTypes[0]) && Integer.TYPE == paramTypes[1] && Integer.TYPE == paramTypes[2]) break;
                paramTypes = new Class[]{Object[].class};
                break;
            }
            default: {
                paramTypes = new Class[]{Object[].class};
            }
        }
        Pattern pattern = Pattern.compile(P_GETIMPORTEDBEANSASLIST);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_GETIMPORTEDBEANSASLIST);
        String importeBeanName = matcher.group(1);
        String readableName = matcher.group(2);
        ForeignKeyMetaData importedKey = RowMetaData.getForeignKey((String)importeBeanName, (String)readableName, (String)this.metaData.alias);
        Method impl = this.getDeclaredMethod(D_GETIMPORTEDBEANSASLIST, TableManagerDecorator.paramBuilder().add(importedKey.name.getClass(), paramTypes).genericNormalize(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{importedKey.name});
    }

    private MethodInvoker deleteImportedBeans(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_DELETEIMPORTEDBEANS);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_DELETEIMPORTEDBEANS);
        String importeBeanName = matcher.group(1);
        String readableName = matcher.group(2);
        ForeignKeyMetaData importedKey = RowMetaData.getForeignKey((String)importeBeanName, (String)readableName, (String)this.metaData.alias);
        Method impl = this.getDeclaredMethod(D_DELETEIMPORTEDBEANS, TableManagerDecorator.paramBuilder().add(importedKey.name.getClass(), paramTypes).normalizeLast(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{importedKey.name});
    }

    private MethodInvoker setImportedBeans(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 2 ? 1 : 0) != 0, (String)"2 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_SETIMPORTEDBEANS);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_SETIMPORTEDBEANS);
        String importeBeanName = matcher.group(1);
        String readableName = matcher.group(2);
        ForeignKeyMetaData importedKey = RowMetaData.getForeignKey((String)importeBeanName, (String)readableName, (String)this.metaData.alias);
        Method impl = this.getDeclaredMethod(D_SETIMPORTEDBEANS, TableManagerDecorator.paramBuilder().add(importedKey.name.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{importedKey.name});
    }

    private MethodInvoker saveFully(Method def) throws NoSuchMethodException, SecurityException {
        int paramCount;
        Class<?>[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == (paramCount = this.metaData.foreignKeys.size() + this.metaData.getImportedKeys().size() + 1) ? 1 : 0) != 0, (String)"%s parameter required for %s", (int)paramCount, (Object)def.getName());
        Method impl = this.getDeclaredMethod(D_SAVEFULLY, BaseBean.class, Object[].class);
        return new SaveFullyInvoker(def, impl);
    }

    private MethodInvoker saveFullyAsTransaction(Method def) throws NoSuchMethodException, SecurityException {
        int paramCount;
        Class<?>[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == (paramCount = this.metaData.foreignKeys.size() + this.metaData.getImportedKeys().size() + 1) ? 1 : 0) != 0, (String)"%s parameter required for %s", (int)paramCount, (Object)def.getName());
        Method impl = this.getDeclaredMethod(D_SAVEFULLYASTRANSACTION, BaseBean.class, Object[].class);
        return new SaveFullyInvoker(def, impl);
    }

    private MethodInvoker getReferencedBean(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_GETREFERENCEDBEAN);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_GETREFERENCEDBEAN);
        String readableName = matcher.group(1);
        ForeignKeyMetaData foreignKey = this.metaData.getForeignKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_GETREFERENCEDBEAN, foreignKey.name.getClass(), BaseBean.class);
        return new MethodInvoker(def, impl, this.delegate, new Object[]{foreignKey.name});
    }

    private MethodInvoker setReferencedBean(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 2 ? 1 : 0) != 0, (String)"2 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_SETREFERENCEDBEAN);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_SETREFERENCEDBEAN);
        String readableName = matcher.group(1);
        ForeignKeyMetaData foreignKey = this.metaData.getForeignKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_SETREFERENCEDBEAN, TableManagerDecorator.paramBuilder().add(foreignKey.name.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{foreignKey.name});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MethodInvoker loadByIndex(Method def) throws NoSuchMethodException, SecurityException {
        Method impl;
        Object[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_LOADBYINDEX);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LOADBYINDEX);
        String readableName = matcher.group(1);
        IndexMetaData index = this.metaData.getIndexCheckedByRn(readableName);
        if (index.unique) {
            Object indexArray = Array.newInstance(this.metaData.jdbcTypeOf(this.metaData.indexIdArray(index.name)[0]), 0);
            if (paramTypes[0].equals(indexArray.getClass()) && index.columns.size() == 1) {
                impl = this.getDeclaredMethod(D_LOADBYINDEXFORINDICES, index.name.getClass(), Object[].class);
                return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
            } else if (Collection.class.equals(paramTypes[0]) && index.columns.size() == 1) {
                impl = this.getDeclaredMethod(D_LOADBYINDEXFORINDICES, index.name.getClass(), Collection.class);
                return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
            } else {
                if (!Arrays.equals(this.metaData.indexTypeArray(index.name), paramTypes)) throw this.makeNoSuchMethodException(def);
                impl = this.getDeclaredMethod(D_LOADUNIQUEBYINDEX, index.name.getClass(), Object[].class);
            }
            return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
        } else {
            impl = this.getDeclaredMethod(D_LOADBYINDEX, index.name.getClass(), Object[].class);
        }
        return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
    }

    private MethodInvoker loadUniqueByIndexChecked(Method def) throws NoSuchMethodException, SecurityException {
        Object[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_LOADUNIQUEBYINDEXCHECKED);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LOADUNIQUEBYINDEXCHECKED);
        String readableName = matcher.group(1);
        IndexMetaData index = this.metaData.getIndexCheckedByRn(readableName);
        if (!Arrays.equals(this.metaData.indexTypeArray(index.name), paramTypes)) {
            throw this.makeNoSuchMethodException(def);
        }
        Method impl = this.getDeclaredMethod(D_LOADUNIQUEBYINDEXCHECKED, index.name.getClass(), Object[].class);
        return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
    }

    private MethodInvoker loadByIndexAsList(Method def) throws NoSuchMethodException, SecurityException {
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_LOADBYINDEXASLIST);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LOADBYINDEXASLIST);
        String readableName = matcher.group(1);
        IndexMetaData index = this.metaData.getIndexCheckedByRn(readableName);
        Method impl = this.getDeclaredMethod(D_LOADBYINDEXASLIST, index.name.getClass(), Object[].class);
        return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
    }

    private MethodInvoker deleteByIndex(Method def) throws NoSuchMethodException, SecurityException {
        String methodName = def.getName();
        Pattern pattern = Pattern.compile(P_DELETEBYINDEX);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_DELETEBYINDEX);
        String readableName = matcher.group(1);
        IndexMetaData index = this.metaData.getIndexCheckedByRn(readableName);
        Method impl = this.getDeclaredMethod(D_DELETEBYINDEX, index.name.getClass(), Object[].class);
        return new MethodInvoker(def, impl, this.delegate, new Object[]{index.name});
    }

    private MethodInvoker loadViaJunctionAsList(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 || paramTypes.length == 3 ? 1 : 0) != 0, (String)"1 or 3 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_LOADVIAJUNCTIONASLIST);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LOADVIAJUNCTIONASLIST);
        String coreClassName = matcher.group(1);
        String junctionTable = RowMetaData.getRowMetaDataByCoreClassName((String)coreClassName, (String)this.metaData.alias).tablename;
        TableManagerDecorator.paramBuilder().add(junctionTable.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build();
        Method impl = this.getDeclaredMethod(D_LOADVIAJUNCTIONASLIST, TableManagerDecorator.paramBuilder().add(junctionTable.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{junctionTable});
    }

    private MethodInvoker addJunction(Method def) throws NoSuchMethodException, SecurityException {
        String name = def.getName();
        Type[] gTypes = def.getGenericParameterTypes();
        Class<?>[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == 2 ? 1 : 0) != 0, (String)"only 2 parameter required for %s", (Object)name);
        RowMetaData junctionTable = this.metaData.getJunctionTableFor(gTypes[1]);
        Method impl = this.getDeclaredMethod(D_ADDJUNCTION, TableManagerDecorator.paramBuilder().add(junctionTable.tablename.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{junctionTable.tablename});
    }

    private MethodInvoker deleteJunction(Method def) throws NoSuchMethodException, SecurityException {
        Type[] gTypes = def.getGenericParameterTypes();
        Class<?>[] paramTypes = def.getParameterTypes();
        Preconditions.checkArgument((paramTypes.length == 2 ? 1 : 0) != 0, (String)"only 2 parameter required for %s", (Object)def.getName());
        RowMetaData junctionTable = this.metaData.getJunctionTableFor(gTypes[1]);
        Method impl = this.getDeclaredMethod(D_DELETEJUNCTION, TableManagerDecorator.paramBuilder().add(junctionTable.tablename.getClass(), TableManagerDecorator.wrapBaseBean(paramTypes)).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{junctionTable.tablename});
    }

    private MethodInvoker toPrimaryKeyList(Method def) throws NoSuchMethodException, SecurityException {
        Method impl;
        Class<?>[] paramTypes = def.getParameterTypes();
        Class pkType = this.metaData.columnTypeOf(this.metaData.primaryKeyIds[0]);
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        if (Collection.class.isAssignableFrom(paramTypes[0])) {
            impl = this.getDeclaredMethod(M_TOPRIMARYKEYLIST, Class.class, Collection.class);
        } else {
            Object beanArray = Array.newInstance(this.metaData.beanType, 0);
            if (paramTypes[0] == beanArray.getClass()) {
                impl = this.getDeclaredMethod(M_TOPRIMARYKEYLIST, Class.class, BaseBean[].class);
            } else {
                throw this.makeNoSuchMethodException(def);
            }
        }
        return new MethodInvoker(def, impl, this.delegate, new Object[]{pkType});
    }

    private MethodInvoker listOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_LISTOFSELFREF);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LISTOFSELFREF);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_LISTOFSELFREF, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private MethodInvoker levelOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_LEVELOFSELFREF);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_LEVELOFSELFREF);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_LEVELOFSELFREF, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private MethodInvoker isCycleOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_ISCYCLEOFSELFREF);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_ISCYCLEOFSELFREF);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_ISCYCLEOFSELFREF, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private MethodInvoker checkCycleOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_CHECKCYCLEOFSELFREF);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_CHECKCYCLEOFSELFREF);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_CHECKCYCLEOFSELFREF, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, Object.class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private MethodInvoker topOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(P_TOPOFSELFREF);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)P_TOPOFSELFREF);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(D_TOPOFSELFREF, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, Object[].class).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private MethodInvoker childListOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        return this.methodOfRecursionOfSelfRef(def, P_CHILDLISTOFSELFREF, D_CHILDLISTOFSELFREF, Object[].class);
    }

    private MethodInvoker childrenOfSelfRef(Method def) throws NoSuchMethodException, SecurityException {
        return this.methodOfRecursionOfSelfRef(def, P_CHILDRENOFSELFREF, D_CHILDRENOFSELFREF, Object[].class);
    }

    private MethodInvoker childrenOfSelfRefForBeans(Method def) throws NoSuchMethodException, SecurityException {
        return this.methodOfRecursionOfSelfRef(def, P_CHILDRENOFBEANSOFSELFREF, D_CHILDRENOFBEANSOFSELFREF, null);
    }

    private MethodInvoker childrenOfSelfRefForPks(Method def) throws NoSuchMethodException, SecurityException {
        return this.methodOfRecursionOfSelfRef(def, P_CHILDRENOFPKSOFSELFREF, D_CHILDRENOFPKSOFSELFREF, null);
    }

    private MethodInvoker methodOfRecursionOfSelfRef(Method def, String regex, String delegateName, Class<?> normalizeFirstArgType) throws NoSuchMethodException, SecurityException {
        Class<?>[] paramTypes = def.getParameterTypes();
        String methodName = def.getName();
        Preconditions.checkArgument((paramTypes.length == 1 ? 1 : 0) != 0, (String)"only 1 parameter required for %s", (Object)def.getName());
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(methodName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"INVALID method name pattern,%s required", (Object)regex);
        String readableName = matcher.group(1);
        ForeignKeyMetaData selfRefKey = this.metaData.getSelfRefKeyByRn(readableName);
        Method impl = this.getDeclaredMethod(delegateName, TableManagerDecorator.paramBuilder().add(selfRefKey.name.getClass(), paramTypes).genericNormalize(1, normalizeFirstArgType).build());
        return new MethodInvoker(def, impl, this.delegate, new Object[]{selfRefKey.name});
    }

    private static final boolean isVoid(Class<?> clazz) {
        return "void".equals(clazz.getName());
    }

    private static final Class<?> wrapBaseBean(Class<?> type) {
        if (null != type) {
            if (type.isArray()) {
                Class<?> componentType = TableManagerDecorator.wrapBaseBean(type.getComponentType());
                if (componentType != type.getComponentType()) {
                    return Array.newInstance(componentType, 0).getClass();
                }
                return type;
            }
            if (BaseBean.class.isAssignableFrom(type)) {
                return BaseBean.class;
            }
            return type;
        }
        return type;
    }

    private static final Class<?>[] wrapBaseBean(Class<?> ... types) {
        if (null != types) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = TableManagerDecorator.wrapBaseBean(types[i]);
            }
        }
        return types;
    }

    private static ParamTypeBuilder paramBuilder() {
        return new ParamTypeBuilder();
    }

    private static Object stripedInvoke(Method method, Object obj, Object ... input) throws Throwable {
        try {
            return method.invoke(obj, input);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te != null) {
                throw te;
            }
            SimpleLog.log((String)e.toString(), (Object[])new Object[0]);
            throw e;
        }
    }

    private class SaveFullyInvoker
    extends MethodInvoker {
        private SaveFullyInvoker(Method def, Method impl) {
            super(def, impl, TableManagerDecorator.this.delegate, new Object[0]);
        }

        @Override
        public Object invoke(Object[] input) throws Throwable {
            return TableManagerDecorator.stripedInvoke(this.impl, this.manager, new Object[]{input[0], Arrays.copyOfRange(input, 1, input.length)});
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            builder.append("    @Override\n");
            builder.append("    public ").append(NameUtilities.signatureOf((Method)this.def, (boolean)true, (boolean)true)).append("{\n");
            builder.append("        ").append("return ").append("delegate.").append(this.impl.getName()).append("(");
            Class<?>[] paramTypes = this.def.getParameterTypes();
            builder.append("arg0,new Object[]{");
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    builder.append(", ");
                }
                builder.append("arg").append(j);
            }
            builder.append("});\n");
            builder.append("    }\n");
            return builder.toString();
        }
    }

    private class MethodInvoker
    implements Invoker {
        final Method def;
        final Method impl;
        protected final BaseTableManager<? extends BaseBean> manager;
        protected final Object[] additionalParams;
        private final Function<Object[], Object[]> argsMaker;
        private final Function<Object[], Object[]> defaultArgsMaker = new Function<Object[], Object[]>(){

            public Object[] apply(Object[] input) {
                return input;
            }
        };
        private final Function<Object[], Object[]> addparamArgsMaker = new Function<Object[], Object[]>(){

            public Object[] apply(Object[] input) {
                Object[] args = new Object[MethodInvoker.this.additionalParams.length + input.length];
                System.arraycopy(MethodInvoker.this.additionalParams, 0, args, 0, MethodInvoker.this.additionalParams.length);
                System.arraycopy(input, 0, args, MethodInvoker.this.additionalParams.length, input.length);
                return args;
            }
        };
        private final Function<Object[], Object[]> vaArgsMaker = new Function<Object[], Object[]>(){

            public Object[] apply(Object[] input) {
                Class<?>[] paramTypes = MethodInvoker.this.impl.getParameterTypes();
                Object[] args = new Object[paramTypes.length];
                System.arraycopy(MethodInvoker.this.additionalParams, 0, args, 0, MethodInvoker.this.additionalParams.length);
                args[MethodInvoker.this.additionalParams.length] = input[0] instanceof Object[] ? input[0] : input;
                return args;
            }
        };

        private MethodInvoker(Method def, Method impl, BaseTableManager<? extends BaseBean> manager, Object ... additionalParams) {
            this.def = def;
            this.impl = impl;
            if (!Modifier.isPublic(impl.getModifiers())) {
                impl.setAccessible(true);
            }
            this.manager = (BaseTableManager)Preconditions.checkNotNull(manager, (Object)"manager is null");
            this.additionalParams = (Object[])MoreObjects.firstNonNull((Object)additionalParams, (Object)EMPTY_OBJECT_ARRAY);
            Class<?>[] paramTypes = impl.getParameterTypes();
            this.argsMaker = paramTypes.length == additionalParams.length + 1 && Object[].class.equals(paramTypes[additionalParams.length]) ? this.vaArgsMaker : (additionalParams.length == 0 ? this.defaultArgsMaker : this.addparamArgsMaker);
        }

        @Override
        public Object invoke(Object[] input) throws Throwable {
            return TableManagerDecorator.stripedInvoke(this.impl, this.manager, (Object[])this.argsMaker.apply(MoreObjects.firstNonNull((Object)input, (Object)MethodInvoker.EMPTY_OBJECT_ARRAY)));
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            builder.append("    @Override\n");
            builder.append("    public ").append(NameUtilities.signatureOf((Method)this.def, (boolean)true, (boolean)true)).append("{\n");
            builder.append("        ");
            if (!TableManagerDecorator.isVoid(this.def.getReturnType())) {
                builder.append("return ");
            }
            builder.append(this.manager == TableManagerDecorator.this.delegate ? "delegate." : BaseTableManager.class.getName() + ".instanceOf(" + this.manager.getClass().getName() + ".class).");
            builder.append(this.impl.getName());
            builder.append("(");
            for (i = 0; i < this.additionalParams.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                if (this.additionalParams[i] instanceof String) {
                    builder.append("\"" + this.additionalParams[i] + "\"");
                    continue;
                }
                if (this.additionalParams[i] instanceof Class) {
                    builder.append(((Class)this.additionalParams[i]).getName() + ".class");
                    continue;
                }
                builder.append(this.additionalParams[i]);
            }
            Class<?>[] paramTypes = this.def.getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                if (i++ > 0) {
                    builder.append(",");
                }
                builder.append("arg").append(j);
            }
            builder.append(");\n");
            builder.append("    }\n");
            return builder.toString();
        }
    }

    private class ObjectInvoker
    implements Invoker {
        final Method method;

        ObjectInvoker(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object[] input) throws Throwable {
            return TableManagerDecorator.stripedInvoke(this.method, TableManagerDecorator.this.delegate, (Object[])MoreObjects.firstNonNull((Object)input, (Object)ObjectInvoker.EMPTY_OBJECT_ARRAY));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            builder.append("    @Override\n");
            builder.append("    public ").append(NameUtilities.signatureOf((Method)this.method, (boolean)true, (boolean)true)).append("{\n");
            builder.append("        ");
            if (!TableManagerDecorator.isVoid(this.method.getReturnType())) {
                builder.append("return ");
            }
            builder.append("delegate.").append(this.method.getName()).append("(");
            Class<?>[] paramTypes = this.method.getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                if (j > 0) {
                    builder.append(",");
                }
                builder.append("arg").append(j);
            }
            builder.append(");\n");
            builder.append("    }\n");
            return builder.toString();
        }
    }

    static interface Invoker {
        public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

        public Object invoke(Object[] var1) throws Throwable;
    }

    static class ParamTypeBuilder {
        List<Class<?>> builder = Lists.newLinkedList();

        ParamTypeBuilder() {
        }

        ParamTypeBuilder add(Class<?> type) {
            this.builder.add(type);
            return this;
        }

        ParamTypeBuilder add(Class<?>[] types, int start) {
            this.builder.addAll(Arrays.asList(Arrays.copyOfRange(types, start, types.length)));
            return this;
        }

        ParamTypeBuilder add(Class<?> type, Class<?> ... types) {
            this.builder.add(type);
            this.builder.addAll(Arrays.asList(types));
            return this;
        }

        ParamTypeBuilder genericNormalize(int index, Class<?> normalizeClass) {
            try {
                Class<?> type = this.builder.get(index);
                if (BaseBean.class.isAssignableFrom(type)) {
                    this.builder.set(index, BaseBean.class);
                } else if (null != normalizeClass) {
                    this.builder.set(index, normalizeClass);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(SimpleLog.logString((String)"INVALID index %s for  parameter types array", (Object[])new Object[]{index}));
            }
            return this;
        }

        ParamTypeBuilder normalizeLast(int index, Class<?> normalizeClass) {
            try {
                Class<?> type = this.builder.get(index);
                if (BaseBean.class.isAssignableFrom(type)) {
                    this.builder.set(index, BaseBean.class);
                } else {
                    this.builder.set(index, normalizeClass);
                }
                while (this.builder.size() > index + 1) {
                    this.builder.remove(index + 1);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(SimpleLog.logString((String)"INVALID index %s for  parameter types array", (Object[])new Object[]{index}));
            }
            return this;
        }

        Class<?>[] build() {
            return this.builder.toArray(new Class[0]);
        }
    }
}

