/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import gu.sql2java.Constant;
import gu.sql2java.DataSourceConfig;
import gu.sql2java.DataSourceFactory;
import gu.sql2java.SimpleLog;
import javax.sql.DataSource;

public class C3p0DataSourceFactory
implements DataSourceFactory {
    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        try {
            config.logDatabaseProperties();
            ComboPooledDataSource ds = new ComboPooledDataSource();
            ds.setDriverClass(config.getJdbcDriver());
            ds.setUser(config.getJdbcUsername());
            ds.setPassword(config.getJdbcPassword());
            ds.setJdbcUrl(config.getJdbcUrl());
            ds.setMaxPoolSize(Integer.parseInt(config.getInitProperty(Constant.JdbcProperty.C3P0_MAXPOOLSIZE.key, "100")));
            ds.setMinPoolSize(Integer.parseInt(config.getInitProperty(Constant.JdbcProperty.C3P0_MINPOOLSIZE.key, "10")));
            ds.setMaxIdleTime(Integer.parseInt(config.getInitProperty(Constant.JdbcProperty.C3P0_MAXIDLETIME.key, "120")));
            ds.setIdleConnectionTestPeriod(Integer.parseInt(config.getInitProperty(Constant.JdbcProperty.C3P0_IDLECONNECTIONTESTPERIOD.key, "120")));
            return ds;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("can't get connection by argument...driver/url/username/password[%s/%s/%s/%s]", config.getJdbcDriver(), config.getJdbcUrl(), config.getJdbcUsername(), config.getJdbcPassword()), e);
        }
    }

    @Override
    public void destroy(DataSource dataSource) {
        try {
            DataSources.destroy((DataSource)dataSource);
        }
        catch (Exception e) {
            SimpleLog.log((String)("dispose pool wrong ..." + e), (Object[])new Object[0]);
        }
    }
}

