/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.parser;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import gu.sql2java.pagehelper.PageException;
import gu.sql2java.parser.CountSqlParser;
import gu.sql2java.parser.SqlSyntaxNormalizer;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.CCJSqlParserVisitor;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;

public class ParserSupport {
    private static final CountSqlParser countSqlParser = new CountSqlParser();

    public static Select parseSelect(String sql) {
        Statement stmt;
        try {
            stmt = CCJSqlParserUtil.parse((String)((String)Preconditions.checkNotNull((Object)sql, (Object)"sql is null")));
        }
        catch (JSQLParserException e) {
            throw new PageException((Throwable)e);
        }
        Preconditions.checkArgument((boolean)(stmt instanceof Select), (String)"%s is not  SELECT statment", (Object)sql);
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        Preconditions.checkArgument((boolean)(selectBody instanceof PlainSelect), (String)"ONLY SUPPORT plain select statement %s", (Object)sql);
        return (Select)stmt;
    }

    public static Select parseSelectUnchecked(String sql) {
        try {
            return ParserSupport.parseSelect(sql);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String countSql(Select select, String countColumn) {
        if (null != select) {
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                plainSelect.setOffset(null);
                plainSelect.setLimit(null);
            }
            return countSqlParser.getSmartCountSql(select, Strings.isNullOrEmpty((String)countColumn) ? "0" : countColumn);
        }
        return null;
    }

    public static String countSql(String sql, String countColumn) {
        Select select;
        if (!Strings.isNullOrEmpty((String)sql) && null != (select = ParserSupport.parseSelectUnchecked(sql))) {
            return ParserSupport.countSql(select, countColumn);
        }
        return null;
    }

    public static Statement parse(String sql, CCJSqlParserVisitor visitor, SqlSyntaxNormalizer sqlSyntaxNormalizer) throws JSQLParserException {
        return ParserSupport.parse0((String)sql, (CCJSqlParserVisitor)visitor, (SqlSyntaxNormalizer)sqlSyntaxNormalizer).statement;
    }

    public static SqlParserInfo parse0(String sql, CCJSqlParserVisitor visitor, SqlSyntaxNormalizer sqlSyntaxAnalyzer) throws JSQLParserException {
        Statement stmt;
        Preconditions.checkArgument((null != sql ? 1 : 0) != 0, (Object)"sql is null");
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth((String)sql) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser((String)sql).withAllowComplexParsing(allowComplexParsing);
        try {
            stmt = parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException((Throwable)ex);
        }
        if (null != visitor) {
            parser.getASTRoot().jjtAccept(visitor, null);
        }
        if (null != sqlSyntaxAnalyzer) {
            stmt.accept((StatementVisitor)sqlSyntaxAnalyzer.resetChanged());
        }
        return new SqlParserInfo(stmt.toString(), stmt, (SimpleNode)parser.getASTRoot());
    }

    public static <T> T parseComponent(String input, String method, Class<T> targetType) {
        try {
            CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(input));
            try {
                return ((Class)Preconditions.checkNotNull(targetType, (Object)"targetType is null")).cast(parser.getClass().getMethod(method, new Class[0]).invoke((Object)parser, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseComponent(String input, Class<T> targetType) {
        return ParserSupport.parseComponent(input, ((Class)Preconditions.checkNotNull(targetType, (Object)"targetType is null")).getSimpleName(), targetType);
    }

    public static boolean isBoolean(Column column) {
        return null != column && null == column.getTable() && Pattern.compile("(true|false)", 2).matcher(column.getColumnName()).matches();
    }

    public static class SqlParserInfo {
        final String nativeSql;
        final Statement statement;
        final SimpleNode simpleNode;

        SqlParserInfo(String nativeSql, Statement statement, SimpleNode simpleNode) {
            this.nativeSql = nativeSql;
            this.statement = statement;
            this.simpleNode = simpleNode;
        }
    }
}

