/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.phoenix;

import gu.sql2java.parser.SqlSyntaxNormalizer;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Consumer;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;

public class PhoenixNormalizer
extends SqlSyntaxNormalizer {
    private Expression castToFunction(Expression castLeftExpression, String format, String targetFunctionName) {
        Function toChar = new Function().withName("TO_CHAR").withParameters(new ExpressionList().addExpressions(new Expression[]{castLeftExpression}));
        Function targetFunction = new Function().withName(targetFunctionName).withParameters(new ExpressionList().addExpressions(new Expression[]{toChar, new StringValue(format)}));
        return targetFunction;
    }

    private void onCastExpression(CastExpression castExpression, Consumer<Expression> consumer) {
        Expression newExp = null;
        switch (castExpression.getType().toString().toLowerCase()) {
            case "date": {
                newExp = this.castToFunction(castExpression.getLeftExpression(), "yyyy-MM-dd", "TO_DATE");
                changed.set(true);
                break;
            }
            case "time": {
                newExp = this.castToFunction(castExpression.getLeftExpression(), "yyyy-MM-dd HH:mm:ss", "TO_TIME");
                changed.set(true);
                break;
            }
            case "timestamp": {
                newExp = this.castToFunction(castExpression.getLeftExpression(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "TO_TIMESTAMP");
                changed.set(true);
                break;
            }
        }
        if (null != newExp) {
            consumer.accept(newExp);
        }
    }

    public void visit(SelectExpressionItem item) {
        if (item.getExpression() instanceof CastExpression) {
            this.onCastExpression((CastExpression)item.getExpression(), arg_0 -> ((SelectExpressionItem)item).setExpression(arg_0));
        }
        super.visit(item);
    }

    String castFormat(String format) {
        String fmt;
        if (null != format && (fmt = format.replace("%Y", "yyyy").replace("%y", "yy").replace("%m", "MM").replaceAll("%[de]", "dd").replaceAll("%[Hk]", "HH").replace("%i", "mm").replaceAll("%[sS]", "ss").replace("%W", "E").replace("%j", "D").replace("%T", "hh:mm:ss").replace("%r", "hh:mm:ss a").replaceAll("%[Uu]", "w").replace("%%", "%")).indexOf(37) < 0) {
            return fmt;
        }
        return format;
    }

    public void visit(Function function) {
        List expressions;
        if ("DATE_FORMAT".equalsIgnoreCase(function.getName()) && null != (expressions = function.getParameters().getExpressions()) && 2 == expressions.size()) {
            Function convertTz = this.createConvertTzFunction((Expression)expressions.get(0));
            expressions.set(0, convertTz);
            function.setName("TO_CHAR");
            Expression formatExp = (Expression)expressions.get(1);
            if (formatExp instanceof StringValue) {
                StringValue stringValue = (StringValue)formatExp;
                stringValue.setValue(this.castFormat(stringValue.getValue()));
            }
        }
        super.visit(function);
    }

    private Function createConvertTzFunction(Expression exp) {
        String zone = TimeZone.getDefault().getID();
        Function convertTz = new Function();
        convertTz.setName("CONVERT_TZ");
        ExpressionList exps = new ExpressionList();
        exps.addExpressions(new Expression[]{exp, new StringValue("UTC"), new StringValue(zone)});
        convertTz.setParameters(exps);
        return convertTz;
    }
}

