package gu.sql2java.manager;

import static com.google.common.base.Preconditions.checkNotNull;

import java.util.LinkedList;
import java.util.List;

import com.google.common.base.Function;

import gu.sql2java.BaseBean;
import gu.sql2java.TableManager;
import gu.sql2java.TableManager.Action;
import gu.sql2java.pagehelper.Page;
import gu.sql2java.pagehelper.PageHelper;

/**
 * @author guyadong
 *
 * @param <B>
 * @since 3.18.3
 */
class ListAction<B extends BaseBean> implements TableManager.Action<B> {
    final List<B> list;
	public ListAction() {
		this(false);
    }
	/**
	 * @param nopage disable page helper if true
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
    public ListAction(boolean nopage) {
    	Page page;
    	if(!nopage && null != (page = PageHelper.getLocalPage()) && page.isEnable()){
    		list = page;
    	}else{
    		list = new LinkedList<>();
    	}
    }

    public List<B> getList() {
        return list;
    }
    @SuppressWarnings("unchecked")
    public <T> List<T> getList(Function<B, T>transformer) {
        return PageHelper.transform(list,checkNotNull(transformer,"transformer is null"));
    }

    @Override
    public void call(B bean) {
        list.add(bean);
    }

}